#include <QMainWindow>
#include <QTableView>
#include <QPushButton>
#include <QToolBar>
#include <QVBoxLayout>
#include <QItemSelectionModel>
#include <QList>
#include <QLabel>
#include <QXmlDefaultHandler>

#include "data.h"
#include "table-model.h"

class MainWindow : public QMainWindow
{
  Q_OBJECT

public:
  MainWindow(QMainWindow *parent = 0);
  void createLayout(QWidget *parent = 0);
  void createStatusBar();
  void createTableView(QList<Score *> &, QList <Club *> &);
  void updateStatusBar();
  void loadScoreFile(QString &fileName, QList<Score *> &scoreList);
  void loadClubFile(QString &fileName, QList<Club *> &clubList);
  void saveScoreFile(QString &fileName, QList<Score *> &scoreList);
  void saveClubFile(QString &fileName, QList<Club *> &clubList);

signals:
  void dataChanged();

private slots:
  void firstButtonClicked();
  void lastButtonClicked();
  void nextButtonClicked();
  void prevButtonClicked();

  void newScore();
  void editScore();
  void newCourse();
  void editCourse();

private:

  void loadSettings(void);
  Club *findClub(QString &name);

  QList<Score *> scoreList;
  QList<Club *> clubList;

  ScoreTableModel *scoreTableModel;

  QAbstractItemModel *tableModel;
  QItemSelectionModel *selectionModel;

  QTableView *table;

  // Layouts
  QVBoxLayout *tableLayout;
  QVBoxLayout *buttonLayout;

  // Menus
  QMenu *menu;

  // Buttons
  QPushButton *nextButton;
  QPushButton *prevButton;
  QPushButton *firstButton;
  QPushButton *lastButton;

  // Toolbar
  QToolBar *toolbar;

  // Actions
  QAction *newScoreAct;
  QAction *editScoreAct;
  QAction *newCourseAct;
  QAction *editCourseAct;
  QAction *firstAct;
  QAction *lastAct;
  QAction *nextAct;
  QAction *prevAct;

  QAction *viewScoreAct;
  QAction *viewCourseAct;
  QAction *viewStatisticAct;

  void createMenus();
  void createActions();


};
