#ifndef RESULT_H
#define RESULT_H

/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <vector>

#include "Card.h"

class Result
{
private:
  std::vector<Card> collected;

  size_t            scopas;
  size_t            cards;
  size_t            denares;
  bool              denare7;
  size_t            primieraPoints;

public:
  Result();

  void AddToCollected(const std::vector<Card>& cards, bool scopa);
  void SetPrimieraPoints(size_t points);

  size_t GetHighestPointsOfColor(Card::Color color) const;

  size_t GetScopas() const;
  size_t GetCards() const;
  size_t GetDenares() const;
  bool HasDenare7() const;
  size_t GetPrimieraPoints() const;
  size_t GetTemporaryPoints() const;
};

#endif

