#ifndef PLAYERGOAL_H
#define PLAYERGOAL_H

/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "Player.h"

class GoalPlayer : public Player
{
private:
  bool   goalDenare7;
  bool   goalDenare;
  bool   goalPrimera;
  bool   goalMostCards;

  size_t myDenare;
  size_t yourDenare;

  size_t yourCards;
  size_t myCards;

  size_t mySevens;
  size_t yourSevens;
  size_t mySixs;
  size_t yourSixs;

  size_t statScopa;
  size_t statDenare7;
  size_t statDenare;
  size_t statPrimera;
  size_t statMostCards;
  size_t statAbove10;
  size_t statBelow10;
  size_t statRandom;

public:
  GoalPlayer();

  void Initialize();

  SolutionSet PlayCard(const Table& table, size_t round);

  void CardsPlayed(std::vector<Card>& cards,
                   bool ownCards, size_t round);

  void PrintStatistics();
};


#endif

