#ifndef NEURONALNETWORK_H
#define NEURONALNETWORK_H

/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2009  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <vector>

class NeuronalNetwork
{
private:
  size_t inputSize;
  size_t hiddenSize;
  size_t outputSize;

  std::vector<double> input;

  std::vector<double> hidden;
  std::vector<std::vector<double> > hiddenWeight;

  std::vector<double> output;
  std::vector<std::vector<double> > outputWeight;

private:
  double ActivationFunction(double value) const;

public:
  NeuronalNetwork(size_t inputSize, size_t hiddenSize, size_t outputSize);

  void Initialize();

  void SetInput(size_t pos, double value);
  void SetHiddenWeight(size_t hiddenIndex, size_t inputIndex, double value);
  void SetOutputWeight(size_t outputIndex, size_t hiddenIndex, double value);
  void CalculateOutputFromInput();

  double GetInput(size_t index) const;
  double GetHidden(size_t index) const;
  double GetHiddenWeight(size_t outputIndex, size_t hiddenIndex) const;
  double GetOutputWeight(size_t outputIndex, size_t hiddenIndex) const;
  double GetOutput(size_t index) const;
};

#endif

