/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "Heap.h"

#include <cassert>
#include <cstdlib>

Heap::Heap()
{
  // no code
}

void Heap::InitializeAndMix()
{
  std::vector<Card> tmp,tmp2;

  tmp.reserve(40);
  for (Card card=Card::minCard; card<=Card::maxCard; ++card) {
    tmp.push_back(card);
  }

  for (size_t i=1; i<=20; i++) {
    tmp2.clear();
    tmp2.reserve(40);

    while (!tmp.empty()) {
      size_t pos=(size_t)(double(tmp.size())*rand()/RAND_MAX);

      tmp2.push_back(tmp[pos]);
      tmp.erase(tmp.begin()+pos);
    }

    tmp=tmp2;
  }

  heap=tmp;
}

bool Heap::IsEmpty() const
{
  return heap.empty();
}

Card Heap::GetCard()
{
  assert(!heap.empty());

  Card card=heap.back();

  heap.pop_back();

  return card;
}

