#ifndef TABLE_H
#define TABLE_H

/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <map>
#include <vector>

#include "Card.h"

class SolutionSet
{
public:
  Card               yours;    //! The card played
  size_t             yoursPos; //! The position of this hard in the given hand
  std::vector<Card>  table;    //! The cards on the table that have been taken
  size_t             solution; //! The position of this solution in the list of all possible solutions
  bool               scopa;    //! The move resulted in a scopa

public:
  SolutionSet(const Card& yours);

  bool IsTrick() const;
};

class Table
{
public:
  std::vector<Card>                      table;         //! The cards on the table
  std::vector<std::vector<size_t> >      combinations;  //! The list of allowed combinations
  std::map<size_t,std::vector<size_t> >  points;        //! The reference of combinations for a specific value

public:
  static void Calculate(const std::vector<Card>& table,
                        std::vector<std::vector<size_t> >& combinations,
                        std::map<size_t,std::vector<size_t> >& points);
  static void GetSolutionSets(const std::vector<Card>& hand,
                              const std::vector<Card>& table,
                              const std::vector<std::vector<size_t> >& combinations,
                              const std::map<size_t,std::vector<size_t> >& points,
                              std::vector<SolutionSet>& solutions);

private:
  void Calculate();

public:
  void Initialize(const std::vector<Card>& initialCards);

  bool IsEmpty() const;

  bool HasValueMultipleCollectionSets(size_t value) const;
  void GetMoves(size_t value, std::vector<std::vector<Card> >& moves) const;

  std::vector<Card> PutCard(const Card& card, size_t solution=0);

  void GetSolutionSets(const std::vector<Card>& hand, std::vector<SolutionSet>& solutions) const;
  size_t GetValueOnTable() const;
};

#endif

