/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2009  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "NeuronalNetwork.h"

#include <cassert>
#include <cmath>
#include <cstdlib> // TODO: Remove
#include <ctime>

#include <iostream>
NeuronalNetwork::NeuronalNetwork(size_t inputSize, size_t hiddenSize, size_t outputSize)
 : inputSize(inputSize),
   hiddenSize(hiddenSize),
   outputSize(outputSize)
{
  Initialize();

  std::cout << "A: " << ActivationFunction(-1) << " " << ActivationFunction(0) << " " << ActivationFunction(1) << std::endl;
}

void NeuronalNetwork::Initialize()
{
  srand(time(NULL));

  input.resize(inputSize+1,0.0);
  for (size_t i=0; i<input.size(); i++) {
    input[i]=0;
  }
  input[inputSize]=-1;

  hidden.resize(hiddenSize+1,0.0);
  for (size_t i=0; i<hidden.size(); i++) {
    hidden[i]=0;
  }
  hidden[hiddenSize]=-1;


  double rh=1/sqrt((double)inputSize);
  double ro=1/sqrt((double)hiddenSize);

  hiddenWeight.resize(hidden.size());
  for (size_t i=0; i<hidden.size(); i++) {
    hiddenWeight[i].resize(input.size(),0.1);
    for (size_t j=0; j<hiddenWeight[i].size(); j++) {
      hiddenWeight[i][j]=(((double)(rand()%100)+1)/100 * 2 * rh)-rh;
    }
  }

  output.resize(outputSize,0.0);
  outputWeight.resize(output.size());
  for (size_t i=0; i<output.size(); i++) {
    outputWeight[i].resize(hidden.size(),0.1);
    for (size_t j=0; j<outputWeight[i].size(); j++) {
      outputWeight[i][j]=(((double)(rand()%100)+1)/100 * 2 * ro)-ro;
    }
  }
}

double NeuronalNetwork::ActivationFunction(double value) const
{
  if (value>1) {
    return 1;
  }
  else if (value<-1) {
    return -1;
  }
  else {
    return value;
  }

  //return 1/(1+exp(-value));

  //return value;
}

void NeuronalNetwork::SetInput(size_t pos, double value)
{
  assert(pos<input.size());

  input[pos]=value;
}

void NeuronalNetwork::SetHiddenWeight(size_t hiddenIndex, size_t inputIndex, double value)
{
  assert(hiddenIndex<hiddenSize && inputIndex<inputSize);

  hiddenWeight[hiddenIndex][inputIndex]=value;
}
void NeuronalNetwork::SetOutputWeight(size_t outputIndex, size_t hiddenIndex, double value)
{
  assert(outputIndex<outputSize && hiddenIndex<hiddenSize);

  outputWeight[outputIndex][hiddenIndex]=value;
}

void NeuronalNetwork::CalculateOutputFromInput()
{
  for (size_t i=0; i<hidden.size(); i++) {
    hidden[i]=0.0;

    for (size_t j=0; j<input.size(); j++) {
      hidden[i]+=ActivationFunction(input[j]*hiddenWeight[i][j]);
    }
  }

  for (size_t i=0; i<output.size(); i++) {
    output[i]=0.0;

    for (size_t j=0; j<hidden.size(); j++) {
      output[i]+=ActivationFunction(hidden[j]*outputWeight[i][j]);
    }
  }
}

double NeuronalNetwork::GetInput(size_t index) const
{
  assert(index<inputSize);

  return input[index];
}

double NeuronalNetwork::GetHidden(size_t index) const
{
  assert(index<hiddenSize);

  return hidden[index];
}

double NeuronalNetwork::GetHiddenWeight(size_t hiddenIndex, size_t inputIndex) const
{
  assert(hiddenIndex<hiddenSize && inputIndex<inputSize);

  return hiddenWeight[hiddenIndex][inputIndex];
}

double NeuronalNetwork::GetOutputWeight(size_t outputIndex, size_t hiddenIndex) const
{
  assert(outputIndex<outputSize && hiddenIndex<hiddenSize);

  return outputWeight[outputIndex][hiddenIndex];
}


double NeuronalNetwork::GetOutput(size_t index) const
{
  assert(index<outputSize);

  return output[index];
}

