/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "Result.h"

Result::Result()
 : scopas(0),
   cards(0),
   denares(0),
   denare7(false)
{
  // no code
}

void Result::AddToCollected(const std::vector<Card>& cards, bool scopa)
{
  for (size_t card=0; card<cards.size(); card++) {
    collected.push_back(cards[card]);
  }

  // Updating result...

  if (scopa) {
    scopas++;
  }

  this->cards+=cards.size();

  for (size_t card=0; card<cards.size(); card++) {
    if (cards[card].GetColor()==Card::denare) {
      denares++;
    }
    if (cards[card].GetColor()==Card::denare && cards[card].GetValue()==7) {
      denare7=true;
    }
  }
}

void Result::SetPrimieraPoints(size_t points)
{
  primieraPoints=points;
}

size_t Result::GetHighestPointsOfColor(Card::Color color) const
{
  size_t points=0;

  for (size_t card=0; card<collected.size(); card++) {
    if (collected[card].GetColor()==color && collected[card].GetPoints()>points) {
      points=collected[card].GetPoints();
    }
  }

  return points;
}

size_t Result::GetScopas() const
{
  return scopas;
}

size_t Result::GetCards() const
{
  return cards;
}

size_t Result::GetDenares() const
{
  return denares;
}

bool Result::HasDenare7() const
{
  return denare7;
}

size_t Result::GetPrimieraPoints() const
{
  return primieraPoints;
}

size_t Result::GetTemporaryPoints() const
{
  size_t points=0;
  size_t primieraPoints=0;

  points+=GetScopas();

  if (GetCards()>20) {
    points++;
  }

  if (GetDenares()>5) {
    points++;
  }

  if (HasDenare7()) {
    points++;
  }

  primieraPoints+=GetHighestPointsOfColor(Card::spade);
  primieraPoints+=GetHighestPointsOfColor(Card::cope);
  primieraPoints+=GetHighestPointsOfColor(Card::bastone);
  primieraPoints+=GetHighestPointsOfColor(Card::denare);

  if (primieraPoints>2*21+2*18) {
    points++;
  }

  return points;
}

