/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "Card.h"

#include <cassert>

#include <Lum/Base/String.h>

const Card Card::minCard(Card::spade,1);
const Card Card::maxCard(Card::denare,10);

Card::Card(Color color, size_t value)
 : color(color),
   value(value)
{
  // no code
}

bool Card::operator<(const Card& card) const
{
  if (color==card.color) {
    return value<card.value;
  }
  else {
    return color<card.color;
  }
}

bool Card::operator<=(const Card& card) const
{
  if (color==card.color) {
    return value<=card.value;
  }
  else {
    return color<card.color;
  }
}

bool Card::operator>(const Card& card) const
{
  if (color==card.color) {
    return value>card.value;
  }
  else {
    return color>card.color;
  }
}

bool Card::operator>=(const Card& card) const
{
  if (color==card.color) {
    return value>=card.value;
  }
  else {
    return color>card.color;
  }
}

bool Card::operator==(const Card& card) const
{
  return color==card.color && value==card.value;
}

bool Card::operator!=(const Card& card) const
{
  return color!=card.color || value!=card.value;
}

Card& Card::operator++()
{
  if (value==10) {
    value=1;
    color=(Color)(((int)color)+1);
  }
  else {
    value++;
  }

  return *this;
}

std::wstring Card::GetFilename() const
{
  std::wstring name;

  switch (color) {
  case spade:
    name=L"s";
    break;
  case cope:
    name=L"c";
    break;
  case bastone:
    name=L"b";
    break;
  case denare:
    name=L"d";
    break;
  default:
    assert(false);
    break;
  }

  name.append(Lum::Base::NumberToWString(GetValue()));

  return name;
}

std::wstring Card::GetColorName() const
{
  switch (color) {
  case spade:
    return L"Spade";
  case cope:
    return L"Cope";
  case bastone:
    return L"Bastone";
  case denare:
    return L"Denare";
  default:
    assert(false);
    break;
  }
}

std::wstring Card::GetValueName() const
{
  switch (GetValue()) {
  case 8:
    return L"Joker";
    break;
  case 9:
    return L"Queen";
    break;
  case 10:
    return L"King";
    break;
  default:
    return Lum::Base::NumberToWString(GetValue());
    break;
  }
}

size_t Card::GetIndex() const
{
  size_t index;

  switch (color) {
  case spade:
    index=0;
    break;
  case cope:
    index=10;
    break;
  case bastone:
    index=20;
    break;
  case denare:
    index=30;
    break;
  default:
    assert(false);
    break;
  }

  index+=GetValue()-1;

  return index;
}

std::wstring Card::GetName() const
{
  return GetColorName()+L" "+GetValueName();
}

Card::Color Card::GetColor() const
{
  return color;
}

size_t Card::GetValue() const
{
  return value;
}

size_t Card::GetPoints() const
{
  switch (value) {
  case 1:
    return 16;
  case 2:
    return 12;
  case 3:
    return 13;
  case 4:
    return 14;
  case 5:
    return 15;
  case 6:
    return 18;
  case 7:
    return 21;
  case 8:
    return 10;
  case 9:
    return 10;
  case 10:
    return 10;
  }

  assert(false);
}

