#ifndef PLAYERNEURON_H
#define PLAYERNEURON_H

/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2009  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "Player.h"

#include "NeuronalNetwork.h"

class NeuronPlayer : public Player
{
private:
  struct State
  {
    std::vector<Card> myCards;
    std::vector<Card> yourCards;
    std::vector<Card> hand;
    std::vector<Card> table;
  };

  NeuronalNetwork     nn;

  std::vector<Card>   myCards;
  std::vector<Card>   yourCards;
  std::vector<std::vector<double> > inputs;
  std::vector<std::vector<double> > output;
  std::vector<double>               points;
  std::vector<std::vector<double> > rewards;
  std::vector<double>               expected;

  std::vector<double> oeg; // outputErrorGradient
  std::vector<double> heg; // hiddenErrorGradient
  std::vector<std::vector<double> > dho; // deltaHiddenOutput
  std::vector<std::vector<double> > dih; // deltaHiddenOutput

private:
  void GetInput(std::vector<double>& input, const State& state, size_t round);
  void Learn(const std::vector<double>& expected, const std::vector<double>& received);

public:
  NeuronPlayer();

  void Initialize();

  SolutionSet PlayCard(const Table& table, size_t round);
  void CardsPlayed(std::vector<Card>& cards,
                   bool ownCards,
                   size_t round);
  void RoundFinished(size_t round,
                     size_t pointsMe, size_t pointsOther);
};

#endif

