#ifndef CARDAREA_H
#define CARDAREA_H

/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Object.h>

#include <Lum/Images/Image.h>

#include <Lum/Model/Action.h>

#include "Card.h"

class CardArea : public Lum::Object
{
public:
  class Selection : public Lum::Base::ResyncMsg
  {
  private:
    size_t cardIndex;

  public:
    Selection(size_t cardIndex);

    size_t GetCardIndex() const;
  };

  class Entry
  {
  public:
    enum State {
      stateEmpty,
      stateFilled,
      stateAppears,
      stateDisappears
    };

  public:
    size_t index;      //! The Index into the cards array
    bool   selected;   //! This entry is selected
    State  state;      //! The current state of the entry
    size_t visibility; //! The visibility of this entry (for stateAppears and stateDisappears)

  public:
    bool IsEmpty() const;
    bool IsSet() const;
  };

private:
  Lum::OS::ColorRef                  backgroundColor;
  size_t                             cardWidth;
  size_t                             cardHeight;
  size_t                             columns;
  size_t                             rows;
  std::vector<Entry>                 entries;
  std::vector<Card>                  oldCards;
  std::vector<Card>                  cards;
  std::vector<Lum::Images::ImageRef> images;
  Lum::Model::ActionRef              timerAction;

  Lum::Model::ActionRef              selectionAction;
  Lum::Model::ActionRef              fadeFinishedAction;

private:
  void Unselect();
  void FadeInitial();
  void Fade();
  void DrawCardInternal(size_t row, size_t column);
  void DrawCard(size_t row, size_t column);
  void DrawCard(size_t index);

public:
  CardArea();

  void SetSize(size_t columns, size_t rows);
  void SetImages(const std::vector<Lum::Images::ImageRef>& images);

  void SetSelectionAction(Lum::Model::Action* action);
  void SetFadeFinishedAction(Lum::Model::Action* action);

  //void SetModel(const Sudoku &riddle, const Sudoku &solution);

  void SetCards(const std::vector<Card>& cards, bool fade=false);

  void CalcSize();

  void Draw(int x, int y, size_t w, size_t h);

  bool HandleMouseEvent(const Lum::OS::MouseEvent& event);
  void Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg);
};

#endif
