#ifndef GAMESTARTDIALOG_H
#define GAMESTARTDIALOG_H

/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Dlg/ActionDialog.h>

#include <Lum/Model/Action.h>
#include <Lum/Model/Integer.h>
#include <Lum/Model/String.h>

#include "Result.h"

class GameStartDialog : public Lum::Dlg::ActionDialog
{
private:
  Lum::Model::ActionRef commitAction;
  Lum::Model::StringRef points;
  Lum::Model::SizeTRef  player;
  bool                  success;

public:
  GameStartDialog(size_t points, size_t player);

  Lum::Object* GetContent();
  void GetActions(std::vector<Lum::Dlg::ActionInfo>& actions);

  void Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg);

  bool GetSuccess() const;
  size_t GetPoints() const;
  size_t GetPlayer() const;
};

extern bool ShowGameStartDialog(Lum::Dialog* parent, size_t& points, size_t& player);

#endif

