#ifndef ROUNDRESULTDIALOG_H
#define ROUNDRESULTDIALOG_H

/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Dialog.h>
#include <Lum/Text.h>

#include "Result.h"

class RoundResultDialog : public Lum::Dialog
{
private:
  std::vector<Result> result;
  std::vector<size_t> points;
  size_t              globalPoints[2];

private:
  Lum::Text* GetTableEntry(const std::wstring& string, bool bold=false);

public:
  RoundResultDialog(const std::vector<Result> result,
                    const std::vector<size_t>& points,
                    size_t globalPoints[2]);

  void PreInit();
  void Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg);
};

extern void ShowRoundResult(Lum::Dialog* parent,
                            const std::vector<Result> result,
                            const std::vector<size_t>& points,
                            size_t globalPoints[2]);

#endif

