 #include <gdk/gdkx.h>
#include <gtk/gtk.h>

/*
//--------------------------------------------------------------------------------
// FUNCTION : capture specify rectangle
// PARAM :
// RETURN : screen pixbuf pointer
//--------------------------------------------------------------------------------
GdkPixbuf *CaptureScreenEx(gint x, gint y, gint nWidth, gint nHeight)
{
	GdkScreen		*screen    = NULL;
	GdkWindow	*window = NULL;
	GdkPixbuf		*ppbScreen= NULL;

	screen = gdk_screen_get_default();
	window = gdk_screen_get_root_window (screen);
	ppbScreen = gdk_pixbuf_get_from_drawable (NULL, window, NULL, x, y, 0, 0, nWidth, nHeight);

	return ppbScreen;
}
*/
//--------------------------------------------------------------------------------
// FUNCTION : capture full screen
// PARAM :
// RETURN : screen pixbuf pointer
//--------------------------------------------------------------------------------
GdkPixbuf *CaptureScreen()
{
	gint 			x, y;
	GdkScreen		*screen    = NULL;
	GdkRectangle 	rcWindow;
	GdkRectangle	rcScreen;
	GdkWindow	*window = NULL;
	GdkPixbuf		*pixbufScreen= NULL;

	screen = gdk_screen_get_default();
	
	rcScreen.x = 0;
	rcScreen.y = 0;
	rcScreen.width = gdk_screen_get_width (screen);
	rcScreen.height = gdk_screen_get_height (screen);

	window = gdk_screen_get_root_window (screen);
	
	gdk_window_get_origin(window, &x, &y);
	rcWindow.x = x;
	rcWindow.y = y;
	gdk_drawable_get_size (GDK_DRAWABLE (window), &rcWindow.width, &rcWindow.height);
	
	if (!gdk_rectangle_intersect (&rcWindow, &rcScreen, &rcWindow)) 
	{
		g_print("Capture failed!...\r\n");
		return NULL;
	}
	
	pixbufScreen = gdk_pixbuf_get_from_drawable (NULL, window, NULL, rcWindow.x-x, rcWindow.y-y, 0, 0, rcWindow.width, rcWindow.height);
	
	return pixbufScreen;
}

guchar* GetPixel (GdkPixbuf *pixbuf, int x, int y)
{
	int width, height, rowstride, n_channels;
	guchar *pixels, *p;
	
	n_channels = gdk_pixbuf_get_n_channels (pixbuf);
/*	
	g_assert (gdk_pixbuf_get_colorspace (pixbuf) == GDK_COLORSPACE_RGB);
	g_assert (gdk_pixbuf_get_bits_per_sample (pixbuf) == 8);
	g_assert (gdk_pixbuf_get_has_alpha (pixbuf));
	g_assert (n_channels == 4);
*/	
	width = gdk_pixbuf_get_width (pixbuf);
	height = gdk_pixbuf_get_height (pixbuf);
	
	g_assert (x >= 0 && x < width);
	g_assert (y >= 0 && y < height);
	
	rowstride = gdk_pixbuf_get_rowstride (pixbuf);
	pixels = gdk_pixbuf_get_pixels (pixbuf);
	
	p = pixels + y * rowstride + x * n_channels;
	
	return p;
}
