#ifndef __INIT_KEYBOARD_CPP__
#define __INIT_KEYBOARD_CPP__
#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include "scim_hanpin.h"
#include "ppscim_ctrl_def.h"

#define Uses_SCIM_CONFIG_BASE
#define Uses_SCIM_CONFIG_PATH
#define Uses_SCIM_MODULE
#define Uses_SCIM_IMENGINE_MODULE
#define Uses_SCIM_HELPER
#define Uses_STL_MAP


#include "scim.h"
using namespace scim;
/*
extern PPKeyMap gbl_hanpin_keymap[128];
extern PPKeyMap gbl_sym_keymap[128];
extern PPCtlInfo gbl_controls[128];
extern PPCtlInfo gbl_sym_controls[128];
extern GdkPixbuf *gbl_controlsImgP1;
extern GdkPixbuf *gbl_controlsImgP2;
extern GdkPixbuf *gbl_controlsImgP3;
extern GdkPixbuf *gbl_controlsImgP4;
extern GdkPixbuf *gbl_controlsDisImgP1;
extern GdkPixbuf *gbl_controlsDisImgP2;
extern GdkPixbuf *gbl_abcImgPD;
extern GdkPixbuf *gbl_closeImgP;
extern GdkPixbuf *gbl_delImgP;
extern GdkPixbuf *gbl_enterImgP;
extern GdkPixbuf *gbl_tabImgP;
extern GdkPixbuf *gbl_ctrlImgPU;
extern GdkPixbuf *gbl_ctrlImgPD;
extern GdkPixbuf *gbl_capsImgPL;
extern GdkPixbuf *gbl_capsImgPU;
extern GdkPixbuf *gbl_spaceImgP;
extern GdkPixbuf *gbl_pixbufImage;
extern GdkPixbuf *gbl_infoImgP;
extern GdkPixbuf *gbl_press_infoImgP;
extern GdkPixbuf *gbl_numImgPD;
extern int gbl_symctl_count;
extern int gbl_ctl_count;
extern int gbl_key_number;
extern int gbl_symkey_number;
extern GtkWidget *main_window;
extern gboolean gbl_hanpin_bCAPS;
extern gboolean gbl_bNUMBER;
extern void forward_key_button_clicked (GtkWidget *widget, gpointer data);


int init_hanpinkeymap(PPKeyMap *keymap)
{
	int i = 0;
	keymap[i].m_keyid = BUTTON_TOP_BOARD_ID;
	keymap[i].m_keycode1 = 0;
	keymap[i].m_keycode2 = 0;
	i++;
	keymap[i].m_keyid = BUTTON_LEFT_BOARD_ID;
	keymap[i].m_keycode1 = 0;
	keymap[i].m_keycode2 = 0;
	i++;
	keymap[i].m_keyid = BUTTON_Q_ID;
	keymap[i].m_keycode1 = SCIM_KEY_q;
	keymap[i].m_keycode2 = SCIM_KEY_Q;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"q");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"Q");		
	i++;
	keymap[i].m_keyid = BUTTON_W_ID;
	keymap[i].m_keycode1 = SCIM_KEY_w;
	keymap[i].m_keycode2 = SCIM_KEY_W;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"w");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"w");
	i++;
	keymap[i].m_keyid = BUTTON_E_ID;
	keymap[i].m_keycode1 = SCIM_KEY_e;
	keymap[i].m_keycode2 = SCIM_KEY_E;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"e");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"E");
	i++;
	keymap[i].m_keyid = BUTTON_R_ID;
	keymap[i].m_keycode1 = SCIM_KEY_r;
	keymap[i].m_keycode2 = SCIM_KEY_R;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"r");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"R");
	i++;
	keymap[i].m_keyid = BUTTON_T_ID;
	keymap[i].m_keycode1 = SCIM_KEY_t;
	keymap[i].m_keycode2 = SCIM_KEY_T;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"t");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"T");
	i++;
	keymap[i].m_keyid = BUTTON_Y_ID;
	keymap[i].m_keycode1 = SCIM_KEY_y;
	keymap[i].m_keycode2 = SCIM_KEY_Y;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"y");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"Y");
	i++;
	keymap[i].m_keyid = BUTTON_U_ID;
	keymap[i].m_keycode1 = SCIM_KEY_u;
	keymap[i].m_keycode2 = SCIM_KEY_U;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"u");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"U");
	i++;
	keymap[i].m_keyid = BUTTON_I_ID;
	keymap[i].m_keycode1 = SCIM_KEY_i;
	keymap[i].m_keycode2 = SCIM_KEY_I;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"i");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"I");
	i++;
	keymap[i].m_keyid = BUTTON_O_ID;
	keymap[i].m_keycode1 = SCIM_KEY_o;
	keymap[i].m_keycode2 = SCIM_KEY_O;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"o");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"O");
	i++;
	keymap[i].m_keyid = BUTTON_P_ID;
	keymap[i].m_keycode1 = SCIM_KEY_p;
	keymap[i].m_keycode2 = SCIM_KEY_P;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"p");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"P");
	i++;
	keymap[i].m_keyid = BUTTON_BK_ID;
	keymap[i].m_keycode1 = SCIM_KEY_BackSpace;
	keymap[i].m_keycode2 = SCIM_KEY_BackSpace;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;	
	keymap[i].m_keyid = BUTTON_SECOND_BOARD_ID;
	keymap[i].m_keycode1 = 0;
	keymap[i].m_keycode2 = 0;
	i++;
	keymap[i].m_keyid = BUTTON_TAB_ID;
	keymap[i].m_keycode1 = SCIM_KEY_Tab;
	keymap[i].m_keycode2 = SCIM_KEY_Tab;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_A_ID;
	keymap[i].m_keycode1 = SCIM_KEY_a;
	keymap[i].m_keycode2 = SCIM_KEY_A;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"a");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"A");
	i++;
	keymap[i].m_keyid = BUTTON_S_ID;
	keymap[i].m_keycode1 = SCIM_KEY_s;
	keymap[i].m_keycode2 = SCIM_KEY_S;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"s");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"S");
	i++;
	keymap[i].m_keyid = BUTTON_D_ID;
	keymap[i].m_keycode1 = SCIM_KEY_d;
	keymap[i].m_keycode2 = SCIM_KEY_D;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"d");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"D");
	i++;
	keymap[i].m_keyid = BUTTON_F_ID;
	keymap[i].m_keycode1 = SCIM_KEY_f;
	keymap[i].m_keycode2 = SCIM_KEY_F;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"f");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"F");
	i++;
	keymap[i].m_keyid = BUTTON_G_ID;
	keymap[i].m_keycode1 = SCIM_KEY_g;
	keymap[i].m_keycode2 = SCIM_KEY_G;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"g");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"G");
	i++;
	keymap[i].m_keyid = BUTTON_H_ID;
	keymap[i].m_keycode1 = SCIM_KEY_h;
	keymap[i].m_keycode2 = SCIM_KEY_H;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"h");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"H");
	i++;
	keymap[i].m_keyid = BUTTON_J_ID;
	keymap[i].m_keycode1 = SCIM_KEY_j;
	keymap[i].m_keycode2 = SCIM_KEY_J;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"j");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"J");
	i++;
	keymap[i].m_keyid = BUTTON_K_ID;
	keymap[i].m_keycode1 = SCIM_KEY_k;
	keymap[i].m_keycode2 = SCIM_KEY_K;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"k");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"K");
	i++;
	keymap[i].m_keyid = BUTTON_L_ID;
	keymap[i].m_keycode1 = SCIM_KEY_l;
	keymap[i].m_keycode2 = SCIM_KEY_L;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"l");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"L");
	i++;
	keymap[i].m_keyid = BUTTON_THRID_BOARD_ID;
	keymap[i].m_keycode1 = 0;
	keymap[i].m_keycode2 = 0;
	i++;
	keymap[i].m_keyid = BUTTON_ENTER_ID;
	keymap[i].m_keycode1 = SCIM_KEY_Return;
	keymap[i].m_keycode2 = SCIM_KEY_Return;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_CAPS_ID;
	keymap[i].m_keycode1 = SCIM_KEY_Caps_Lock;
	keymap[i].m_keycode2 = SCIM_KEY_Caps_Lock;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_Z_ID;
	keymap[i].m_keycode1 = SCIM_KEY_z;
	keymap[i].m_keycode2 = SCIM_KEY_Z;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"z");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"Z");
	i++;
	keymap[i].m_keyid = BUTTON_X_ID;
	keymap[i].m_keycode1 = SCIM_KEY_x;
	keymap[i].m_keycode2 = SCIM_KEY_X;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"x");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"X");
	i++;
	keymap[i].m_keyid = BUTTON_C_ID;
	keymap[i].m_keycode1 = SCIM_KEY_c;
	keymap[i].m_keycode2 = SCIM_KEY_C;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"c");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"C");
	i++;
	keymap[i].m_keyid = BUTTON_V_ID;
	keymap[i].m_keycode1 = SCIM_KEY_v;
	keymap[i].m_keycode2 = SCIM_KEY_V;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"v");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"V");
	i++;
	keymap[i].m_keyid = BUTTON_B_ID;
	keymap[i].m_keycode1 = SCIM_KEY_b;
	keymap[i].m_keycode2 = SCIM_KEY_B;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"b");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"B");
	i++;
	keymap[i].m_keyid = BUTTON_N_ID;
	keymap[i].m_keycode1 = SCIM_KEY_n;
	keymap[i].m_keycode2 = SCIM_KEY_N;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"n");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"N");
	i++;
	keymap[i].m_keyid = BUTTON_M_ID;
	keymap[i].m_keycode1 = SCIM_KEY_m;
	keymap[i].m_keycode2 = SCIM_KEY_M;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"m");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"M");
	i++;
	keymap[i].m_keyid = BUTTON_SEMI_ID;
	keymap[i].m_keycode1 = SCIM_KEY_semicolon;
	keymap[i].m_keycode2 = SCIM_KEY_colon;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_QUOTE_ID;
	keymap[i].m_keycode1 = SCIM_KEY_quoteright;
	keymap[i].m_keycode2 = SCIM_KEY_quotedbl;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_FOURTH_BOARD_ID;
	keymap[i].m_keycode1 = 0;
	keymap[i].m_keycode2 = 0;
	i++;
	keymap[i].m_keyid = BUTTON_NUMBER_ID;
	keymap[i].m_keycode1 = 0;
	keymap[i].m_keycode2 = 0;
	i++;
	keymap[i].m_keyid = BUTTON_EXCLAM_ID;
	keymap[i].m_keycode1 = SCIM_KEY_exclam;
	keymap[i].m_keycode2 = SCIM_KEY_asterisk;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_QUEST_ID;
	keymap[i].m_keycode1 = SCIM_KEY_question;	
	keymap[i].m_keycode2 = SCIM_KEY_at;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_SPACE_ID;
	keymap[i].m_keycode1 = SCIM_KEY_space;
	keymap[i].m_keycode2 = SCIM_KEY_space;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_COMMA_ID;
	keymap[i].m_keycode1 = SCIM_KEY_comma;
	keymap[i].m_keycode2 = SCIM_KEY_less;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_DOT_ID;
	keymap[i].m_keycode1 = SCIM_KEY_period;
	keymap[i].m_keycode2 = SCIM_KEY_greater;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_DASH_ID;
	keymap[i].m_keycode1 = SCIM_KEY_minus;
	keymap[i].m_keycode2 = SCIM_KEY_underscore;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_SLASH_ID;
	keymap[i].m_keycode1 = SCIM_KEY_slash;
	keymap[i].m_keycode2 = SCIM_KEY_bar;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_CLOSE_ID;
	keymap[i].m_keycode1 = 0;
	keymap[i].m_keycode2 = 0;
	i++;
	keymap[i].m_keyid = BUTTON_CLOSE_LEFT_BOARD_ID;
	keymap[i].m_keycode1 = 0;
	keymap[i].m_keycode2 = 0;
	i++;
	keymap[i].m_keyid = BUTTON_CLOSE_TOP_BOARD_ID;
	keymap[i].m_keycode1 = 0;
	keymap[i].m_keycode2 = 0;
	i++;
	keymap[i].m_keyid = BUTTON_INFO_ID;
	keymap[i].m_keycode1 = 0;
	keymap[i].m_keycode2 = 0;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	return i;
}

int MyPPCommand_CALLBACKPROC(int iCmd,void *userDef)
{
	if (main_window != 0)
	{
		if(iCmd != BUTTON_CAPS_ID && iCmd != BUTTON_CTRL_ID  && iCmd != BUTTON_S_CAPS_ID)
		{		
			if(gbl_bNUMBER)
			{
				for(int i=0; i<gbl_symkey_number; i++)
				{
					if(gbl_sym_keymap[i].m_keyid == iCmd)
					{
						if(!gbl_hanpin_bCAPS)
							forward_key_button_clicked(main_window, GUINT_TO_POINTER(gbl_sym_keymap[i].m_keycode1));
						else
							forward_key_button_clicked(main_window, GUINT_TO_POINTER(gbl_sym_keymap[i].m_keycode2));
						break;
					}
				}		
			}
			else
			{																
				for(int i=0; i<gbl_key_number; i++)
				{
					if(gbl_hanpin_keymap[i].m_keyid == iCmd)
					{
						if(gbl_hanpin_bCAPS)
							forward_key_button_clicked(main_window, GUINT_TO_POINTER(gbl_hanpin_keymap[i].m_keycode2));
						else
							forward_key_button_clicked(main_window, GUINT_TO_POINTER(gbl_hanpin_keymap[i].m_keycode1));
						break;
					}				
				}
			}
		}
	}
	return 0;
}

int init_keyboardbutton(int disable, int CtlID, GdkPixbuf* ImgP, GdkPixbuf* ImgP_disable1, GdkPixbuf* ImgP_disable2,
						GdkPixbuf* ImgP_down, GdkPixbuf* ImgP_over , ppRect* mainRect, ppRect* senseRect, 
						ppRect* transpRect, const char* transp_imgU_path, const char* transp_imgL_path)
{
	// ======================================================================v
	// button
	PPCtlInfo *oneInfoP;

	if(ImgP == NULL)
		return FALSE;

	if(gbl_bNUMBER)
       	oneInfoP = &(gbl_sym_controls[gbl_symctl_count]);
	else
       	oneInfoP = &(gbl_controls[gbl_ctl_count]);

	//oneInfoP = &(gbl_controls[gbl_ctl_count]);
	memset(oneInfoP,0,sizeof(PPCtlInfo));
	oneInfoP->m_disable = disable;
	oneInfoP->m_CtlID = CtlID;
	oneInfoP->m_CtlState = PPOD_CTL_STATE_0;
	oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
	oneInfoP->m_CtlLastDrawState = 0;
	if(CtlID != BUTTON_INFO_ID)
	{
        if(gbl_bNUMBER)
        {
			oneInfoP->m_imgP = gbl_controlsImgP3;
			oneInfoP->m_imgPU = gbl_controlsImgP4;
        }
        else
        {
            oneInfoP->m_imgP = gbl_controlsImgP1;
            oneInfoP->m_imgPU = gbl_controlsImgP2;
        }
	}
	else
	{
		oneInfoP->m_imgP = ImgP;
		oneInfoP->m_imgPU = ImgP;
	}
	//oneInfoP->m_imgP = gbl_controlsImgP1;
	//oneInfoP->m_imgPU = gbl_controlsImgP2;
	oneInfoP->m_mainRect.m_left = mainRect->m_left;
	oneInfoP->m_mainRect.m_top = mainRect->m_top;
	oneInfoP->m_mainRect.m_right = mainRect->m_right;
	oneInfoP->m_mainRect.m_bottom = mainRect->m_bottom;
	memcpy(&(oneInfoP->m_downRect),&(oneInfoP->m_mainRect),sizeof(ppRect));
	memcpy(&(oneInfoP->m_disableRect),&(oneInfoP->m_mainRect),sizeof(ppRect));
	memcpy(&(oneInfoP->m_overRect),&(oneInfoP->m_mainRect),sizeof(ppRect));
	oneInfoP->m_senseRect.m_left = senseRect->m_left;
	oneInfoP->m_senseRect.m_top = senseRect->m_top;
	oneInfoP->m_senseRect.m_right = senseRect->m_right;
	oneInfoP->m_senseRect.m_bottom = senseRect->m_bottom;
	oneInfoP->m_transpRect.m_left = transpRect->m_left;
	oneInfoP->m_transpRect.m_top = transpRect->m_top;
	oneInfoP->m_transpRect.m_right = transpRect->m_right;
	oneInfoP->m_transpRect.m_bottom = transpRect->m_bottom;	

	if(strlen(transp_imgU_path) > 0)
	{
		sprintf(oneInfoP->m_transp_imgU_path, "%s", transp_imgU_path);		
	}

	if(strlen(transp_imgL_path) > 0)
	{
		sprintf(oneInfoP->m_transp_imgL_path, "%s", transp_imgL_path);		
	}

	if(CtlID != BUTTON_INFO_ID)
	{
		memcpy(&(oneInfoP->m_OFSPX_mainRect),&(oneInfoP->m_mainRect),sizeof(ppRect));
	}
	else
	{
		oneInfoP->m_OFSPX_mainRect.m_left = 0;
		oneInfoP->m_OFSPX_mainRect.m_top = 0;
		oneInfoP->m_OFSPX_mainRect.m_right = mainRect->m_right - mainRect->m_left;
		oneInfoP->m_OFSPX_mainRect.m_bottom = mainRect->m_bottom - mainRect->m_top;
	}

	//memcpy(&(oneInfoP->m_OFSPX_mainRect),&(oneInfoP->m_mainRect),sizeof(ppRect));
	if(ImgP_down != NULL)
	{
		oneInfoP->m_imgP_down =ImgP_down;
		oneInfoP->m_OFSPX_downRect.m_left = 0;
		oneInfoP->m_OFSPX_downRect.m_top = 0;
		oneInfoP->m_OFSPX_downRect.m_right = mainRect->m_right - mainRect->m_left;
		oneInfoP->m_OFSPX_downRect.m_bottom = mainRect->m_bottom - mainRect->m_top;
	}
	else
	{
		oneInfoP->m_imgP_down = NULL;
		memcpy(&(oneInfoP->m_OFSPX_downRect),&(oneInfoP->m_mainRect),sizeof(ppRect));
	}

	if(ImgP_disable1 != NULL)
	{
		oneInfoP->m_imgP_disable1 = ImgP_disable1;
		oneInfoP->m_OFSPX_disableRect.m_left = mainRect->m_left;
		oneInfoP->m_OFSPX_disableRect.m_top = mainRect->m_top;
		oneInfoP->m_OFSPX_disableRect.m_right = mainRect->m_right;
		oneInfoP->m_OFSPX_disableRect.m_bottom = mainRect->m_bottom;
	}
	else	
	{
		oneInfoP->m_imgP_disable1 = NULL;
		memcpy(&(oneInfoP->m_OFSPX_disableRect),&(oneInfoP->m_mainRect),sizeof(ppRect));
	}

	if(ImgP_disable2 != NULL)
	{
		oneInfoP->m_imgP_disable2 = ImgP_disable2;		
	}
	else	
	{
		oneInfoP->m_imgP_disable2 = NULL;		
	}

	if(ImgP_over != NULL)
	{
		oneInfoP->m_imgP_over = ImgP_over;
		oneInfoP->m_OFSPX_overRect.m_left = 0;
		oneInfoP->m_OFSPX_overRect.m_top = 0;
		oneInfoP->m_OFSPX_overRect.m_right = mainRect->m_right - mainRect->m_left;
		oneInfoP->m_OFSPX_overRect.m_bottom = mainRect->m_bottom - mainRect->m_top;
	}
	else
	{
		oneInfoP->m_imgP_over = NULL;
		//memcpy(&(oneInfoP->m_OFSPX_overRect),&(oneInfoP->m_mainRect),sizeof(ppRect));
		memcpy(&(oneInfoP->m_OFSPX_overRect),&(oneInfoP->m_OFSPX_mainRect),sizeof(ppRect));
	}

	oneInfoP->m_CmdCallbackP = MyPPCommand_CALLBACKPROC;

	if(gbl_bNUMBER)
		gbl_symctl_count++;	
	else
		gbl_ctl_count++;
	
	// ======================================================================^
	return (0);
}

int init_hanpin_controls()
{
	PPCtlInfo *oneInfoP;
	gbl_ctl_count = 0;
	gbl_bNUMBER = false;
	gbl_hanpin_bCAPS = false;
	// ======================================================================
	//0
	ppRect pixRect, senseRect, transpRect;
	char picU_path[128] = "", picL_path[128] = "";
	pixRect.m_left = 0;
	pixRect.m_top = 0;
	pixRect.m_right = 800;
	pixRect.m_bottom = 5;
	senseRect.m_left = 0;
	senseRect.m_top = 0;
	senseRect.m_right = 0;
	senseRect.m_bottom = 0;
	transpRect.m_left = 0;
	transpRect.m_top = 0;
	//right,bottom not used
	transpRect.m_right = 0;
	transpRect.m_bottom = 0;
	memset(picU_path, 0, sizeof(picU_path));
	memset(picL_path, 0, sizeof(picL_path));
	init_keyboardbutton(DISABLE, BUTTON_TOP_BOARD_ID,  gbl_controlsImgP1, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// ======================================================================v
	//1
		pixRect.m_left = 0;
		pixRect.m_top = 5;
		pixRect.m_right = 6;
		pixRect.m_bottom = 183;
		senseRect.m_left = 0;
		senseRect.m_top = 0;
		senseRect.m_right = 0;
		senseRect.m_bottom = 0;
		transpRect.m_left = 0;
		transpRect.m_top = 0;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		init_keyboardbutton(DISABLE, BUTTON_LEFT_BOARD_ID,  gbl_controlsImgP1, NULL, NULL, NULL, NULL,  &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// ======================================================================v
	//2  button_q	
		pixRect.m_left = 6;
		pixRect.m_top = 5;
		pixRect.m_right = 109;
		pixRect.m_bottom = 49;
		senseRect.m_left = 5;
		senseRect.m_top = 5;
		senseRect.m_right = 109;
		senseRect.m_bottom = 49;
		transpRect.m_left = 48;
		transpRect.m_top = 220;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/q.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_q.bmp");
		init_keyboardbutton(ENABLE, BUTTON_Q_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// ======================================================================
	//3 button_w	
		pixRect.m_left = 109;
		pixRect.m_top = 5;
		pixRect.m_right = 109 + 62;
		pixRect.m_bottom = 49;
		senseRect.m_left = 109;
		senseRect.m_top = 5;
		senseRect.m_right = 171;
		senseRect.m_bottom = 49;
		transpRect.m_left = 112;
		transpRect.m_top = 220;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/w.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_w.bmp");
		init_keyboardbutton(ENABLE, BUTTON_W_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// ======================================================================
	//4 
		pixRect.m_left = 171;
		pixRect.m_top = 5;
		pixRect.m_right = 171 + 62;
		pixRect.m_bottom = 49;
		senseRect.m_left = 171;
		senseRect.m_top = 5;
		senseRect.m_right = 233;
		senseRect.m_bottom = 49;
		transpRect.m_left = 174;
		transpRect.m_top = 220;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/e.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_e.bmp");
		init_keyboardbutton(ENABLE, BUTTON_E_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//5
		pixRect.m_left = 233;
		pixRect.m_top = 5;
		pixRect.m_right = 233 + 64;
		pixRect.m_bottom = 49;
		senseRect.m_left = 233;
		senseRect.m_top = 5;
		senseRect.m_right = 297;
		senseRect.m_bottom = 49;
		transpRect.m_left = 238;
		transpRect.m_top = 220;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/r.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_r.bmp");
		init_keyboardbutton(ENABLE, BUTTON_R_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//6
		pixRect.m_left = 297;
		pixRect.m_top = 0;
		pixRect.m_right = 297 + 63;
		pixRect.m_bottom = 49;
		senseRect.m_left = 297;
		senseRect.m_top = 5;
		senseRect.m_right = 296+63;
		senseRect.m_bottom = 48;
		transpRect.m_left = 300;
		transpRect.m_top = 220;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/t.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_t.bmp");
		init_keyboardbutton(ENABLE, BUTTON_T_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//7
    	pixRect.m_left = 359;
    	pixRect.m_top = 5;
    	pixRect.m_right = 359 + 63;
    	pixRect.m_bottom = 49;
    	senseRect.m_left = 359;
    	senseRect.m_top = 5;
    	senseRect.m_right = 359+63;
    	senseRect.m_bottom = 49;
    	transpRect.m_left = 362;
    	transpRect.m_top = 220;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/y.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_y.bmp");
		init_keyboardbutton(ENABLE, BUTTON_Y_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//8
    	pixRect.m_left = 422;
    	pixRect.m_top = 5;
    	pixRect.m_right = 422 + 63;
    	pixRect.m_bottom = 49;
    	senseRect.m_left = 422;
    	senseRect.m_top = 5;
    	senseRect.m_right = 422+63;
    	senseRect.m_bottom = 49;
    	transpRect.m_left = 424;
    	transpRect.m_top = 220;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/u.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_u.bmp");
		init_keyboardbutton(DISABLE, BUTTON_U_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//9
    	pixRect.m_left = 485;
    	pixRect.m_top = 5;
    	pixRect.m_right = 485 + 62;
    	pixRect.m_bottom = 49;
    	senseRect.m_left = 485;
    	senseRect.m_top = 5;
    	senseRect.m_right = 485+62;
    	senseRect.m_bottom = 49;
    	transpRect.m_left = 488;
    	transpRect.m_top = 220;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/i.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_i.bmp");
		init_keyboardbutton(DISABLE, BUTTON_I_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
   	//10
    	pixRect.m_left = 547;
    	pixRect.m_top = 5;
    	pixRect.m_right = 547 + 63;
    	pixRect.m_bottom = 49;
    	senseRect.m_left = 547;
    	senseRect.m_top = 5;
    	senseRect.m_right = 547+63;
    	senseRect.m_bottom = 49;
    	transpRect.m_left = 549;
    	transpRect.m_top = 220;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/o.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_o.bmp");
		init_keyboardbutton(ENABLE, BUTTON_O_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//11
    	pixRect.m_left = 610;
    	pixRect.m_top = 5;
    	pixRect.m_right = 610 + 63;
    	pixRect.m_bottom = 49;
    	senseRect.m_left = 610;
    	senseRect.m_top = 5;
    	senseRect.m_right = 610+63;
    	senseRect.m_bottom = 49;
    	transpRect.m_left = 612;
    	transpRect.m_top = 220;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/p.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_p.bmp");
		init_keyboardbutton(ENABLE, BUTTON_P_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//12
    	pixRect.m_left = 673;
    	pixRect.m_top = 5;
    	pixRect.m_right = 673 + 77;
    	pixRect.m_bottom = 49;
    	senseRect.m_left = 673;
    	senseRect.m_top = 5;
    	senseRect.m_right = 673 + 77;
    	senseRect.m_bottom = 49;
    	transpRect.m_left = 0;
    	transpRect.m_top = 0;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		init_keyboardbutton(ENABLE, BUTTON_BK_ID,  gbl_controlsImgP1, NULL, NULL, gbl_delImgP, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//13 board
    	pixRect.m_left = 6;
    	pixRect.m_top = 49;
    	pixRect.m_right = 750;
    	pixRect.m_bottom = 50;
    	senseRect.m_left = 0;	
    	senseRect.m_top = 0;
    	senseRect.m_right = 0;
    	senseRect.m_bottom = 0;
    	transpRect.m_left = 0;
    	transpRect.m_top = 0;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		init_keyboardbutton(DISABLE, BUTTON_SECOND_BOARD_ID,  gbl_controlsImgP1, NULL, NULL, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);

	// =======================================================================
	//14
    	pixRect.m_left = 6;
    	pixRect.m_top = 50;
    	pixRect.m_right = 6 + 75;
    	pixRect.m_bottom = 50 + 43;
    	senseRect.m_left = 6;
    	senseRect.m_top = 50;
    	senseRect.m_right = 6 + 75;
    	senseRect.m_bottom = 50 + 43;
    	transpRect.m_left = 0;
    	transpRect.m_top = 0;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		init_keyboardbutton(ENABLE, BUTTON_TAB_ID,  gbl_controlsImgP1, NULL, NULL, gbl_tabImgP, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//15
    	pixRect.m_left = 81;
    	pixRect.m_top = 50;
    	pixRect.m_right = 81 + 59;
    	pixRect.m_bottom = 50 + 43;
    	senseRect.m_left = 81;
    	senseRect.m_top = 50;
    	senseRect.m_right = 81 + 59;
    	senseRect.m_bottom = 50 + 43;
    	transpRect.m_left = 81;
    	transpRect.m_top = 264;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/a.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_a.bmp");
		init_keyboardbutton(ENABLE, BUTTON_A_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//16
    	pixRect.m_left = 140;
    	pixRect.m_top = 50;
    	pixRect.m_right = 140 + 63;
    	pixRect.m_bottom = 50 + 43;
    	senseRect.m_left = 140;
    	senseRect.m_top = 50;
    	senseRect.m_right = 140 + 63;
    	senseRect.m_bottom = 50 + 43;
    	transpRect.m_left = 143;
    	transpRect.m_top = 264;
    	//right,bottom not used
    	transpRect.m_right = 144;
    	transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/s.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_s.bmp");
		init_keyboardbutton(ENABLE, BUTTON_S_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//17
    	pixRect.m_left = 203;
    	pixRect.m_top = 50;
    	pixRect.m_right = 203 + 64;
    	pixRect.m_bottom = 50 + 43;
    	senseRect.m_left = 203;
    	senseRect.m_top = 50;
    	senseRect.m_right = 203 + 64;
    	senseRect.m_bottom = 50 + 43;
    	transpRect.m_left = 206;
    	transpRect.m_top = 264;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/d.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_d.bmp");
		init_keyboardbutton(ENABLE, BUTTON_D_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//18
    	pixRect.m_left = 267;
    	pixRect.m_top = 50;
    	pixRect.m_right = 267 + 62;
    	pixRect.m_bottom = 50 + 43;
    	senseRect.m_left = 267;
    	senseRect.m_top = 50;
    	senseRect.m_right = 267 + 62;
    	senseRect.m_bottom = 50 + 43;
    	transpRect.m_left = 268;
    	transpRect.m_top = 264;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/f.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_f.bmp");
		init_keyboardbutton(ENABLE, BUTTON_F_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//19
    	pixRect.m_left = 329;
    	pixRect.m_top = 50;
    	pixRect.m_right = 329 + 62;
    	pixRect.m_bottom = 50 + 43;
    	senseRect.m_left = 330;
    	senseRect.m_top = 50;
    	senseRect.m_right = 329 + 62;
    	senseRect.m_bottom = 50 + 43;
    	transpRect.m_left = 331;
    	transpRect.m_top = 264;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/g.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_g.bmp");
		init_keyboardbutton(ENABLE, BUTTON_G_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//20
    	pixRect.m_left = 391;
    	pixRect.m_top = 50;
    	pixRect.m_right = 391 + 63;
    	pixRect.m_bottom = 50 + 43;
    	senseRect.m_left = 390;
    	senseRect.m_top = 50;
    	senseRect.m_right = 391 + 63;
    	senseRect.m_bottom = 50 + 43;
    	transpRect.m_left = 393;
    	transpRect.m_top = 264;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/h.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_h.bmp");
		init_keyboardbutton(ENABLE, BUTTON_H_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//21
    	pixRect.m_left = 454;
    	pixRect.m_top = 50;
    	pixRect.m_right = 454 + 63;
    	pixRect.m_bottom = 50 + 43;
    	senseRect.m_left = 454;
    	senseRect.m_top = 50;
    	senseRect.m_right = 454 + 63;
    	senseRect.m_bottom = 50 + 43;
    	transpRect.m_left = 456;
    	transpRect.m_top = 264;
    	//right,bottom not used
    	transpRect.m_right = 0;
    	transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/j.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_j.bmp");
		init_keyboardbutton(ENABLE, BUTTON_J_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//22
    	pixRect.m_left = 517;
    	pixRect.m_top = 50;
    	pixRect.m_right = 517 + 63;
    	pixRect.m_bottom = 50 + 43;
    	senseRect.m_left = 517;
    	senseRect.m_top = 50;
    	senseRect.m_right = 516 + 63;
    	senseRect.m_bottom = 50 + 43;
    	transpRect.m_left = 519;
    	transpRect.m_top = 264;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/k.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_k.bmp");
		init_keyboardbutton(ENABLE, BUTTON_K_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//23
    	pixRect.m_left = 580;
    	pixRect.m_top = 50;
    	pixRect.m_right = 580 + 93;
    	pixRect.m_bottom = 50 + 43;
    	senseRect.m_left = 580;
    	senseRect.m_top = 50;
    	senseRect.m_right = 580 + 93;
    	senseRect.m_bottom = 50 + 43;
    	transpRect.m_left = 582;
    	transpRect.m_top = 264;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/l.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_l.bmp");
		init_keyboardbutton(ENABLE, BUTTON_L_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//24
    	//board
    	pixRect.m_left = 6;
    	pixRect.m_top = 93;
    	pixRect.m_right = 673;
    	pixRect.m_bottom = 94;
    	senseRect.m_left = 0;
    	senseRect.m_top = 0;
    	senseRect.m_right = 0;
    	senseRect.m_bottom = 0;
    	transpRect.m_left = 0;
    	transpRect.m_top = 0;
    	//right,bottom not used
    	transpRect.m_right = 0;
    	transpRect.m_bottom = 0;
    	memset(picU_path, 0, sizeof(picU_path));
    	memset(picL_path, 0, sizeof(picL_path));
    	init_keyboardbutton(DISABLE, BUTTON_THRID_BOARD_ID,  gbl_controlsImgP1, NULL, NULL, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
   	//25
    	pixRect.m_left = 673;
    	pixRect.m_top = 50;
    	pixRect.m_right = 673 + 77;
    	pixRect.m_bottom = 50 + 88;
    	senseRect.m_left = 673;
    	senseRect.m_top = 50;
    	senseRect.m_right = 673 + 77;
    	senseRect.m_bottom = 50 + 88;
    	transpRect.m_left = 0;
    	transpRect.m_top = 0;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		init_keyboardbutton(ENABLE, BUTTON_ENTER_ID,  gbl_controlsImgP1, NULL, NULL, gbl_enterImgP, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//26
    	pixRect.m_left = 6;
    	pixRect.m_top = 94;
    	pixRect.m_right = 6 + 103;
    	pixRect.m_bottom = 94 + 44;
    	senseRect.m_left = 6;
    	senseRect.m_top = 94;
    	senseRect.m_right = 6 + 103;
    	senseRect.m_bottom = 94 + 44;
    	transpRect.m_left = 0;
    	transpRect.m_top = 0;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		init_keyboardbutton(DISABLE, BUTTON_CAPS_ID,  gbl_controlsImgP1, NULL, NULL, gbl_capsImgPU, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//27
    	pixRect.m_left = 109;
    	pixRect.m_top = 94;
    	pixRect.m_right = 109 + 63;
    	pixRect.m_bottom = 94 + 44;
    	senseRect.m_left = 109;
    	senseRect.m_top = 94;
    	senseRect.m_right = 109 + 63;
    	senseRect.m_bottom = 94 + 44;
    	transpRect.m_left = 111;
    	transpRect.m_top = 308;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/z.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_z.bmp");
		init_keyboardbutton(ENABLE, BUTTON_Z_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//28
    	pixRect.m_left = 172;
    	pixRect.m_top = 94;
    	pixRect.m_right = 172 + 62;
    	pixRect.m_bottom = 94 + 44;
    	senseRect.m_left = 172;
    	senseRect.m_top = 94;
    	senseRect.m_right = 172 + 62;
    	senseRect.m_bottom = 94 + 44;
    	transpRect.m_left = 174;
    	transpRect.m_top = 308;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/x.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_x.bmp");
		init_keyboardbutton(ENABLE, BUTTON_X_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//29
    	pixRect.m_left = 234;
    	pixRect.m_top = 94;
    	pixRect.m_right = 234 + 63;
    	pixRect.m_bottom = 94 + 44;
    	senseRect.m_left = 235;
    	senseRect.m_top = 94;
    	senseRect.m_right = 234 + 63;
    	senseRect.m_bottom = 94 + 44;
    	transpRect.m_left = 236;
    	transpRect.m_top = 308;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/c.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_c.bmp");
		init_keyboardbutton(ENABLE, BUTTON_C_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//30
    	pixRect.m_left = 297;
    	pixRect.m_top = 94;
    	pixRect.m_right = 297 + 63;
    	pixRect.m_bottom = 94 + 44;
    	senseRect.m_left = 297;
    	senseRect.m_top = 94;
    	senseRect.m_right = 297 + 63;
    	senseRect.m_bottom = 94 + 44;
    	transpRect.m_left = 299;
    	transpRect.m_top = 308;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/v.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_v.bmp");
		init_keyboardbutton(DISABLE, BUTTON_V_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//31
    	pixRect.m_left = 360;
    	pixRect.m_top = 94;
    	pixRect.m_right = 360 + 62;
    	pixRect.m_bottom = 94 + 44;
    	senseRect.m_left = 360;
    	senseRect.m_top = 94;
    	senseRect.m_right = 360 + 62;
    	senseRect.m_bottom = 94 + 44;
    	transpRect.m_left = 362;
    	transpRect.m_top = 308;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/b.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_b.bmp");
		init_keyboardbutton(ENABLE, BUTTON_B_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//32
    	pixRect.m_left = 422;
    	pixRect.m_top = 94;
    	pixRect.m_right = 422 + 63;
    	pixRect.m_bottom = 94 + 44;
    	senseRect.m_left = 422;
    	senseRect.m_top = 94;
    	senseRect.m_right = 422 + 63;
    	senseRect.m_bottom = 94 + 44;
    	transpRect.m_left = 424;
    	transpRect.m_top = 308;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/n.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_n.bmp");
		init_keyboardbutton(ENABLE, BUTTON_N_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//33
    	pixRect.m_left = 485;
    	pixRect.m_top = 94;
    	pixRect.m_right = 485 + 63;
    	pixRect.m_bottom = 94 + 44;
    	senseRect.m_left = 485;
    	senseRect.m_top = 94;
    	senseRect.m_right = 485 + 63;
    	senseRect.m_bottom = 94 + 44;
    	transpRect.m_left = 487;
    	transpRect.m_top = 308;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/m.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/l_m.bmp");
		init_keyboardbutton(ENABLE, BUTTON_M_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//34
    	pixRect.m_left = 548;
    	pixRect.m_top = 94;
    	pixRect.m_right = 548 + 62;
    	pixRect.m_bottom = 94 + 44;
    	senseRect.m_left = 548;
    	senseRect.m_top = 94;
    	senseRect.m_right = 548 + 62;
    	senseRect.m_bottom = 94 + 44;
    	transpRect.m_left = 550;
    	transpRect.m_top = 308;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/colon.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/semi.bmp");
		init_keyboardbutton(ENABLE, BUTTON_SEMI_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//35
    	pixRect.m_left = 610;
    	pixRect.m_top = 94;
    	pixRect.m_right = 610 + 63;
    	pixRect.m_bottom = 96 + 43;
    	senseRect.m_left = 610;
    	senseRect.m_top = 94;
    	senseRect.m_right = 610 + 63;
    	senseRect.m_bottom = 94 + 44;
    	transpRect.m_left = 612;
    	transpRect.m_top = 308;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/semicolon.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/quote.bmp");
		init_keyboardbutton(ENABLE, BUTTON_QUOTE_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//36 board
    	pixRect.m_left = 6;
    	pixRect.m_top = 138;
    	pixRect.m_right = 750;
    	pixRect.m_bottom = 139;
    	senseRect.m_left = 0;
    	senseRect.m_top = 0;
    	senseRect.m_right = 0;
    	senseRect.m_bottom = 0;
    	transpRect.m_left = 0;
    	transpRect.m_top = 0;
    	//right,bottom not used
    	transpRect.m_right = 0;
    	transpRect.m_bottom = 0;
    	memset(picU_path, 0, sizeof(picU_path));
    	memset(picL_path, 0, sizeof(picL_path));
    	init_keyboardbutton(DISABLE, BUTTON_FOURTH_BOARD_ID,  gbl_controlsImgP1, NULL, NULL, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//37
    	pixRect.m_left = 6;
    	pixRect.m_top = 139;
    	pixRect.m_right = 6 + 103;
    	pixRect.m_bottom = 139 + 44;
    	senseRect.m_left = 6;
    	senseRect.m_top = 139;
    	senseRect.m_right = 6 + 103;
    	senseRect.m_bottom = 139 + 44;
    	transpRect.m_left = 0;
    	transpRect.m_top = 0;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		init_keyboardbutton(ENABLE, BUTTON_NUMBER_ID,         gbl_controlsImgP1, NULL, NULL, gbl_numImgPD, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	// 38
    	pixRect.m_left = 109;
    	pixRect.m_top = 138;
    	pixRect.m_right = 109 + 50;
    	pixRect.m_bottom = 139 + 44;
    	senseRect.m_left = 109;
    	senseRect.m_top = 140;
    	senseRect.m_right = 109 + 50;
    	senseRect.m_bottom = 139 + 44;
    	transpRect.m_left = 106;
    	transpRect.m_top = 353;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/asterisk.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/exclam.bmp");
		init_keyboardbutton(ENABLE, BUTTON_EXCLAM_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//39
    	pixRect.m_left = 159;
    	pixRect.m_top = 139;
    	pixRect.m_right = 159 + 51;
    	pixRect.m_bottom = 139 + 44;
    	senseRect.m_left = 159;
    	senseRect.m_top = 139;
    	senseRect.m_right = 159 + 51;
    	senseRect.m_bottom = 139 + 44;
    	transpRect.m_left = 155;
    	transpRect.m_top = 353;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/@.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/question.bmp");
		init_keyboardbutton(ENABLE, BUTTON_QUEST_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//40
    	pixRect.m_left = 210;
    	pixRect.m_top = 139;
    	pixRect.m_right = 210 + 310;
    	pixRect.m_bottom = 139 + 44;
    	senseRect.m_left = 210;
    	senseRect.m_top = 139;
    	senseRect.m_right = 210 + 309;
    	senseRect.m_bottom = 139 + 44;
    	transpRect.m_left = 0;
    	transpRect.m_top = 0;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		init_keyboardbutton(ENABLE, BUTTON_SPACE_ID,  gbl_controlsImgP1, NULL, NULL, gbl_spaceImgP, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//41
    	pixRect.m_left = 520;
    	pixRect.m_top = 139;
    	pixRect.m_right = 520 + 50;
    	pixRect.m_bottom = 139 + 44;
    	senseRect.m_left = 520;
    	senseRect.m_top = 139;
    	senseRect.m_right = 520 + 49;
    	senseRect.m_bottom = 139 + 44;
    	transpRect.m_left = 515;
    	transpRect.m_top = 353;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/less.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/comma.bmp");
		init_keyboardbutton(ENABLE, BUTTON_COMMA_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//41
    	pixRect.m_left = 570;
    	pixRect.m_top = 139;
    	pixRect.m_right = 570 + 51;
    	pixRect.m_bottom = 139 + 44;
    	senseRect.m_left = 570;
    	senseRect.m_top = 139;
    	senseRect.m_right = 570 + 50;
    	senseRect.m_bottom = 139 + 44;
    	transpRect.m_left = 566;
    	transpRect.m_top = 353;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/greater.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/dot.bmp");
		init_keyboardbutton(ENABLE, BUTTON_DOT_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//42
		pixRect.m_left = 621;
		pixRect.m_top = 139;
		pixRect.m_right = 621 + 52;
		pixRect.m_bottom = 139 + 44;
		senseRect.m_left = 621;
		senseRect.m_top = 139;
		senseRect.m_right = 621 + 51;
		senseRect.m_bottom = 139 + 44;
		transpRect.m_left = 617;
		transpRect.m_top = 353;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/_.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/dash.bmp");
		init_keyboardbutton(ENABLE, BUTTON_DASH_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//43
    	pixRect.m_left = 673;
    	pixRect.m_top = 138;
    	pixRect.m_right = 673 + 77;
    	pixRect.m_bottom = 138 + 45;
    	senseRect.m_left = 673;
    	senseRect.m_top = 139;
    	senseRect.m_right = 673 + 77;
    	senseRect.m_bottom = 138 + 45;
    	transpRect.m_left = 677;
    	transpRect.m_top = 353;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));	
		sprintf(picU_path, PIC_DIR_PATH);
		strcat(picU_path, "letters/bar.bmp");
		sprintf(picL_path, PIC_DIR_PATH);
		strcat(picL_path, "letters/slash.bmp");
		init_keyboardbutton(ENABLE, BUTTON_SLASH_ID,  gbl_controlsImgP1, gbl_controlsDisImgP1, gbl_controlsDisImgP2, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//44 board
    	pixRect.m_left = 750;
    	pixRect.m_top = 14;
    	pixRect.m_right = 750 + 4;
    	pixRect.m_bottom = 72;
    	senseRect.m_left = 0;
    	senseRect.m_top = 0;
    	senseRect.m_right = 0;
    	senseRect.m_bottom = 0;
    	transpRect.m_left = 0;
    	transpRect.m_top = 0;
    	//right,bottom not used
    	transpRect.m_right = 0;
    	transpRect.m_bottom = 0;
    	memset(picU_path, 0, sizeof(picU_path));
    	memset(picL_path, 0, sizeof(picL_path));
    	init_keyboardbutton(DISABLE, BUTTON_CLOSE_LEFT_BOARD_ID,  gbl_controlsImgP1, NULL, NULL, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//45 board
    	pixRect.m_left = 750;
    	pixRect.m_top = 5;
    	pixRect.m_right = 750 + 50;
    	pixRect.m_bottom = 14;
    	senseRect.m_left = 0;
    	senseRect.m_top = 0;
    	senseRect.m_right = 0;
    	senseRect.m_bottom = 0;
    	transpRect.m_left = 0;
    	transpRect.m_top = 0;
    	//right,bottom not used
    	transpRect.m_right = 0;
    	transpRect.m_bottom = 0;
    	memset(picU_path, 0, sizeof(picU_path));
    	memset(picL_path, 0, sizeof(picL_path));
    	init_keyboardbutton(DISABLE, BUTTON_CLOSE_TOP_BOARD_ID,  gbl_controlsImgP1, NULL, NULL, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//46
    	pixRect.m_left = 754;
    	pixRect.m_top = 14;
    	pixRect.m_right = 754 + 40;
    	pixRect.m_bottom = 14 + 58;
    	senseRect.m_left = 754;
    	senseRect.m_top = 14;
    	senseRect.m_right = 754 + 40;
    	senseRect.m_bottom = 14 + 58;
    	transpRect.m_left = 0;
    	transpRect.m_top = 0;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		init_keyboardbutton(ENABLE, BUTTON_CLOSE_ID,  gbl_controlsImgP1, NULL, NULL, gbl_closeImgP, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//47
    	pixRect.m_left = 750;
    	pixRect.m_top = 72;
    	pixRect.m_right = 750 + 44;
    	pixRect.m_bottom = 72 + 111;
    	senseRect.m_left = 750;
    	senseRect.m_top = 72;
    	senseRect.m_right = 750 + 44;
    	senseRect.m_bottom = 72 + 111;
    	transpRect.m_left = 0;
    	transpRect.m_top = 0;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		init_keyboardbutton(DISABLE, BUTTON_FUN_ID,  gbl_controlsImgP1, NULL, NULL, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
	// =======================================================================
	//48
    	pixRect.m_left = 794;
    	pixRect.m_top = 5;
    	pixRect.m_right = 794 + 6;
    	pixRect.m_bottom = 5 + 178;
    	senseRect.m_left = 794;
    	senseRect.m_top = 5;
    	senseRect.m_right = 794 + 6;
    	senseRect.m_bottom = 5 + 178;
    	transpRect.m_left = 0;
    	transpRect.m_top = 0;
    	//right,bottom not used
    	transpRect.m_right = 0;
    	transpRect.m_bottom = 0;
    	memset(picU_path, 0, sizeof(picU_path));
    	memset(picL_path, 0, sizeof(picL_path));
    	init_keyboardbutton(DISABLE, BUTTON_RIGHT_BOARD_ID,  gbl_controlsImgP1, NULL, NULL, NULL, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
   	// =======================================================================
	//49
    	pixRect.m_left = 756;
    	pixRect.m_top = 138;
    	pixRect.m_right = 756 + 34;
    	pixRect.m_bottom = 138 + 34;
    	senseRect.m_left = 756;
    	senseRect.m_top = 138;
    	senseRect.m_right = 756 + 34;
    	senseRect.m_bottom = 138 + 34;
    	transpRect.m_left = 0;
    	transpRect.m_top = 0;
		//right,bottom not used
		transpRect.m_right = 0;
		transpRect.m_bottom = 0;
		memset(picU_path, 0, sizeof(picU_path));
		memset(picL_path, 0, sizeof(picL_path));
		init_keyboardbutton(ENABLE, BUTTON_INFO_ID, gbl_infoImgP, NULL, NULL, gbl_press_infoImgP, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
		
		
	return 0;

}


int init_sym_controls()
{
    PPCtlInfo *oneInfoP;
    gbl_symctl_count = 0;
    gbl_bNUMBER = true;
    // ======================================================================v
    //0
    //panel_top_bar
    ppRect pixRect, senseRect, transpRect;
    char picU_path[128] = "", picL_path[128] = "";
    pixRect.m_left = 0;
    pixRect.m_top = 0;
    pixRect.m_right = 800;
    pixRect.m_bottom = 5;
    senseRect.m_left = 0;
    senseRect.m_top = 0;
    senseRect.m_right = 0;
    senseRect.m_bottom = 0;
    transpRect.m_left = 0;
    transpRect.m_top = 0;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    init_keyboardbutton(DISABLE, PANEL_TOP_BAR,  gbl_controlsImgP3, NULL, NULL, NULL,NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // ======================================================================v
    //1
    //panel_left_bar    
    pixRect.m_left = 0;
    pixRect.m_top = 0;
    pixRect.m_right = 6;
    pixRect.m_bottom = 183;
    senseRect.m_left = 0;
    senseRect.m_top = 0;
    senseRect.m_right = 0;
    senseRect.m_bottom = 0;
    transpRect.m_left = 0;
    transpRect.m_top = 0;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    init_keyboardbutton(DISABLE, PANEL_LEFT_BAR,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // ======================================================================v
    //2
    //  button_1    
    pixRect.m_left = 0;
    pixRect.m_top = 5;
    pixRect.m_right = 108;
    pixRect.m_bottom = 5+44;
    senseRect.m_left = 6;
    senseRect.m_top = 5;
    senseRect.m_right = 108;
    senseRect.m_bottom = 49;
    transpRect.m_left = 48;
    transpRect.m_top = 220;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/euro.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/1.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_1_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // ======================================================================^
    // ======================================================================v
    //3
    // button_2    
    pixRect.m_left = 108;
    pixRect.m_top = 5;
    pixRect.m_right = 108 + 63;
    pixRect.m_bottom = 49;
    senseRect.m_left = 108;
    senseRect.m_top = 5;
    senseRect.m_right = 171;
    senseRect.m_bottom = 49;
    transpRect.m_left = 112;
    transpRect.m_top = 220;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/eng_dollar.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/2.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_2_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // ======================================================================^    
    //4
    pixRect.m_left = 171;
    pixRect.m_top = 5;
    pixRect.m_right = 171 + 63;
    pixRect.m_bottom = 49;
    senseRect.m_left = 171;
    senseRect.m_top = 5;
    senseRect.m_right = 234;
    senseRect.m_bottom = 49;
    transpRect.m_left = 173;
    transpRect.m_top = 220;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/less.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/3.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_3_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //5
    pixRect.m_left = 234;
    pixRect.m_top = 5;
    pixRect.m_right = 234 + 62;
    pixRect.m_bottom = 49;
    senseRect.m_left = 234;
    senseRect.m_top = 5;
    senseRect.m_right = 296;
    senseRect.m_bottom = 49;
    transpRect.m_left = 237;
    transpRect.m_top = 220;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/more.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/4.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_4_ID,  gbl_controlsImgP3, NULL, NULL, NULL,NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //6
    pixRect.m_left = 296;
    pixRect.m_top = 5;
    pixRect.m_right = 296 + 63;
    pixRect.m_bottom = 49;
    senseRect.m_left = 296;
    senseRect.m_top = 5;
    senseRect.m_right = 296+63;
    senseRect.m_bottom = 49;
    transpRect.m_left = 300;
    transpRect.m_top = 220;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/left_square.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/5.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_5_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //7
    pixRect.m_left = 359;
    pixRect.m_top = 5;
    pixRect.m_right = 359 + 63;
    pixRect.m_bottom = 49;
    senseRect.m_left = 359;
    senseRect.m_top = 5;
    senseRect.m_right = 359+63;
    senseRect.m_bottom = 49;
    transpRect.m_left = 362;
    transpRect.m_top = 220;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/right_square.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/6.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_6_ID,  gbl_controlsImgP3, NULL, NULL, NULL,NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //8
    pixRect.m_left = 422;
    pixRect.m_top = 5;
    pixRect.m_right = 422 + 63;
    pixRect.m_bottom = 49;
    senseRect.m_left = 422;
    senseRect.m_top = 5;
    senseRect.m_right = 422+63;
    senseRect.m_bottom = 49;
    transpRect.m_left = 424;
    transpRect.m_top = 220;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/left_brace.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/7.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_7_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //9
    pixRect.m_left = 485;
    pixRect.m_top = 5;
    pixRect.m_right = 485 + 63;
    pixRect.m_bottom = 49;
    senseRect.m_left = 485;
    senseRect.m_top = 5;
    senseRect.m_right = 485+63;
    senseRect.m_bottom = 49;
    transpRect.m_left = 488;
    transpRect.m_top = 220;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/right_brace.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/8.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_8_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //10
    pixRect.m_left = 548;
    pixRect.m_top = 5;
    pixRect.m_right = 548 + 63;
    pixRect.m_bottom = 49;
    senseRect.m_left = 548;
    senseRect.m_top = 5;
    senseRect.m_right = 548+63;
    senseRect.m_bottom = 49;
    transpRect.m_left = 550;
    transpRect.m_top = 220;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/mark_c.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/9.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_9_ID,  gbl_controlsImgP3, NULL, NULL, NULL,NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //11
    pixRect.m_left = 611;
    pixRect.m_top = 5;
    pixRect.m_right = 611 + 62;
    pixRect.m_bottom = 49;
    senseRect.m_left = 611;
    senseRect.m_top = 5;
    senseRect.m_right = 611+62;
    senseRect.m_bottom = 49;
    transpRect.m_left = 613;
    transpRect.m_top = 220;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/mark_invertp.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/0.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_0_ID,  gbl_controlsImgP3,NULL, NULL, NULL,NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //12
    pixRect.m_left = 673;
    pixRect.m_top = 5;
    pixRect.m_right = 673 + 77;
    pixRect.m_bottom = 5+44;
    senseRect.m_left = 673;
    senseRect.m_top = 5;
    senseRect.m_right = 673 + 77;
    senseRect.m_bottom = 49;
    transpRect.m_left = 0;
    transpRect.m_top = 0;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));    
    init_keyboardbutton(ENABLE, BUTTON_S_BK_ID,  gbl_controlsImgP3, NULL,  NULL, gbl_delImgP, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);    
	
    // =======================================================================
    //13
    pixRect.m_left = 6;
    pixRect.m_top = 49;
    pixRect.m_right = 750;
    pixRect.m_bottom = 50;
    senseRect.m_left = 0;
    senseRect.m_top = 0;
    senseRect.m_right = 0;
    senseRect.m_bottom = 0;
    transpRect.m_left = 0;
    transpRect.m_top = 0;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));    
    init_keyboardbutton(ENABLE, PANEL_SEC_BAR,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);    
    // =======================================================================    
    //14
    pixRect.m_left = 6;
    pixRect.m_top = 50;
    pixRect.m_right = 6 + 75;
    pixRect.m_bottom = 50 + 43;
    senseRect.m_left = 6;
    senseRect.m_top = 50;
    senseRect.m_right = 81;
    senseRect.m_bottom = 50 + 43;
    transpRect.m_left = 0;
    transpRect.m_top = 0;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    init_keyboardbutton(ENABLE, BUTTON_S_TAB_ID,  gbl_controlsImgP3, NULL, NULL, gbl_tabImgP, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //15
    pixRect.m_left = 81;
    pixRect.m_top = 50;
    pixRect.m_right = 81 + 60;
    pixRect.m_bottom = 50 + 43;
    senseRect.m_left = 6;
    senseRect.m_top = 50;
    senseRect.m_right = 81 + 60;
    senseRect.m_bottom = 50 + 43;
    transpRect.m_left = 83;
    transpRect.m_top = 264;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/plus.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/exclam.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_EXCLAM_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //16
    pixRect.m_left = 141;
    pixRect.m_top = 50;
    pixRect.m_right = 141 + 62;
    pixRect.m_bottom = 50 + 43;
    senseRect.m_left = 141;
    senseRect.m_top = 50;
    senseRect.m_right = 141 + 62;
    senseRect.m_bottom = 50 + 43;
    transpRect.m_left = 143;
    transpRect.m_top = 264;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/divide.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/at.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_AT_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //17
    pixRect.m_left = 203;
    pixRect.m_top = 50;
    pixRect.m_right = 203 + 63;
    pixRect.m_bottom = 50 + 43;
    senseRect.m_left = 203;
    senseRect.m_top = 50;
    senseRect.m_right = 203 + 63;
    senseRect.m_bottom = 50 + 43;
    transpRect.m_left = 205;
    transpRect.m_top = 264;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/equal.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/number.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_NUMBERSIGN_ID,  gbl_controlsImgP3, NULL, NULL, NULL,NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //18
    pixRect.m_left = 266;
    pixRect.m_top = 50;
    pixRect.m_right = 266 + 63;
    pixRect.m_bottom = 50 + 43;
    senseRect.m_left = 266;
    senseRect.m_top = 50;
    senseRect.m_right = 266 + 63;
    senseRect.m_bottom = 50 + 43;
    transpRect.m_left = 268;
    transpRect.m_top = 264;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/comma.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/dollar.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_DOLLAR_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //19
    pixRect.m_left = 329;
    pixRect.m_top = 50;
    pixRect.m_right = 329 + 62;
    pixRect.m_bottom = 50 + 43;
    senseRect.m_left = 329;
    senseRect.m_top = 50;
    senseRect.m_right = 329 + 62;
    senseRect.m_bottom = 50 + 43;
    transpRect.m_left = 331;
    transpRect.m_top = 264;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/period.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/percent.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_PERCENT_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //20
    pixRect.m_left = 391;
    pixRect.m_top = 50;
    pixRect.m_right = 391 + 63;
    pixRect.m_bottom = 50 + 43;
    senseRect.m_left = 391;
    senseRect.m_top = 50;
    senseRect.m_right = 391 + 63;
    senseRect.m_bottom = 50 + 43;
    transpRect.m_left = 394;
    transpRect.m_top = 264;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/colon.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/caret.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_CARET_ID,  gbl_controlsImgP3, NULL, NULL, NULL,NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //21
    pixRect.m_left = 454;
    pixRect.m_top = 50;
    pixRect.m_right = 454 + 63;
    pixRect.m_bottom = 50 + 43;
    senseRect.m_left = 454;
    senseRect.m_top = 50;
    senseRect.m_right = 454 + 63;
    senseRect.m_bottom = 50 + 43;
    transpRect.m_left = 457;
    transpRect.m_top = 264;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/semi.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/ampersand.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_AMPERSAND_ID, gbl_controlsImgP3, NULL, NULL, NULL,NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //22
    pixRect.m_left = 517;
    pixRect.m_top = 50;
    pixRect.m_right = 517 + 62;
    pixRect.m_bottom = 50 + 43;
    senseRect.m_left = 517;
    senseRect.m_top = 50;
    senseRect.m_right = 517 + 62;
    senseRect.m_bottom = 50 + 43;
    transpRect.m_left = 520;
    transpRect.m_top = 264;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/mark_punc.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/asterisk.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_ASTERISK_ID,  gbl_controlsImgP3, NULL, NULL, NULL,NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //23
    pixRect.m_left = 579;
    pixRect.m_top = 50;
    pixRect.m_right = 579 + 94;
    pixRect.m_bottom = 50 + 43;
    senseRect.m_left = 579;
    senseRect.m_top = 50;
    senseRect.m_right = 579 + 94;
    senseRect.m_bottom = 50 + 43;
    transpRect.m_left = 582;
    transpRect.m_top = 264;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/double_quote.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/hyphen.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_HYPHEN_ID,  gbl_controlsImgP3, NULL, NULL, NULL,NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //24
    pixRect.m_left = 673;
    pixRect.m_top = 50;
    pixRect.m_right = 673 + 77;
    pixRect.m_bottom = 50 + 88;
    senseRect.m_left = 673;
    senseRect.m_top = 50;
    senseRect.m_right = 673 + 77;
    senseRect.m_bottom = 50 + 88;
    transpRect.m_left = 0;
    transpRect.m_top = 0;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    init_keyboardbutton(ENABLE, BUTTON_S_ENTER_ID,  gbl_controlsImgP3, NULL, NULL, gbl_enterImgP, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //25
    //PANEL_THR_BAR
    pixRect.m_left = 6;
    pixRect.m_top = 93;
    pixRect.m_right = 750;
    pixRect.m_bottom = 94;
    senseRect.m_left = 0;
    senseRect.m_top = 0;
    senseRect.m_right = 0;
    senseRect.m_bottom = 0;
    transpRect.m_left = 0;
    transpRect.m_top = 0;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    init_keyboardbutton(DISABLE, PANEL_THR_BAR,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //26
    pixRect.m_left = 6;
    pixRect.m_top = 94;
    pixRect.m_right = 6 + 103;
    pixRect.m_bottom = 94 + 44;
    senseRect.m_left = 6;
    senseRect.m_top = 94;
    senseRect.m_right = 6 + 103;
    senseRect.m_bottom = 94 + 44;
    transpRect.m_left = 0;
    transpRect.m_top = 0;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    init_keyboardbutton(ENABLE, BUTTON_S_CAPS_ID,  gbl_controlsImgP3, NULL, gbl_capsImgPU, NULL,NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //27
    pixRect.m_left = 109;
    pixRect.m_top = 94;
    pixRect.m_right = 109 + 62;
    pixRect.m_bottom = 94 + 44;
    senseRect.m_left = 109;
    senseRect.m_top = 95;
    senseRect.m_right = 109 + 62;
    senseRect.m_bottom = 94 + 44;
    transpRect.m_left = 111;
    transpRect.m_top = 308;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/exclam.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/question.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_QUEST_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //28
    pixRect.m_left = 171;
    pixRect.m_top = 94;
    pixRect.m_right = 171 + 63;
    pixRect.m_bottom = 94 + 44;
    senseRect.m_left = 171;
    senseRect.m_top = 95;
    senseRect.m_right = 171 + 63;
    senseRect.m_bottom = 94 + 44;
    transpRect.m_left = 174;
    transpRect.m_top = 308;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/at.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/comma.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_COMMA_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //29
    pixRect.m_left = 234;
    pixRect.m_top = 94;
    pixRect.m_right = 234 + 63;
    pixRect.m_bottom = 94 + 44;
    senseRect.m_left = 234;
    senseRect.m_top = 94;
    senseRect.m_right = 234 + 63;
    senseRect.m_bottom = 94 + 44;
    transpRect.m_left = 237;
    transpRect.m_top = 308;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/number.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/dot.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_DOT_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //30
    pixRect.m_left = 297;
    pixRect.m_top = 94;
    pixRect.m_right = 297 + 62;
    pixRect.m_bottom = 94 + 44;
    senseRect.m_left = 297;
    senseRect.m_top = 94;
    senseRect.m_right = 297 + 62;
    senseRect.m_bottom = 94 + 44;
    transpRect.m_left = 300;
    transpRect.m_top = 308;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/dollar.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/colon.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_COLON_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //31
    pixRect.m_left = 359;
    pixRect.m_top = 94;
    pixRect.m_right = 359 + 63;
    pixRect.m_bottom = 94 + 44;
    senseRect.m_left = 359;
    senseRect.m_top = 94;
    senseRect.m_right = 359 + 63;
    senseRect.m_bottom = 94 + 44;
    transpRect.m_left = 362;
    transpRect.m_top = 308;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/percent.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/semi.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_SEMI_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //32
    pixRect.m_left = 422;
    pixRect.m_top = 94;
    pixRect.m_right = 422 + 63;
    pixRect.m_bottom = 94 + 44;
    senseRect.m_left = 422;
    senseRect.m_top = 94;
    senseRect.m_right = 422 + 63;
    senseRect.m_bottom = 94 + 44;
    transpRect.m_left = 425;
    transpRect.m_top = 308;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/mark_left.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/singlequote.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_SINGLEQUOTE_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //33
    pixRect.m_left = 485;
    pixRect.m_top = 94;
    pixRect.m_right = 485 + 63;
    pixRect.m_bottom = 94 + 44;
    senseRect.m_left = 485;
    senseRect.m_top = 94;
    senseRect.m_right = 485 + 63;
    senseRect.m_bottom = 94 + 44;
    transpRect.m_left = 488;
    transpRect.m_top = 308;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/ampersand.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/quote.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_QUOTE_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //34
    pixRect.m_left = 548;
    pixRect.m_top = 94;
    pixRect.m_right = 548 + 62;
    pixRect.m_bottom = 94 + 44;
    senseRect.m_left = 548;
    senseRect.m_top = 94;
    senseRect.m_right = 548 + 62;
    senseRect.m_bottom = 94 + 44;
    transpRect.m_left = 551;
    transpRect.m_top = 308;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/asterisk.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/apostrophe.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_APOSTROPHE_ID,  gbl_controlsImgP3, NULL, NULL, NULL,NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //35
    pixRect.m_left = 610;
    pixRect.m_top = 94;
    pixRect.m_right = 610 + 63;
    pixRect.m_bottom = 94 + 44;
    senseRect.m_left = 610;
    senseRect.m_top = 94;
    senseRect.m_right = 610 + 63;
    senseRect.m_bottom = 94 + 44;
    transpRect.m_left = 613;
    transpRect.m_top = 308;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/dash.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/underscore.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_UNDERSCORE_ID,  gbl_controlsImgP3, NULL, NULL, NULL,NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //36
    pixRect.m_left = 6;
    pixRect.m_top = 138;
    pixRect.m_right = 750;
    pixRect.m_bottom = 139;
    senseRect.m_left = 0;
    senseRect.m_top = 0;
    senseRect.m_right = 0;
    senseRect.m_bottom = 0;
    transpRect.m_left = 0;
    transpRect.m_top = 0;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    init_keyboardbutton(DISABLE, PANEL_FOUR_BAR,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================    
    //37
    pixRect.m_left = 6;
    pixRect.m_top = 139;
    pixRect.m_right = 6 + 103;
    pixRect.m_bottom = 139 + 44;
    senseRect.m_left = 6;
    senseRect.m_top = 138;
    senseRect.m_right = 6 + 103;
    senseRect.m_bottom = 139 + 44;
    transpRect.m_left = 0;
    transpRect.m_top = 0;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    init_keyboardbutton(ENABLE, BUTTON_S_ABC_ID,  gbl_controlsImgP3, NULL, gbl_abcImgPD, NULL,NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //38
    pixRect.m_left = 103;
    pixRect.m_top = 139;
    pixRect.m_right = 103 + 55;
    pixRect.m_bottom = 139 + 44;
    senseRect.m_left = 81;
    senseRect.m_top = 103;
    senseRect.m_right = 103 + 55;
    senseRect.m_bottom = 139 + 44;
    transpRect.m_left = 103;
    transpRect.m_top = 353;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/parenleft.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/parenleft.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_PARENLEFT_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //39
    pixRect.m_left = 158;
    pixRect.m_top = 139;
    pixRect.m_right = 158 + 51;
    pixRect.m_bottom = 139 + 44;
    senseRect.m_left = 160;
    senseRect.m_top = 140;
    senseRect.m_right = 158 + 51;
    senseRect.m_bottom = 139 + 44;
    transpRect.m_left = 155;
    transpRect.m_top = 353;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/parenright.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/parenright.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_PARENRIGHT_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //40
    pixRect.m_left = 209;
    pixRect.m_top = 139;
    pixRect.m_right = 209 + 310;
    pixRect.m_bottom = 139 + 44;
    senseRect.m_left = 210;
    senseRect.m_top = 139;
    senseRect.m_right = 209 + 310;
    senseRect.m_bottom = 139 + 44;
    transpRect.m_left = 0;
    transpRect.m_top = 0;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    init_keyboardbutton(ENABLE, BUTTON_S_SPACE_ID,  gbl_controlsImgP3, NULL, NULL, gbl_spaceImgP, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //41
    pixRect.m_left = 519;
    pixRect.m_top = 139;
    pixRect.m_right = 519 + 51;
    pixRect.m_bottom = 139 + 44;
    senseRect.m_left = 519;
    senseRect.m_top = 140;
    senseRect.m_right = 519 + 51;
    senseRect.m_bottom = 139 + 44;
    transpRect.m_left = 516;
    transpRect.m_top = 353;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/big_plus.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/asciitilde.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_ASCIITILDE_ID,  gbl_controlsImgP3, NULL, NULL, NULL,NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //42
    pixRect.m_left = 570;
    pixRect.m_top = 139;
    pixRect.m_right = 570 + 51;
    pixRect.m_bottom = 139 + 44;
    senseRect.m_left = 570;
    senseRect.m_top = 139;
    senseRect.m_right = 570 + 51;
    senseRect.m_bottom = 139 + 44;
    transpRect.m_left = 567;
    transpRect.m_top = 353;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/underscore.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/bar.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_BAR_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //43
    pixRect.m_left = 621;
    pixRect.m_top = 139;
    pixRect.m_right = 621 + 52;
    pixRect.m_bottom = 139 + 44;
    senseRect.m_left = 621;
    senseRect.m_top = 140;
    senseRect.m_right = 621 + 52;
    senseRect.m_bottom = 139 + 44;
    transpRect.m_left = 619;
    transpRect.m_top = 353;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/big_equal.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/backslash.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_BACKSLASH_ID,  gbl_controlsImgP3, NULL, NULL, NULL,NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //44
    pixRect.m_left = 673;
    pixRect.m_top = 139;
    pixRect.m_right = 673 + 77;
    pixRect.m_bottom = 139 + 44;
    senseRect.m_left = 673;
    senseRect.m_top = 139;
    senseRect.m_right = 673 + 77;
    senseRect.m_bottom = 139 + 44;
    transpRect.m_left = 677;
    transpRect.m_top = 353;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    sprintf(picU_path, PIC_DIR_PATH);
    strcat(picU_path, "letters/symbols_change/big_bar.bmp");
    sprintf(picL_path, PIC_DIR_PATH);
    strcat(picL_path, "letters/symbols/slash.bmp");
    init_keyboardbutton(ENABLE, BUTTON_S_SLASH_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //45
    pixRect.m_left = 750;
    pixRect.m_top = 5;
    pixRect.m_right = 750 + 50;
    pixRect.m_bottom = 5 + 9;
    senseRect.m_left = 0;
    senseRect.m_top = 0;
    senseRect.m_right = 0;
    senseRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    init_keyboardbutton(DISABLE, CLOSE_BUTTON_TOP,  gbl_controlsImgP3, NULL, NULL, NULL,NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //46
    pixRect.m_left = 750;
    pixRect.m_top = 14;
    pixRect.m_right = 750 + 4;
    pixRect.m_bottom = 14 + 58;
    senseRect.m_left = 0;
    senseRect.m_top = 0;
    senseRect.m_right = 0;
    senseRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    init_keyboardbutton(DISABLE, CLOSE_BUTTON_LEFT,  gbl_controlsImgP3, NULL, NULL, NULL,NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //47
    pixRect.m_left = 754;
    pixRect.m_top = 14;
    pixRect.m_right = 754 + 40;
    pixRect.m_bottom = 14 + 58;
    senseRect.m_left = 754;
    senseRect.m_top = 14;
    senseRect.m_right = 754 + 40;
    senseRect.m_bottom = 14 + 58;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    init_keyboardbutton(ENABLE, BUTTON_S_CLOSE_ID,  gbl_controlsImgP3, NULL, NULL, gbl_closeImgP, NULL, &pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //48
    pixRect.m_left = 794;
    pixRect.m_top = 14;
    pixRect.m_right = 794 + 6;
    pixRect.m_bottom = 183;
    senseRect.m_left = 0;
    senseRect.m_top = 0;
    senseRect.m_right = 0;
    senseRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    init_keyboardbutton(DISABLE, PANEL_RIGHT_BAR,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //49
    pixRect.m_left = 750;
    pixRect.m_top = 72;
    pixRect.m_right = 750 + 50;
    pixRect.m_bottom = 72 + 111;
    senseRect.m_left = 0;
    senseRect.m_top = 0;
    senseRect.m_right = 0;
    senseRect.m_bottom = 0;
    transpRect.m_left = 0;
    transpRect.m_top = 0;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    init_keyboardbutton(DISABLE, BUTTON_S_FUN_ID,  gbl_controlsImgP3, NULL, NULL, NULL, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    // =======================================================================
    //50
    pixRect.m_left = 756;
    pixRect.m_top = 138;
    pixRect.m_right = 758 + 34;
    pixRect.m_bottom = 138 + 34;
    senseRect.m_left = 756;
    senseRect.m_top = 138;
    senseRect.m_right = 756 + 34;
    senseRect.m_bottom = 138 + 34;
    transpRect.m_left = 0;
    transpRect.m_top = 0;
    //right,bottom not used
    transpRect.m_right = 0;
    transpRect.m_bottom = 0;
    memset(picU_path, 0, sizeof(picU_path));
    memset(picL_path, 0, sizeof(picL_path));
    init_keyboardbutton(ENABLE, BUTTON_INFO_ID,  gbl_infoImgP, NULL,  NULL, gbl_press_infoImgP, NULL,&pixRect, &senseRect, &transpRect, picU_path, picL_path);
    return 0;

}

int init_sym_keymap()
{
    int i = 0;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_1_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_1;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_EuroSign; //0x20ac
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_2_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_2;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_LiraSign; //0x20a4
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_3_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_3;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_less;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_4_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_4;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_greater;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_5_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_5;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_bracketleft; //0x005b;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_6_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_6;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_bracketright; //0x005d;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_7_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_7;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_braceleft; //0x007b;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_8_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_8;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_braceright; //0x007d;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_9_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_9;
    gbl_sym_keymap[i].m_keycode2 = 0x00a9;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_0_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_0;
    gbl_sym_keymap[i].m_keycode2 = 0x00b6;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_BK_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_BackSpace;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_BackSpace;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_TAB_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_Tab;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_Tab;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_EXCLAM_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_exclam;
    gbl_sym_keymap[i].m_keycode2 = 0x002b;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_AT_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_at;
    gbl_sym_keymap[i].m_keycode2 = 0x00f7;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_NUMBERSIGN_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_numbersign;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_equal; //0x003d;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_DOLLAR_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_dollar;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_Armenian_comma;
    //gbl_sym_keymap[i].m_keycode2 = 0x00b8;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_PERCENT_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_percent;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_Abelowdot;
    //gbl_sym_keymap[i].m_keycode2 = 0xa143;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_CARET_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_asciicircum;
    gbl_sym_keymap[i].m_keycode2 = 0x013a;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_AMPERSAND_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_ampersand;
    gbl_sym_keymap[i].m_keycode2 = 0x013b;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_ASTERISK_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_asterisk;
    gbl_sym_keymap[i].m_keycode2 = 0x0127;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_HYPHEN_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_minus;
    gbl_sym_keymap[i].m_keycode2 = 0x0122;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_ENTER_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_Return;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_Return;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_CAPS_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_Caps_Lock;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_Caps_Lock;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_QUEST_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_question;
    gbl_sym_keymap[i].m_keycode2 = 0x0121;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_COMMA_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_comma;
    gbl_sym_keymap[i].m_keycode2 = 0x0140;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_DOT_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_period;
    gbl_sym_keymap[i].m_keycode2 = 0x0123;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_COLON_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_colon;
    gbl_sym_keymap[i].m_keycode2 = 0x0124;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_SEMI_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_semicolon;
    gbl_sym_keymap[i].m_keycode2 = 0x0125;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_SINGLEQUOTE_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_quoteright;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_leftshoe;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_QUOTE_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_quotedbl;
    gbl_sym_keymap[i].m_keycode2 = 0x0126;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_APOSTROPHE_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_grave;
    gbl_sym_keymap[i].m_keycode2 = 0x012a;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_UNDERSCORE_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_underscore;
    gbl_sym_keymap[i].m_keycode2 = 0x012d;
    i++;    
    gbl_sym_keymap[i].m_keyid = BUTTON_S_ABC_ID;
    gbl_sym_keymap[i].m_keycode1 = 0;
    gbl_sym_keymap[i].m_keycode2 = 0;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_PARENLEFT_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_parenleft;
    gbl_sym_keymap[i].m_keycode2 = 0x0128;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_PARENRIGHT_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_parenright;
    gbl_sym_keymap[i].m_keycode2 = 0x0129;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_SPACE_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_space;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_space;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_ASCIITILDE_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_asciitilde;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_3270_PA1;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_BAR_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_bar;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_Greek_horizbar;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_BACKSLASH_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_backslash;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_KP_Equal;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_S_SLASH_ID;
    gbl_sym_keymap[i].m_keycode1 = SCIM_KEY_slash;
    gbl_sym_keymap[i].m_keycode2 = SCIM_KEY_Obarred;
    i++;
    gbl_sym_keymap[i].m_keyid = BUTTON_INFO_ID;
    gbl_sym_keymap[i].m_keycode1 = 0;
    gbl_sym_keymap[i].m_keycode2 = 0;
    i++;
    return i;
}
*/
#endif


