#ifndef __WIDECHARACTER_H__
#define __WIDECHARACTER_H__
#pragma once

//#include <iostream>
#include <stdio.h>
#include "Definitions.h"
#include <string.h> 
#include <gtk/gtk.h> 
#include <gdk/gdkx.h> 
 


#if defined(__WINDOWS__)

// VC6
//typedef unsigned char wchar_t;

// VC7 and last
// Microsoft C++ compiler: wchar_t is 2 bytes (UTF-16)

#elif defined(__MACOSX__)

//#include <MacTypes.h>
//typedef unsigned char	wchar_t;
#include "wchar.h"

#elif defined(__LINUX__)


#include "wchar.h"
// GCC compiler: wchar_t is 4 bytes (UTF-32)

#endif


// this structure for writing to a binary file.
struct UTF32Bytes
{
	unsigned char byte0;
	unsigned char byte1;
	unsigned char byte2;
	unsigned char byte3;
};

int wcCompareTo(wchar_t a, wchar_t b, bool ignoreCase);
bool wcEquals(wchar_t a, wchar_t b, bool ignoreCase);


size_t GetLength(wchar_t* in_characters);
size_t GetLength(UTF32Bytes* in_UTF32String);

int CompareTo(wchar_t* a, wchar_t* b, bool ignoreCase);
bool Equals(wchar_t* a, wchar_t* b, bool ignoreCase);
bool StartsWith(wchar_t* a, wchar_t* b, bool ignoreCase);

#if defined(__LINUX__) || defined(__MACOSX__)
void OutputDebugString(wchar_t* in_string);

typedef enum
{
	BOM_NONE = 0x00,
	BOM_UTF16LE = 0x01, // UTF-16 Little-Endian (Windows)
	BOM_UTF16BE = 0x02, // UTF-16 Big-Endian (Mac)
	BOM_UTF8 = 0x03,
	BOM_ERROR = 0xFF
}BOM_TYPE;

BOM_TYPE hasBOM(FILE* in_file);
wchar_t* myFGetWS(wchar_t* out_buffer, size_t in_buffer_length, FILE* in_UTF16_file);
#endif


bool wchar_tToUTF32Bytes(UTF32Bytes* pTarget, wchar_t* pSource);
bool UTF32BytesTowchar_t(wchar_t* pTarget, UTF32Bytes* pSource);


#endif
