#include <wchar.h>
#include "Definitions.h"
#include "WideCharacter.h"

#if defined(__MACOSX__)
#include <Carbon/Carbon.h>
#endif


// a > b return 1
// a == b return 0
// a < b return -1
int wcCompareTo(wchar_t a, wchar_t b, bool ignoreCase)
{
	if(ignoreCase)
	{
		wchar_t cmpA, cmpB;
		
		// A:0x0041 ~ Z:0x005A
		// a:0x0061 ~ z:0x007A
		if(a >= 0x0041 && a<= 0x005A)
		{
			cmpA = a + 0x0020;
		}
		else
		{
			cmpA = a;
		}

		// A:0x0041 ~ Z:0x005A
		// a:0x0061 ~ z:0x007A
		if(b >= 0x0041 && b<= 0x005A)
		{
			cmpB = b + 0x0020;
		}
		else
		{
			cmpB = b;
		}

		if(cmpA > cmpB)
			return 1;
		else if(cmpA == cmpB)
			return 0;
		else //if(cmpA < cmpB)
			return -1;
	}
	else
	{
		if(a > b)
			return 1;
		else if(a == b)
			return 0;
		else //if(a < b)
			return -1;
	}
}


bool wcEquals(wchar_t a, wchar_t b, bool ignoreCase)
{
	if(::wcCompareTo(a, b, ignoreCase) == 0)
		return true;
	else
		return false;
}


size_t GetLength(wchar_t* in_characters)
{
	if(in_characters == NULL)
		return 0;
	else
	{
		for(size_t i = 0; i< UINT_MAX; i++)
		{
			// Return code of Windows text file: 0x0D 0x0A
			// Return code of Unix text file: 0x0A
			if( (in_characters[i] == 0x0000) ||
				(in_characters[i] == 0x000D) ||
				(in_characters[i] == 0x000A) )
			{
				return i;
			}
		}

		return 0;
	}
}

size_t GetLength(UTF32Bytes* in_UTF32String)
{
	if(in_UTF32String == NULL)
		return 0;
	else
	{
		for(size_t i = 0; i< UINT_MAX; i++)
		{
			// Return code of Windows text file: 0x0D 0x0A
			// Return code of Unix text file: 0x0A
			if( (in_UTF32String[i].byte0 == 0x00 && 
				 in_UTF32String[i].byte1 == 0x00 &&
				 in_UTF32String[i].byte2 == 0x00 &&
				 in_UTF32String[i].byte3 == 0x00 ) ||
				(in_UTF32String[i].byte0 == 0x0D && 
				 in_UTF32String[i].byte1 == 0x00 &&
				 in_UTF32String[i].byte2 == 0x00 &&
				 in_UTF32String[i].byte3 == 0x00 ) ||
				(in_UTF32String[i].byte0 == 0x0A && 
				 in_UTF32String[i].byte1 == 0x00 &&
				 in_UTF32String[i].byte2 == 0x00 &&
				 in_UTF32String[i].byte3 == 0x00 ) )
			{
				return i;
			}
		}

		return 0;
	}
}



// a > b return 1
// a == b return 0
// a < b return -1
int CompareTo(wchar_t* a, wchar_t* b, bool ignoreCase)
{
	if(a == NULL && b == NULL)
	{
		return 0;
	}
	else if(a == NULL && b != NULL)
	{
		return -1;
	}
	else if(a != NULL && b == NULL)
	{
		return 1;
	}
	else //if(a != NULL && b != NULL)
	{
		size_t i = 0;
		for(i=0; (a[i] != 0x00) && (b[i] != 0x00) && (i < UINT_MAX); i++)
		{
			int result = wcCompareTo(a[i], b[i], ignoreCase);
			if(result != 0)
			{
				return result;
			}
		}

		if(	(a[i] == 0x00) && (b[i] == 0x00) )
		{
			return 0;
		}
		else if(a[i] != 0x00)
		{
			return 1;
		}
		else if(b[i] != 0x00)
		{
			return -1;
		}

	}

	return 0;
}


// Zero ending unicode string -----------------------------------------------


// Does string a equal string b ?
bool Equals(wchar_t* a, wchar_t* b, bool ignoreCase)
{
	if(::CompareTo(a, b, ignoreCase) == 0)
		return true;
	else
		return false;
}


// Does string a start with string b?
bool StartsWith(wchar_t* a, wchar_t* b, bool ignoreCase)
{
	if(a == NULL && b == NULL)
	{
		return true;
	}
	else if(a == NULL && b != NULL)
	{
		return false;
	}
	else if(a != NULL && b == NULL)
	{
		return true;
	}
	else //if(a != NULL && b != NULL)
	{
		size_t i = 0;
		for(i=0;
			(a[i] != 0x00) &&
			(b[i] != 0x00) && 
			i < UINT_MAX;
		i++)
		{
			if(wcEquals(a[i], b[i], ignoreCase) == false)
			{
				return false;
			}
		}

		if( ( (a[i] == 0x00) && (b[i] == 0x00) ) ||
			( (a[i] != 0x00) && (b[i] == 0x00) ) )
		{
			return true;
		}
		else
		{
			return false;
		}
	}
}

#if defined(__LINUX__) || defined(__MACOSX__)

void OutputDebugString(wchar_t* in_string)
{
    if(in_string != NULL)
    {
        wprintf(in_string);
    }
}

#endif

#if defined(__LINUX__) || defined(__MACOSX__)

BOM_TYPE hasBOM(FILE* in_file)
{
	if(fseek(in_file, 0L, SEEK_SET) != 0)
	{
		return BOM_ERROR;
	}
	else
	{
		unsigned char buffer[4];
		memset(buffer, 0, 4*sizeof(unsigned char));
		
		size_t nRead = fread(buffer, sizeof(unsigned char), 3, in_file);
		if(nRead  >  0)
		{
			if(nRead == 1)
			{
				fseek(in_file, 0L, SEEK_SET);
				return BOM_NONE;
			}
			else //if(nRead > 1)
			{
				// BOM
				// UTF-16 Little-Endian (Windows)
				unsigned char UTF16LE_BOM[2] = {0xFF, 0xFE};
				// UTF-16 Big-Endian (Mac)
				unsigned char UTF16BE_BOM[2] = {0xFE, 0xFF};
	
				unsigned char UTF8_BOM[3] = {0xEF, 0xBB, 0xBF};			
			
				if(UTF16LE_BOM[0] == buffer[0] && UTF16LE_BOM[1] == buffer[1])
				{
					if(fseek(in_file, 2*sizeof(char), SEEK_SET) == 0)
						return BOM_UTF16LE;
					else
						return BOM_ERROR;
				}
				
				if(UTF16BE_BOM[0] == buffer[0] && UTF16BE_BOM[1] == buffer[1])
				{
					if(fseek(in_file, 2*sizeof(char), SEEK_SET) == 0)
						return BOM_UTF16BE;
					else
						return BOM_ERROR;
				}
				
				if(nRead >=3)
				{
					if( UTF8_BOM[0] == buffer[0] && 
						UTF8_BOM[1] == buffer[1] &&
						UTF8_BOM[2] == buffer[2] )
					{
						if(fseek(in_file, 3*sizeof(char), SEEK_SET) == 0)
							return BOM_UTF8;
						else
							return BOM_ERROR;
					}
				
				}
				
				fseek(in_file, 0L, SEEK_SET);
				return BOM_NONE;
			}
		}
		else
		{
			fseek(in_file, 0L, SEEK_SET);
			return BOM_ERROR;
		}
	}
}

bool IsUTF16LineBreak(unsigned char* in_string, size_t in_string_length, size_t* out_RN_size, bool* out_LE)
{
	if(in_string_length < 2)
	{
		if(out_RN_size != NULL) *out_RN_size = 0;
		if(out_LE != NULL) *out_LE = true;
		return false;
	}
	
	// line break:	
	unsigned char RN_DOS[2][4] = { 
		{0x0D, 0x00, 0x0A, 0x00},	// \r\n UTF-16 Little-Endian
		{0x00, 0x0D, 0x00, 0x0A}	// \r\n UTF-16 Big-Endian
	};
		
	unsigned char RN_UNIX_MAC[4][2] = {
		{0x0A, 0x00},	// \n UNIX UTF-16 Little-Endian
		{0x00, 0x0A},	// \n UNIX UTF-16 Big-Endian
		{0x0D, 0x00},	// \r MAC UTF-16 Little-Endian
		{0x00, 0x0D}	// \r MAC UTF-16 Big-Endian
	};
	
	bool bEqual = false;
	
	if(in_string_length >= 4)
	{
		for(size_t i=0; i<2; i++)
		{
			for(size_t j=0; j<4; j++)
			{
				bEqual = (in_string[j] == RN_DOS[i][j]);
				if(bEqual == false)	break;
			}
			if(bEqual == true)
			{
				if(out_RN_size != NULL) *out_RN_size = 4;
				if(out_LE != NULL) *out_LE = (i%2 == 0);			
				return true;
			}
			
			bEqual = false;
		}
	}
	
	for(size_t i=0; i<4; i++)
	{
		for(size_t j=0; j<2; j++)
		{
			bEqual = (in_string[j] == RN_UNIX_MAC[i][j]);
			if(bEqual == false)	break;
		}
		if(bEqual == true)
		{
			if(out_RN_size != NULL) *out_RN_size = 2;
			if(out_LE != NULL) *out_LE = (i%2 == 0);			
			return true;
		}
			
		bEqual = false;
	}

	if(out_RN_size != NULL) *out_RN_size = 0;
	if(out_LE != NULL) *out_LE = true;			
	return false;	
} 

// my fgetws()
wchar_t* myFGetWS(wchar_t* out_buffer, size_t in_buffer_length, FILE* in_UTF16_file)
{
	if(in_UTF16_file == NULL || out_buffer == NULL || in_buffer_length <= 0) return NULL;
	
	memset(out_buffer, 0, in_buffer_length*sizeof(wchar_t));
	
	size_t nReadBytes = in_buffer_length;
	size_t nReturn = 0;
	unsigned char* pRead = NULL;
	pRead = new unsigned char[nReadBytes];
	if(pRead != NULL)
	{
		memset(pRead, 0, nReadBytes);
		
		nReturn = fread(pRead, sizeof(unsigned char), nReadBytes, in_UTF16_file);
		
		if(nReturn > 0)
		{
			for(size_t i=0; i<nReturn; i++)
			{
				size_t sizeRN = 0;
				bool bLE = true;
				if(IsUTF16LineBreak(&(pRead[i]), (nReturn-i), &sizeRN, &bLE))
				{
					if(i>0)
					{
						size_t iBuffer = 0;
						size_t iRead = 0;
						while(iRead<i && iBuffer <in_buffer_length)
						{
							if(iRead+1 < i)
							{
								if(bLE)
								{
									// Little-Endian
									out_buffer[iBuffer] = (wchar_t)pRead[iRead+1] << 8;
                                    out_buffer[iBuffer] |= (wchar_t)pRead[iRead];
								}
								else
								{
									// Big-Endian                                                                
									out_buffer[iBuffer] = (wchar_t)pRead[iRead] << 8;
                                    out_buffer[iBuffer] |= (wchar_t)pRead[iRead+1];
								}
								iRead += 2;
							}
							else
							{
								out_buffer[iBuffer] = pRead[iRead];
								iRead++;
							}
							
							iBuffer++;
						}
						long nOffset = (i+sizeRN) - nReturn;
						
						if(fseek(in_UTF16_file, nOffset, SEEK_CUR) != 0)
						{
#ifdef OUTPUT_DEBUG_STRING
							OutputDebugString(L"fseek() failed!\r\n");
#endif
						}
					}
					
					break;
				}
			}
			delete [] pRead;
			
			return out_buffer;
		}
		else
		{
			delete [] pRead;
			return NULL;
		}
	}
	else {
		return NULL;
	}

	return NULL;
}

#endif



bool wchar_tToUTF32Bytes(UTF32Bytes* pTarget, wchar_t* pSource)
{
	const size_t wchar_t_size = sizeof(wchar_t);

	if(pTarget == NULL) return false;
	if(pSource == NULL) return false;

	if(wchar_t_size == 2)
	{
#if defined(__WINDOWS__)

		wchar_t tmp = 0x0000;

		tmp = *pSource;
		tmp &= 0x00FF;
		pTarget->byte0 = (unsigned char)tmp;

		tmp = *pSource;
		tmp &= 0xFF00;
		tmp = tmp >> 8;
		pTarget->byte1 = (unsigned char)tmp;

		pTarget->byte2 = 0x00;
		pTarget->byte3 = 0x00;

#endif
	}
	else if(wchar_t_size == 4)
	{
#if defined(__LINUX__) || defined(__MACOSX__)

		wchar_t tmp = 0x00000000;

		tmp = *pSource;
		tmp &= 0x000000FF;
		pTarget->byte0 = (unsigned char)tmp;

		tmp = *pSource;
		tmp &= 0x0000FF00;
		tmp = tmp >> 8;
		pTarget->byte1 = (unsigned char)tmp;

		tmp = *pSource;
		tmp &= 0x00FF0000;
		tmp = tmp >> 16;
		pTarget->byte2 = (unsigned char)tmp;

		tmp = *pSource;
		tmp &= 0xFF000000;
		tmp = tmp >> 24;
		pTarget->byte3 = (unsigned char)tmp;

#endif
	}					

	return true;
}

bool UTF32BytesTowchar_t(wchar_t* pTarget, UTF32Bytes* pSource)
{
	const size_t wchar_t_size = sizeof(wchar_t);

	if(pTarget == NULL) return false;
	if(pSource == NULL) return false;

	if(wchar_t_size == 2)
	{
#if defined(__WINDOWS__)

		wchar_t tmp = 0x0000;

		*pTarget = (wchar_t)pSource->byte0;
		
		tmp = 0x0000;
		tmp = (wchar_t)pSource->byte1;
		tmp = tmp << 8;
		*pTarget |= tmp;

#endif
	}
	else if(wchar_t_size == 4)
	{
#if defined(__LINUX__) || defined(__MACOSX__)

		wchar_t tmp = 0x00000000;

		*pTarget = (wchar_t)pSource->byte0;
		
		tmp = 0x00000000;
		tmp = (wchar_t)pSource->byte1;
		tmp = tmp << 8;
		*pTarget |= tmp;

		tmp = 0x00000000;
		tmp = (wchar_t)pSource->byte2;
		tmp = tmp << 16;
		*pTarget |= tmp;


		tmp = 0x00000000;
		tmp = (wchar_t)pSource->byte3;
		tmp = tmp << 24;
		*pTarget |= tmp;

#endif
	}					

	return true;
}
