#ifndef __UNICODESTRING_H__
#define __UNICODESTRING_H__
#pragma once

//#include <iostream>
//#include <limits>
#include <string.h>
#include "WideCharacter.h"


class CUnicodeString
{
private:
	wchar_t*	m_pCharacters;	// Zero ending unicode string.
	size_t		m_nLength;

public:
	CUnicodeString();
	virtual ~CUnicodeString();
	virtual void Dispose();

	size_t GetLength()
	{
		return m_nLength;
	}

	bool SetString(wchar_t* in_characters);
	bool SetString(CUnicodeString* in_string);
	bool SetString(UTF32Bytes* in_UTF32String);

	bool GetString(wchar_t* out_buffer, size_t in_buffer_size, size_t* out_length);

	bool GetWChar(size_t in_index, wchar_t* out_character);

	int CompareTo(wchar_t* value, bool ignoreCase);
	int CompareTo(CUnicodeString* value, bool ignoreCase);

	bool Equals(wchar_t* value, bool ignoreCase);
	bool Equals(CUnicodeString* value, bool ignoreCase);

	bool StartsWith(wchar_t* value, bool ignoreCase);
	bool StartsWith(CUnicodeString* value, bool ignoreCase);

	bool ConvertToUTF32Bytes(UTF32Bytes* pUTF32String, size_t uBufferSize);
	void ShowDebugString();

	// the functions in WideCharacter.h
	friend int CompareTo(wchar_t* a, wchar_t* b, bool ignoreCase);
	friend bool Equals(wchar_t* a, wchar_t* b, bool ignoreCase);
	friend bool StartsWith(wchar_t* a, wchar_t* b, bool ignoreCase);
};


#endif
