#include "PPInfownd.h"

//////////////////////////////////////////////////////////////////////////////////////////
// 
// info window functions 
//
//////////////////////////////////////////////////////////////////////////////////////////

#define L_ENGLISH		2001
#define L_SIMPCHINESE   2002
#define L_TRADCHINESE   2003
#define PIC_INFO_TRADCHINESE_PATH "datas//about_cht.png"
#define PIC_INFO_SIMPCHINESE_PATH "datas//about_chs.png"
#define PIC_INFO_ENGLISH_PATH "datas//about_eng.png"
#define PIC_INFO_CLOSE_PATH "datas//about_close_over.png"

#define PPINFO_MOUSE_EVENTS ( GDK_PROXIMITY_IN_MASK | \
                              GDK_PROXIMITY_OUT_MASK | \
                              GDK_BUTTON_MOTION_MASK | \
                              GDK_BUTTON_PRESS_MASK | \
                              GDK_BUTTON_RELEASE_MASK )


bool gbl_binfoshow = false;
int gbl_language;
int gbl_info_stat = PPOD_CTL_STATE_0;
GtkWidget *gbl_infoWindow;
GdkPixbuf *gbl_infowindowImg;
GdkPixbuf *gbl_infoCloseImg;
GtkWidget *gbl_infoDrawArea;

void DestroyInfoWindow();
bool GrabMainPointer(GtkWidget *window);
void UnGrabMainPointer();

//--------------------------------------------------------------------------------
// FUNCTION : capture specify rectangle
// PARAM :
// RETURN : screen pixbuf pointer
//--------------------------------------------------------------------------------
GdkPixbuf* CaptureScreenEx(gint x, gint y, gint nWidth, gint nHeight)
{
	GdkScreen		*screen    = NULL;
	GdkWindow	*window = NULL;
	GdkPixbuf		*ppbScreen= NULL;

	screen = gdk_screen_get_default();
	window = gdk_screen_get_root_window (screen);
	ppbScreen = gdk_pixbuf_get_from_drawable (NULL, window, NULL, x, y, 0, 0, nWidth, nHeight);

	return ppbScreen;
}

//----------------------------------------------------------------------------------------
// FUNCTION	: 
// PARAM	: 
// RETURN	: 
// NOTE		: 
//----------------------------------------------------------------------------------------
gboolean FindInSenseXY(gdouble x,gdouble y)
{
    if (((x >= 560 ) && (x <= 593 )) &&
        ((y >= 16 ) && (y <= 49 )))
    {
        return true;
    }
    else
        return false;
}

//----------------------------------------------------------------------------------------
// FUNCTION	: 
// PARAM	: 
// RETURN	: 
// NOTE		: 
//----------------------------------------------------------------------------------------
gboolean on_expose_info_event(GtkWidget *widget,GdkEventExpose *event,gpointer user_data)
{
    GdkPixbuf    *pixbufScreen;
    int width = gdk_pixbuf_get_width(gbl_infowindowImg);
    int height = gdk_pixbuf_get_height(gbl_infowindowImg);

    if(gbl_infowindowImg == NULL || width <= 0 || height <= 0)
        return FALSE;

	gint 			x,y;
	GdkScreen		*screen    = NULL;
	screen = gdk_screen_get_default();
	x = gdk_screen_get_width (screen);
	y = gdk_screen_get_height (screen);

	x = (x/2) - 310;
	y = (y/2) - 206;

    pixbufScreen = CaptureScreenEx(x, y, width, height);
    gdk_draw_pixbuf(gbl_infoDrawArea->window, gbl_infoDrawArea->style->white_gc, pixbufScreen, 0, 0, 0, 0, width, height,GDK_RGB_DITHER_NONE, 0, 0);
    gdk_draw_pixbuf(gbl_infoDrawArea->window, gbl_infoDrawArea->style->white_gc, gbl_infowindowImg, 0, 0, 0, 0, width, height,GDK_RGB_DITHER_NONE, 0, 0);
	return true;
}

//----------------------------------------------------------------------------------------
// FUNCTION	: 
// PARAM	: 
// RETURN	: 
// NOTE		: 
//----------------------------------------------------------------------------------------
gboolean on_button_press_info_event(GtkWidget *widget, GdkEventButton *event)
{
	if(gbl_infoWindow != 0)
    {
        if(event->type == GDK_BUTTON_PRESS)
        {
            if(FindInSenseXY(event->x, event->y))
            {
                gbl_info_stat = PPOD_CTL_STATE_1;

                if(gbl_infoCloseImg != NULL)
                {
                    int width = gdk_pixbuf_get_width(gbl_infoCloseImg);
                    int height = gdk_pixbuf_get_height(gbl_infoCloseImg);
                    gdk_draw_pixbuf(gbl_infoDrawArea->window, gbl_infoDrawArea->style->white_gc, gbl_infoCloseImg, 0, 0, 560, 16, width, height,GDK_RGB_DITHER_NONE, 0, 0);
                }
            }
        }
    }
    return TRUE;
}

//----------------------------------------------------------------------------------------
// FUNCTION	: 
// PARAM	: 
// RETURN	: 
// NOTE		: 
//----------------------------------------------------------------------------------------
gboolean on_motion_notify_info_event( GtkWidget *widget, GdkEventMotion *event )
{
    static bool b_find = false;

    if(gbl_infoWindow != 0)
    {
        int width = gdk_pixbuf_get_width(gbl_infoCloseImg);
        int height = gdk_pixbuf_get_height(gbl_infoCloseImg);
        GdkModifierType state;
        gint x, y;

        if(event->is_hint)
        {
            gdk_window_get_pointer(event->window, &x, &y, &state);
        }
        else
        {
            x = event->x;
            y = event->y;
        }

        if(FindInSenseXY(x, y))
        {
            if(gbl_info_stat == PPOD_CTL_STATE_1)
            {
                gbl_info_stat = PPOD_CTL_STATE_2;
            }
            if(gbl_infoCloseImg != NULL)
            {
                if( (gbl_info_stat == PPOD_CTL_STATE_2) && (b_find == false))
                {
                    b_find = true;
                    gdk_draw_pixbuf(gbl_infoDrawArea->window, gbl_infoDrawArea->style->white_gc, gbl_infoCloseImg, 0, 0, 560, 16, width, height,GDK_RGB_DITHER_NONE, 0, 0);
                }
            }
        }
        else
        {
            if( (gbl_info_stat == PPOD_CTL_STATE_2) && b_find)
            {
                b_find = false;
                gdk_draw_pixbuf(gbl_infoDrawArea->window, gbl_infoDrawArea->style->white_gc, gbl_infowindowImg, 560, 16, 560, 16, width, height,GDK_RGB_DITHER_NONE, 0, 0);
                
            }
        }
        
    }
    return TRUE;
}

//----------------------------------------------------------------------------------------
// FUNCTION	: 
// PARAM	: 
// RETURN	: 
// NOTE		: 
//----------------------------------------------------------------------------------------
gboolean on_button_release_info_event(GtkWidget *widget, GdkEventMotion *event)
{
    if(gbl_infoWindow != 0)
    {
        if(event->type == GDK_BUTTON_RELEASE)
        {
            if(FindInSenseXY(event->x, event->y))
            {
                gbl_info_stat = PPOD_CTL_STATE_0;
                gtk_widget_hide_all(gbl_infoWindow);
                gbl_binfoshow = false;
                DestroyInfoWindow();
            }
			else
			{
			    gbl_info_stat = PPOD_CTL_STATE_0;
			}
        }
    }
    return TRUE;
}

//----------------------------------------------------------------------------------------
// FUNCTION	: 
// PARAM	: 
// RETURN	: 
// NOTE		: 
//----------------------------------------------------------------------------------------
gboolean CreateInfoWindow()
{   
    if(gbl_language == L_TRADCHINESE)
    {
	    gbl_infowindowImg = gdk_pixbuf_new_from_file(PIC_INFO_TRADCHINESE_PATH,0);
	}
    else if(gbl_language == L_SIMPCHINESE)
	{
	   gbl_infowindowImg = gdk_pixbuf_new_from_file(PIC_INFO_SIMPCHINESE_PATH,0);
	}     
	else
	{
		//w]^
		gbl_infowindowImg = gdk_pixbuf_new_from_file(PIC_INFO_ENGLISH_PATH,0);
	}

    gbl_infoCloseImg = gdk_pixbuf_new_from_file(PIC_INFO_CLOSE_PATH, 0);
    if(gbl_infowindowImg == NULL)
        return FALSE;

    int width = gdk_pixbuf_get_width(gbl_infowindowImg);
    int height = gdk_pixbuf_get_height(gbl_infowindowImg);

    gbl_infoWindow = gtk_window_new(GTK_WINDOW_POPUP);

    if(gbl_infoWindow == NULL)
        return FALSE;

    gtk_widget_set_usize(gbl_infoWindow, width, height);
    gtk_window_set_resizable(GTK_WINDOW(gbl_infoWindow), FALSE);

	
	gint 			x,y;
	GdkScreen		*screen    = NULL;
	screen = gdk_screen_get_default();
	x = gdk_screen_get_width (screen);
	y = gdk_screen_get_height (screen);

	x = (x/2) - 310;
	y = (y/2) - 206;
	gtk_window_move(GTK_WINDOW(gbl_infoWindow), x, y);

	//gtk_window_move(GTK_WINDOW(gbl_infoWindow), 80, 40);
    // create paint area in window
    gbl_infoDrawArea = gtk_drawing_area_new();
    gtk_widget_set_size_request(gbl_infoDrawArea, width, height);
    
    if(gbl_infoDrawArea == NULL)
    {
        gtk_widget_destroy(gbl_infoWindow);
        gbl_infoWindow = NULL;
        return FALSE;
    }
    gtk_signal_connect(GTK_OBJECT(gbl_infoDrawArea), "expose_event", GTK_SIGNAL_FUNC(on_expose_info_event), NULL);
    gtk_signal_connect(GTK_OBJECT(gbl_infoDrawArea), "button_press_event", GTK_SIGNAL_FUNC(on_button_press_info_event), NULL);
    gtk_signal_connect(GTK_OBJECT(gbl_infoDrawArea), "button_release_event", GTK_SIGNAL_FUNC(on_button_release_info_event), NULL);
    gtk_signal_connect(GTK_OBJECT(gbl_infoDrawArea), "motion_notify_event",GTK_SIGNAL_FUNC(on_motion_notify_info_event), NULL);    
    gtk_widget_set_events (GTK_WIDGET(gbl_infoDrawArea), GDK_EXPOSURE_MASK | GDK_LEAVE_NOTIFY_MASK | GDK_BUTTON_PRESS_MASK | GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK | GDK_BUTTON_RELEASE_MASK );

    gtk_container_add(GTK_CONTAINER(gbl_infoWindow), gbl_infoDrawArea);
    gtk_widget_show_all(gbl_infoWindow);
	return true;
}

//----------------------------------------------------------------------------------------
// FUNCTION	: 
// PARAM	: 
// RETURN	: 
// NOTE		: 
//----------------------------------------------------------------------------------------
void ShowInfoWindow()
{
    gbl_binfoshow = true;

    if(gbl_infoWindow == NULL)
	{
        CreateInfoWindow();

		if(gbl_infoDrawArea)
			GrabMainPointer(gbl_infoDrawArea);
	}

    if(gbl_infoWindow)
        gtk_widget_show_all(gbl_infoWindow);
}

//----------------------------------------------------------------------------------------
// FUNCTION	: 
// PARAM	: 
// RETURN	: 
// NOTE		: 
//----------------------------------------------------------------------------------------
void DestroyInfoWindow()
{
	UnGrabMainPointer();

    if(gbl_infowindowImg)
    {
        g_object_unref(gbl_infowindowImg);
        gbl_infowindowImg = 0;
    }

    if(gbl_infoCloseImg)
    {
        g_object_unref(gbl_infoCloseImg);
        gbl_infoCloseImg = 0;
    }

    if(gbl_infoDrawArea)
    {
        gtk_widget_destroy(gbl_infoDrawArea);
        gbl_infoDrawArea = NULL;
    }

    if(gbl_infoWindow)
    {
        gtk_widget_destroy(gbl_infoWindow);
        gbl_infoWindow = NULL;
    }
}

//----------------------------------------------------------------------------------------
// FUNCTION	: 
// PARAM	: 
// RETURN	: 
// NOTE		: 
//----------------------------------------------------------------------------------------
bool SetInfoLang(int lang)
{
	gbl_language =  lang;
	return true;
}

//----------------------------------------------------------------------------------------
// FUNCTION	: 
// PARAM	: 
// RETURN	: 
// NOTE		: 
//----------------------------------------------------------------------------------------
bool CheckInfoWinExist()
{
	if(gbl_infoWindow)
		return true;

	return false;
}

//----------------------------------------------------------------------------------------
// FUNCTION	: 
// PARAM	: 
// RETURN	: 
// NOTE		: 
//----------------------------------------------------------------------------------------
bool GrabMainPointer(GtkWidget *window)
{
	bool bresult = false;
	GdkGrabStatus result;
	result = gdk_pointer_grab (window->window, FALSE,
								 (GdkEventMask) PPINFO_MOUSE_EVENTS, 
								 0,  NULL , GDK_CURRENT_TIME);
	switch (result)
	{

		case GDK_GRAB_SUCCESS:
			{
				bresult = true;
				//g_message("GrabMainPointer success!!");
			}
		   break;
		case GDK_GRAB_ALREADY_GRABBED:
		   break;
		case GDK_GRAB_INVALID_TIME:
		   break;
		case GDK_GRAB_NOT_VIEWABLE:
		   break;
		case GDK_GRAB_FROZEN:
		   break;
		default:
		   break;
	}

	return bresult;
}

//----------------------------------------------------------------------------------------
// FUNCTION	: 
// PARAM	: 
// RETURN	: 
// NOTE		: 
//----------------------------------------------------------------------------------------
void UnGrabMainPointer()
{
	GdkDisplay  *display; 
	display = gdk_display_get_default ();
	gdk_display_pointer_ungrab ( display, GDK_CURRENT_TIME);
	//g_message("UnGrabMainPointer !!");
}
