#ifndef __PPCtlBase_00000_H__
#define __PPCtlBase_00000_H__
#pragma once


#define PPOD_CTL_STATE_0	0
#define PPOD_CTL_STATE_1	1	//normal -> down
#define PPOD_CTL_STATE_2	2	//down -> move

#define PPOD_CTLDRAW_NORM		1
#define PPOD_CTLDRAW_DOWN		2
#define PPOD_CTLDRAW_OVER		3
#define PPOD_CTLDRAW_DISABLE		4

#define PPVK_NONE           0x00
#define PPVK_BACK           0x08
#define PPVK_TAB            0x09
#define PPVK_RETURN         0x0D
#define PPVK_SHIFT          0x10
#define PPVK_CONTROL        0x11
#define PPVK_ESCAPE         0x1B
#define PPVK_SPACE          0x20

#define PPVK_ABOUT            0x83
#define PPVK_MINWIN           0x84
#define PPVK_CLOSEWIN         0x85
#define PPVK_WORDTYPE         0x86


#define PPEDINFO_PREEDITBAR   0x0100
#define PPEDINFO_GOLASTCADIDATE 0x0101
#define PPEDINFO_GONEXTCADIDATE 0x0102
#define PPEDINFO_CADIDATE1 0x0103
#define PPEDINFO_CADIDATE2 0x0104
#define PPEDINFO_CADIDATE3 0x0105
#define PPEDINFO_CADIDATE4 0x0106
#define PPEDINFO_CADIDATE5 0x0107
#define PPEDINFO_CADIDATE6 0x0108
#define PPEDINFO_CADIDATE7 0x0109
#define PPEDINFO_CADIDATE8 0x010a

#define PPEDINFO_CADIDATETOTALNUM 8

#define PPCTLMODE_NORMAL	0
#define PPCTLMODE_TOGGLE	1

#define PPCTLMODESTATE_NORMAL		0
#define PPCTLMODESTATE_TOGGLEDOWN	1

#define PPDEFAULT_BOPOMO_ROOTNUMBER	23

#define PPHIWORD(x)	((x >> 16) & 0xFFFF)
#define PPLOWORD(x)	(x & 0xFFFF)
#define PPMAKEDWORD(hx,lx)	(((hx <<=16) & 0xFFFF0000) | (lx & 0xFFFF))


#ifndef PPCmdCallBACK000
#define PPCmdCallBACK000
typedef int (*PPCommand_CALLBACKPROC)(int iCmd,void *infoP,void *userDef);
#endif

#ifndef PPRect_DEFINE000
#define PPRect_DEFINE000
typedef struct ppRect
{
		gint m_left;
		gint m_top;
		gint m_right;
		gint m_bottom;
}ppRect;
#endif

#ifndef PPCtlInfo_DEFINE000
#define PPCtlInfo_DEFINE000
/* typedef struct PPCtlInfo
{
		gint m_CtlID;
		gint m_CtlState;
		gint m_disable;
		gint m_CtlDrawState;
		gint m_CtlLastDrawState;
		ppRect m_mainRect;
		ppRect m_overRect;
		ppRect m_downRect;
		ppRect m_disableRect;
		GdkPixbuf *m_imgP;
		ppRect m_OFSPX_mainRect;
		ppRect m_OFSPX_overRect;
		ppRect m_OFSPX_downRect;
		ppRect m_OFSPX_disableRect;
		PPCommand_CALLBACKPROC m_CmdCallbackP;
		void *m_CmdUserDefP;
}PPCtlInfo;
*/
#define PPCTLINFO_WORDLEN 64
typedef struct PPCtlInfo
{
		//public:
		int m_CtlID[2];
		int m_CtlState;
		int m_disable;
		int m_CtlDrawState;
		int m_CtlLastDrawState;
		int m_CtlMode;
		int m_CtlModeState;
		int m_CtlMultiBlock;
		wchar_t m_keywchar[PPCTLINFO_WORDLEN];
		ppRect m_mainRect;
		ppRect m_overRect;
		ppRect m_downRect;
		ppRect m_disableRect;
		ppRect m_senseRect;
		ppRect m_transpRect;
		GdkPixbuf *m_imgPL;
		GdkPixbuf *m_imgPU;
		GdkPixbuf *m_imgP_disable;
		GdkPixbuf *m_imgPL_down;
		GdkPixbuf *m_imgPU_down;
		GdkPixbuf *m_imgP_over;		
		ppRect m_OFSPX_mainRect;
		ppRect m_OFSPX_overRect;
		ppRect m_OFSPX_downRect;
		ppRect m_OFSPX_disableRect;
		ppRect m_MBlocks[10];
		//PPCommand_CALLBACKPROC m_CmdCallbackP;
		//void *m_CmdUserDefP;
		//char m_transp_imgU_path[128];
		//char m_transp_imgL_path[128];
}PPCtlInfo;

#endif


#endif
