#include "PPCaption.h"

PPCaption::PPCaption()
{
	m_ctl_count = 0;
	m_win = 0;
	m_areaP = 0;
	m_State = PPCAPTION_STATE_000;
	m_CallBackPtr = 0;
	m_lastCPControl = -1;
	m_lastPSControl = -1;
}

PPCaption::~PPCaption()
{

}



gint PPCaption::init_controls(gint iMode)
{
	gint i;
//	PPCtlInfo *tmpCtlP;
	for (i = 0;i < 256;i++)
	{
		memset(&m_controls[i],0,sizeof(PPCtlInfo));
	}
	m_ctl_count = 0;

	if (iMode == 0)
	{
		//void PPCaption::SetOneControlInfo(PPCtlInfo *tmpCtlP,int iID,int iLeft,int iTop, int iRight, int iBottom)
		SetOneControlInfo(&m_controls[m_ctl_count],         PPVK_ABOUT,        2,       2,       2+22,        2+22);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],        PPVK_MINWIN,      726,		2,	   726+19,		  2+20);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_CLOSEWIN,747,2,747+20,2+20);
		m_ctl_count++;
		
	}else
	{
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_ABOUT,2,2,2+28,2+28);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_MINWIN,907,2,907+25,2+26);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_CLOSEWIN,933,2,933+26,2+26);
		m_ctl_count++;
	}
	return 0;

}

gint PPCaption::SetCommandCallBack(PPCommand_CALLBACKPROC callback,void *userDef)
{
	m_CallBackPtr = callback;
	m_cbUserDefP = userDef;
	return 0;
}

gint PPCaption::OnMouseLButtonDown(int x,int y)
{
	PPCtlInfo *oneInfoP;
	gint idx;
//	GdkModifierType state;
	
	
	if (m_State == PPCAPTION_STATE_000)
	{
		idx = FindControlInPTXY(x,y);
		if (idx != -1)
		{
			oneInfoP = &(m_controls[idx]);
			if (oneInfoP != 0)
			{
				if (oneInfoP->m_CtlState == PPCAPTION_STATE_000)
				{
					oneInfoP->m_CtlState = PPCAPTION_STATE_001;
					oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_DOWN;
					m_lastCPControl = idx;
					RePaintScreen(0,1);
				}
			}
			m_State = PPCAPTION_STATE_001;
		}else
		{
			m_lastCPControl = -1;
			m_State = PPCAPTION_STATE_003;
			m_LastMouseX = x;
			m_LastMouseY = y;
			//gdk_window_get_pointer(NULL, &m_LastMouseX, &m_LastMouseY, &state);
			
		}
	}
	return 0;
}

gint PPCaption::OnMouseMove(int x,int y)
{
	gint idx;
	PPCtlInfo *oneInfoP;
	gint nowX,nowY;
	GdkModifierType state;
	

	if ((m_State == PPCAPTION_STATE_001) || (m_State == PPCAPTION_STATE_000))
	{
		idx = FindControlInPTXY(x,y);	//­
		if (idx != -1) // found it!
		{
			oneInfoP = &(m_controls[idx]);
			if (oneInfoP != 0)
			{
				if (m_lastCPControl == -1)	//No last control
				{
					if (m_lastPSControl == -1)	//over this control
					{
						m_lastPSControl = idx;
						oneInfoP->m_CtlState = PPCAPTION_STATE_000;
						oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_OVER;
					}else						//
					{
						if (m_lastPSControl != idx) //check over control same?
						{
							oneInfoP = &(m_controls[m_lastPSControl]);
							if (oneInfoP != 0)
							{
								oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
							}
							m_lastPSControl = idx;
							oneInfoP = &(m_controls[m_lastPSControl]);
							oneInfoP->m_CtlState = PPCAPTION_STATE_000;
							oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_OVER;
						
						}
					}
				}else //last one pressed
				{
					if (m_lastCPControl != idx) //press control not same
					{
						oneInfoP = &(m_controls[m_lastCPControl]);
						if (oneInfoP != 0)
						{
							oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
						}
					}else //press control same
					{
						oneInfoP->m_CtlState = PPCAPTION_STATE_002;
						oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_DOWN;
					}
				}
			}
			RePaintScreen(0,1);
		}else // No control in PT localation
		{
			if (m_lastCPControl != -1)	//restore
			{
				oneInfoP = &(m_controls[m_lastCPControl]);
				if (oneInfoP != 0)
				{
					oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
				}
			}else	// restore it!
			{
				if (m_lastPSControl != -1)
				{
					oneInfoP = &(m_controls[m_lastPSControl]);
					if (oneInfoP != 0)
					{
						oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
					}
				}
				m_lastPSControl = -1;
			}
			RePaintScreen(0,1);
		}
	}else if (m_State == PPCAPTION_STATE_003)
	{
		if ((x == -1) || (y == -1))
		{
		}else
		{
			gdk_window_get_pointer(NULL, &nowX, &nowY, &state);
			gtk_window_move(GTK_WINDOW(m_win),nowX - m_LastMouseX,nowY - m_LastMouseY);
		}
	}
	return 0;
}

gint PPCaption::OnMouseLButtonUp(int x,int y)
{
	gint idx;
	PPCtlInfo *oneInfoP;
	
	if (m_State == PPCAPTION_STATE_003)
	{
		m_State = PPCAPTION_STATE_000;
	}else
	{
		idx = FindControlInPTXY(x,y);
		if (idx != -1)	
		{
			if (m_lastCPControl == -1)	// no object
			{
				if (m_lastPSControl != -1) //restore last object
				{
					oneInfoP = &(m_controls[m_lastPSControl]);
					if (oneInfoP != 0)
					{
						oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
					}
				}
			}else //has object
			{
				if (idx == m_lastCPControl)	//do command
				{
					oneInfoP = &(m_controls[m_lastCPControl]);
					if (oneInfoP != 0)
					{
						oneInfoP->m_CtlState = PPCAPTION_STATE_000;
						oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_OVER;
						m_lastPSControl = idx;
						//process callback function
						ProcessCallBack(oneInfoP->m_CtlID[0],oneInfoP,0);
					}
				}else	//last object not the same
				{
					oneInfoP = &(m_controls[m_lastCPControl]);
					if (oneInfoP != 0)
					{
						oneInfoP->m_CtlState = PPCAPTION_STATE_000;
						oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
					}
					oneInfoP = &(m_controls[idx]);
					if (oneInfoP != 0)
					{
						oneInfoP->m_CtlState = PPCAPTION_STATE_000;
						oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_OVER;
						m_lastPSControl = idx;
					}
				}
				m_lastCPControl = -1;
			}
		}else //no object ,do restore ---------------------------------------------------------
		{
			if (m_lastCPControl != -1)
			{
				oneInfoP = &(m_controls[m_lastCPControl]);
				if (oneInfoP != 0)
				{
					oneInfoP->m_CtlState = PPCAPTION_STATE_000;
					oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
				}
				m_lastCPControl = -1;
			}
		}
		RePaintScreen(0,1);
	}
	m_State = PPCAPTION_STATE_000;
	return 0;
}

gint PPCaption::OnPaint(GtkWidget *widget,GdkEventExpose *event,gpointer user_data)
{
	RePaintScreen(1,0);
	return 1;
}


gint PPCaption::FindControlInPTXY(gdouble x,gdouble y)
{
	gint i; //,tmpW,tmpH;
	PPCtlInfo *oneInfoP;

	for (i = 0;i < m_ctl_count;i++)
	{
		oneInfoP = &(m_controls[i]);
		if (oneInfoP != 0)
		{
			if (oneInfoP->m_disable == 0)
			{
				if (((x >= oneInfoP->m_mainRect.m_left ) && (x <= oneInfoP->m_mainRect.m_right )) &&
					((y >= oneInfoP->m_mainRect.m_top ) && (y <= oneInfoP->m_mainRect.m_bottom )))
				{
					return i;
				}
			}
		}
	}
	return -1;

}


gint PPCaption::SetOrgXYWH(gint x,gint y,gint w,gint h)
{
	m_orgX = x;
	m_orgY = y;
	m_orgH = h;
	m_orgW = w;
	
	return 1;
}

gint PPCaption::SetDrawWinInfo(GtkWidget *winP,GtkWidget *areaP)
{
	m_win = winP;
	m_areaP = areaP;
	return 1;
}

gint PPCaption::SetDrawPixbufNormal(GdkPixbuf *dataPtr)
{
	m_KeybdPixMaps[0] = dataPtr;
	return 1;
}

gint PPCaption::SetDrawPixbufDown(GdkPixbuf *dataPtr)
{
	m_KeybdPixMaps[1] = dataPtr;
	return 1;
}

gint PPCaption::SetDrawPixbufNormal_Big(GdkPixbuf *dataPtr)
{
	m_KeybdPixMaps[2] = dataPtr;
	return 1;
}

gint PPCaption::SetDrawPixbufDown_Big(GdkPixbuf *dataPtr)
{
	m_KeybdPixMaps[3] = dataPtr;
	return 1;
}

gint PPCaption::IsPTInThisObject(gint x,gint y)
{
	if (m_State == PPCAPTION_STATE_003)	//caption draging
	{
		return 1;
	}else
	{
		if (((x  >= m_orgX) && (x <= (m_orgX + m_orgW))) &&
		((y  >= m_orgY) && (y <= (m_orgY + m_orgH))))
		{
			return 1;
		}else
		{
			return 0;
		}
	}
	
}



void PPCaption::RePaintScreen(gint iRpBackground,gint iAutoXor)
{
	//int i;
	//GdkPoint points[5];

	if (m_win != 0)
	{
		//if (gbl_oneGtkImgP != 0)
		{
			if (m_areaP != 0)
			{
				if (iRpBackground == 1)
				{
					gdk_draw_pixbuf(m_areaP->window, m_areaP->style->white_gc, m_KeybdPixMaps[0], m_orgX, m_orgY, m_orgX, m_orgY, m_orgW, m_orgH, GDK_RGB_DITHER_NONE, 0, 0); 
				}
				draw_controls(m_areaP,iAutoXor);
			}
		}
	}

}


gint PPCaption::draw_controls(GtkWidget *widget,gint iAutoXor)
{
	gint i,tmpW,tmpH;
	PPCtlInfo *oneInfoP;
	gint iRepaintFlag;

	for (i = 0;i < m_ctl_count;i++)
	{
		oneInfoP = &(m_controls[i]);
		if (oneInfoP != 0)
		{
			if (oneInfoP->m_CtlDrawState == PPOD_CTLDRAW_NORM)
			{
				iRepaintFlag = 0;
				if (iAutoXor == 1)
				{
					if (oneInfoP->m_CtlLastDrawState != PPOD_CTLDRAW_NORM)
					{
						iRepaintFlag = 1;
					}
				}else
				{
					iRepaintFlag = 1;
				}
				if (iRepaintFlag == 1)
				{
					tmpW = oneInfoP->m_OFSPX_mainRect.m_right - oneInfoP->m_OFSPX_mainRect.m_left;
					tmpH = oneInfoP->m_OFSPX_mainRect.m_bottom - oneInfoP->m_OFSPX_mainRect.m_top;
					gdk_draw_pixbuf(widget->window, widget->style->white_gc, m_KeybdPixMaps[0], oneInfoP->m_OFSPX_mainRect.m_left, oneInfoP->m_OFSPX_mainRect.m_top, oneInfoP->m_mainRect.m_left, oneInfoP->m_mainRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
					 //= gdk_display_get_default_screen();
					oneInfoP->m_CtlLastDrawState = PPOD_CTLDRAW_NORM;
				}
			}else if (oneInfoP->m_CtlDrawState == PPOD_CTLDRAW_DOWN)
			{
				iRepaintFlag = 0;
				if (iAutoXor == 1)
				{
					if (oneInfoP->m_CtlLastDrawState != PPOD_CTLDRAW_DOWN)
					{
						iRepaintFlag = 1;
					}
				}else
				{
					iRepaintFlag = 1;
				}
				if (iRepaintFlag == 1)
				{
					tmpW = oneInfoP->m_OFSPX_downRect.m_right - oneInfoP->m_OFSPX_downRect.m_left;
					tmpH = oneInfoP->m_OFSPX_downRect.m_bottom - oneInfoP->m_OFSPX_downRect.m_top;
					gdk_draw_pixbuf(widget->window, widget->style->white_gc, m_KeybdPixMaps[1], oneInfoP->m_OFSPX_downRect.m_left, oneInfoP->m_OFSPX_downRect.m_top, oneInfoP->m_downRect.m_left, oneInfoP->m_downRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
					oneInfoP->m_CtlLastDrawState = PPOD_CTLDRAW_DOWN;
				}
			}else if (oneInfoP->m_CtlDrawState == PPOD_CTLDRAW_OVER)
			{
				iRepaintFlag = 0;
				if (iAutoXor == 1)
				{
					if (oneInfoP->m_CtlLastDrawState != PPOD_CTLDRAW_OVER)
					{
						iRepaintFlag = 1;
					}
				}else
				{
					iRepaintFlag = 1;
				}
				if (iRepaintFlag == 1)
				{
					tmpW = oneInfoP->m_OFSPX_overRect.m_right - oneInfoP->m_OFSPX_overRect.m_left;
					tmpH = oneInfoP->m_OFSPX_overRect.m_bottom - oneInfoP->m_OFSPX_overRect.m_top;
					gdk_draw_pixbuf(widget->window, widget->style->white_gc, m_KeybdPixMaps[0], oneInfoP->m_OFSPX_overRect.m_left, oneInfoP->m_OFSPX_overRect.m_top, oneInfoP->m_overRect.m_left, oneInfoP->m_overRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
					oneInfoP->m_CtlLastDrawState = PPOD_CTLDRAW_OVER;
				}
			}else if (oneInfoP->m_CtlDrawState == PPOD_CTLDRAW_DISABLE)
			{
				iRepaintFlag = 0;
				if (iAutoXor == 1)
				{
					if (oneInfoP->m_CtlLastDrawState != PPOD_CTLDRAW_DISABLE)
					{
						iRepaintFlag = 1;
					}
				}else
				{
					iRepaintFlag = 1;
				}
				if (iRepaintFlag == 1)
				{
					tmpW = oneInfoP->m_OFSPX_disableRect.m_right - oneInfoP->m_OFSPX_disableRect.m_left;
					tmpH = oneInfoP->m_OFSPX_disableRect.m_bottom - oneInfoP->m_OFSPX_disableRect.m_top;
					gdk_draw_pixbuf(widget->window, widget->style->white_gc, m_KeybdPixMaps[0], oneInfoP->m_OFSPX_disableRect.m_left, oneInfoP->m_OFSPX_disableRect.m_top, oneInfoP->m_disableRect.m_left, oneInfoP->m_disableRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
					oneInfoP->m_CtlLastDrawState = PPOD_CTLDRAW_DISABLE;
				}
			}
		}
	}
	return 0;
}


void PPCaption::SetOneControlInfo(PPCtlInfo *tmpCtlP,int iID,int iLeft,int iTop, int iRight, int iBottom)
{
	if (tmpCtlP != 0)
	{
		tmpCtlP->m_CtlID[0] = iID;
		tmpCtlP->m_mainRect.m_left = iLeft;
		tmpCtlP->m_mainRect.m_top = iTop;
		tmpCtlP->m_mainRect.m_right = iRight;
		tmpCtlP->m_mainRect.m_bottom = iBottom;
		memcpy(&(tmpCtlP->m_overRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
		memcpy(&(tmpCtlP->m_downRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
		memcpy(&(tmpCtlP->m_disableRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
		memcpy(&(tmpCtlP->m_senseRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
		memcpy(&(tmpCtlP->m_transpRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
		memcpy(&(tmpCtlP->m_OFSPX_mainRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
		memcpy(&(tmpCtlP->m_OFSPX_overRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
		memcpy(&(tmpCtlP->m_OFSPX_downRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
		memcpy(&(tmpCtlP->m_OFSPX_disableRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));	
	}
}

void PPCaption::ProcessCallBack(int iID,void *infoP,void *userDataP)
{
	//PPCtlInfo *oneInfoP = (PPCtlInfo *)infoP;
	if (m_CallBackPtr != 0)
	{
		m_CallBackPtr(iID,infoP,userDataP);
	}
	
	
}
