#include "CandidateIndexList.h"


CCandidateIndexList::CCandidateIndexList()
{
	m_CandidateIndexID_Counter = 0;
}

CCandidateIndexList::~CCandidateIndexList()
{
	CCandidateIndexList::Clear();
}

void CCandidateIndexList::ClearData(ListNode* pNode)
{
	if(pNode->Data != NULL)
	{
		CCandidateIndex* pData = (CCandidateIndex*)pNode->Data;
		pData->Dispose();

		// delete pNode->Data; 
		// ==> Releasing memory by void* pointer will cause Memory leak.

		delete pData;
		pNode->Data = NULL;
	}
}

bool CCandidateIndexList::AreDataEqual(void* pDataA, void* pDataB, LLEqualOption nOption)
{
	if(pDataA != NULL && pDataB != NULL)
	{
		CCandidateIndex* pCIA = (CCandidateIndex*)pDataA;
		CCandidateIndex* pCIB = (CCandidateIndex*)pDataB;
		switch(nOption)
		{
		case BY_STRING:
			return pCIA->Root.Equals(&(pCIB->Root), false);

		case BY_STRING_IGNORECASE:
			return pCIA->Root.Equals(&(pCIB->Root), true);

		case BY_ID:
		{
			if(pCIA->GetID() == pCIB->GetID())
				return true;
			else
				return false;
		}

		default:
			return false;
		}
	}
	else
	{
		return false;
	}
}

//	Node*				pNode = NULL;
//	CCandidateIndex*	pData = NULL;
//
//	while((pData = DumpData(&pNode)) != NULL)
//	{
//		...
//	}
CCandidateIndex* CCandidateIndexList::DumpData(ListNode** pNode)
{
	return (CCandidateIndex*)CLinkedList::GetData(pNode);
}

CCandidateIndex* CCandidateIndexList::FindCandidateIndex(CCandidateIndex* pSearchPattern, LLEqualOption nOption)
{
	size_t index;

	ListNode* pNode = FindNodeByData(pSearchPattern, &index, nOption);

	if(pNode != NULL)
	{
		CCandidateIndex* pCI = (CCandidateIndex*)pNode->Data;
		return pCI;
	}

	return NULL;
}

// a > b return 1
// a == b return 0
// a < b return -1
int CCandidateIndexList::Comparer(void* pDataA, void* pDataB, LLCompareOption nOption)
{
	if(pDataA == NULL || pDataB == NULL) return 0;

	CCandidateIndex* pCIA = (CCandidateIndex*)pDataA;
	CCandidateIndex* pCIB = (CCandidateIndex*)pDataB;

	int result = 0;
	bool bIgnoreCase = false;

	if(	nOption == DES_BY_STRING_IGNORECASE ||
		nOption == ASC_BY_STRING_IGNORECASE )
	{
		bIgnoreCase = true;
	}


	switch(nOption)
	{
	 // Descending by roots.
	case DES_BY_STRING:
	case DES_BY_STRING_IGNORECASE:
		{
			result = pCIA->Root.CompareTo(&(pCIB->Root), bIgnoreCase);
			return result;
		}

	// Ascending by roots.
	case ASC_BY_STRING:
	case ASC_BY_STRING_IGNORECASE:
		{
			result = pCIA->Root.CompareTo(&(pCIB->Root), bIgnoreCase);
			if(result > 0) return -1;
			else if(result < 0) return 1;
			else return 0;
		}

	case DES_BY_ID: //Descending by priority. Ex: 6, 6, 5, 2, 1, 0, ...
		{
			if(pCIA->GetID() > pCIB->GetID())
				return 1;
			else if(pCIA->GetID() < pCIB->GetID())
				return -1;
			else
				return 0;
		}

	case ASC_BY_ID: //Ascending by priority. Ex: 0, 0, ...., 1, 2, 5, 6, 6
		{
			if(pCIB->GetID() > pCIA->GetID())
				return 1;
			else if(pCIB->GetID() < pCIA->GetID())
				return -1;
			else
				return 0;
		}

	default:
		return 0;
	}
}


// When adding a new candidate index, it will also create an unique ID.

bool CCandidateIndexList::Add(CCandidateIndex* pData)
{
	if(pData == NULL) return false;

	if(pData->GetID() == 0)
	{
		// Adding a ID for CCandidateIndex automatically.
		if(m_CandidateIndexID_Counter == 0) 
		{
			m_CandidateIndexID_Counter = 1;
		}
		pData->SetID(m_CandidateIndexID_Counter);
		m_CandidateIndexID_Counter++;
	}

	return CLinkedList::Add(pData);
}


bool CCandidateIndexList::Clear()
{
	if(CLinkedList::Clear())
	{
		m_CandidateIndexID_Counter = 0;
		return true;
	}
	else
	{
		return false;
	}
}
