/*
 * PROPRIETARY INFORMATION.  This software is proprietary to POWDER
 * Development, and is not to be reproduced, transmitted, or disclosed
 * in any way without written permission.
 *
 * Produced by:	Jeff Lait
 *
 *      	7DRL Development
 *
 * NAME:        mapdata.cpp ( Save Sucmmer Library, C++ )
 *
 * COMMENTS:
 */

#include "mapdata.h"

#include <memory.h>

class MAPDATA_REF
{
public:
    void	 incRef();
    void	 decRef();
    
    // Ensure I am the only pointer to the data.
    MAPDATA_REF	*uniquify();

    u8		*data() { return myData; }

    // Returns a ref that already has been inced!
    static MAPDATA_REF *create(int nbytes);

private:
		 MAPDATA_REF();
    virtual	~MAPDATA_REF();

    int		 myRef;
    int		 mySize;
    u8		*myData;
};

MAPDATA_REF::MAPDATA_REF()
{
    myData = 0;
    mySize = 0;
    myRef = 0;
}

MAPDATA_REF::~MAPDATA_REF()
{
    delete [] myData;
}

void
MAPDATA_REF::incRef()
{
    myRef++;
}

void
MAPDATA_REF::decRef()
{
    myRef--;
    if (myRef <= 0)
	delete this;
}

MAPDATA_REF *
MAPDATA_REF::uniquify()
{
    // Empty refs are easy to unique :>
    if (!myData)
	return this;

    // if only one ref, it is trivial
    if (myRef <= 1)
	return this;

    // Need to copy for upcoming write!
    MAPDATA_REF	*result;

    result = create(mySize);
    memcpy(result->data(), data(), mySize);

    // Remove a ref from ourself.
    decRef();

    return result;
}

MAPDATA_REF *
MAPDATA_REF::create(int nbytes)
{
    MAPDATA_REF		*result;

    result = new MAPDATA_REF;
    result->incRef();
    result->myData = new u8[nbytes];
    result->mySize = nbytes;

    return result;
}

//
// Mapdata functions
//

MAPDATA::MAPDATA()
{
    myRef = 0;
}

MAPDATA::MAPDATA(int nbytes)
{
    myRef = MAPDATA_REF::create(nbytes);
}

MAPDATA::MAPDATA(const MAPDATA &data)
{
    myRef = 0;

    *this = data;
}

MAPDATA::~MAPDATA()
{
    if (myRef)
	myRef->decRef();
}


MAPDATA &
MAPDATA::operator=(const MAPDATA &data)
{
    // Trivial assignment.
    if (this == &data)
	return *this;

    if (data.myRef)
	data.myRef->incRef();
    
    if (myRef)
	myRef->decRef();

    myRef = data.myRef;

    return *this;
}

u8
MAPDATA::operator()(int i) const
{
    return myRef->data()[i];
}

u8 &
MAPDATA::operator()(int i)
{
    myRef = myRef->uniquify();
    return myRef->data()[i];
}

const u8 *
MAPDATA::readData() const
{
    return myRef->data();
}

u8 *
MAPDATA::writeData()
{
    myRef = myRef->uniquify();
    return myRef->data();
}
