#!/bin/sh

#Temporary permission fix
chown user:users /home/user/.config/savepress

if [ -f /etc/systemui/savepress.xml ]; then {
	echo "running savepress.."
	}
else {
	echo '<powerkeymenu path="/">
 <title>powerup_application_title</title>
 <po>osso-powerup-shutdown</po>

 <menuitem priority="200" name="Savepress is active" visible="on">
  <keyfile>/tmp/savepress</keyfile>
 </menuitem>

</powerkeymenu>' > /etc/systemui/savepress.xml
	killall systemui
	echo "wrote systemui-button.."
	echo "running savepress.."
	}
fi

echo "checking button.."

sleep "`cat /home/user/.config/savepress | grep "vdelay" | sed 's/vdelay: //g' | sed 's/ //g'`"

if [ `hal-get-property --udi /org/freedesktop/Hal/devices/platform_kb_lock --key button.state.value` == true ]; then {
	echo "button pressed.."
	if [ -f /tmp/savepress ]; then {
		echo "disabling.."
		/usr/sbin/kernel-config limits `cat /tmp/savepress-value | grep "min" | sed 's/min: //g'` `cat /tmp/savepress-value | grep "max" | sed 's/max: //g'`
		dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:"unlocked"
		rm /tmp/savepress
	
		# restore settings
		if [ "`cat /tmp/savepress-value | grep "offline"`" != "" ]; then {
			dbus-send --system --dest=com.nokia.mce --type=method_call /com/nokia/mce/request com.nokia.mce.request.req_device_mode_change string:"normal"
			}
		fi
		if [ "`cat /tmp/savepress-value | grep "wlan-dis"`" != "" ]; then {
			dbus-send --system --type=method_call --dest=com.nokia.icd /com/nokia/icd com.nokia.icd.connect string:"[ANY]" uint32:0
			}
		fi
		if [ "`cat /tmp/savepress-value | grep "mode" | sed 's/mode: //g'`" != "" ]; then {
			dbus-send --system --type=method_call --dest=com.nokia.phone.net /com/nokia/phone/net Phone.Net.set_selected_radio_access_technology byte:"`cat /tmp/savepress-value | grep "mode" | sed 's/mode: //g'`"
			}
		fi
		run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"savepress is disabled!"
		rm /tmp/savepress-value
		}
	else {
		echo "activating.."
		dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:"unlocked"
		echo "on" > /tmp/savepress
	
		# activate settings
		echo "`/usr/sbin/kernel-config show | grep "max" | sed 's/. frequency//g'`" > /tmp/savepress-value
		echo "`/usr/sbin/kernel-config show | grep "min" | sed 's/. frequency//g'`" >> /tmp/savepress-value
		if [ "`cat /home/user/.config/savepress | grep "vwlan" | sed 's/vwlan: //g' | sed 's/ //g'`" == "True" ]; then {
			dbus-send --system --dest=com.nokia.icd /com/nokia/icd_ui com.nokia.icd_ui.disconnect boolean:true
			echo "wlan-dis" >> /tmp/savepress-value
			}
		fi
		
		if [ "`cat /home/user/.config/savepress | grep "vblue" | sed 's/vblue: //g' | sed 's/ //g'`" == "True" ]; then {
			dbus-send --system --type=method_call --dest=org.bluez $(dbus-send --system --print-reply --dest=org.bluez / org.bluez.Manager.ListAdapters | awk -F "\"" '/at/ {print $2}') org.bluez.Adapter.SetProperty string:Powered variant:boolean:false
			}
		fi

		if [ "`cat /home/user/.config/savepress | grep "voffline" | sed 's/voffline: //g' | sed 's/ //g'`" == "True" ]; then {
			if [ "`dbus-send --print-reply --system --dest=com.nokia.mce --type=method_call /com/nokia/mce/request com.nokia.mce.request.get_device_mode | grep -o normal`" == "normal" ]; then {
				dbus-send --system --dest=com.nokia.mce --type=method_call /com/nokia/mce/request com.nokia.mce.request.req_device_mode_change string:"offline"
				echo "offline" >> /tmp/savepress-value
				}
			fi
			}
		else {
			if [ "`cat /home/user/.config/savepress | grep "v2g" | sed 's/v2g: //g' | sed 's/ //g'`" == "True" ]; then {
				netmode="`dbus-send --system --type=method_call --print-reply --dest=com.nokia.phone.net /com/nokia/phone/net Phone.Net.get_selected_radio_access_technology | awk '/b/ {print $2}'`"
				if [ "$netmode" != "1" ]; then {
					echo "mode: $netmode" >> /tmp/savepress-value
					dbus-send --system --type=method_call --dest=com.nokia.phone.net /com/nokia/phone/net Phone.Net.set_selected_radio_access_technology byte:1
					}
				fi
				}
			fi
			}
		fi
		run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"savepress is activated!"
		sleep 1
		dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:"locked"
		/usr/sbin/kernel-config limits `cat /home/user/.config/savepress | grep "vmin" | sed 's/vmin: //g' | sed 's/ //g'` `cat /home/user/.config/savepress | grep "vmax" | sed 's/vmax: //g' | sed 's/ //g'`
		}
	fi
	echo "done.."
	}
else {
	echo "not pressed.."
	}
fi
