#!/usr/bin/python2.5
import sys
import dbus
import re
from PyQt4 import QtGui,QtCore
from savepress_editor_ui import *

class MyForm(QtGui.QMainWindow):
	def __init__(self, parent=None):
		#build parent user interface
		QtGui.QWidget.__init__(self, parent)
		self.ui = Ui_MainWindow()
		self.ui.setupUi(self)

		#connect button
		QtCore.QObject.connect(self.ui.pushButton, QtCore.SIGNAL('clicked()'), self.doSave)
		QtCore.QObject.connect(self.ui.Button, QtCore.SIGNAL('clicked()'), self.doRestore)

		QtCore.QObject.connect(self.ui.vlock, QtCore.SIGNAL('stateChanged(int)'), self.doLock)


		#load settings
		f = open("/home/user/.config/savepress")
		for line in f:
			if "vlock:" in line:
				result = re.search('(?<=: )\w+', line)
				if "True" in result.group(0):
					self.ui.vlock.setChecked(True)

			if "vmhz:" in line:
				result = re.search('(?<=: )\w+', line)
				digit = result.group(0)
				self.ui.vlockf.setText(str(digit))

			if "vvolt:" in line:
				result = re.search('(?<=: )\w+', line)
				digit = result.group(0)
				self.ui.vlockv.setText(str(digit))

			if "vdsp:" in line:
				result = re.search('(?<=: )\w+', line)
				digit = result.group(0)
				self.ui.vlockd.setText(str(digit))

			if "vmax:" in line:
				result = re.search('(?<=: )\w+', line)
				digit = result.group(0)
				self.ui.vmax.setText(str(digit))

			if "vmin:" in line:
				result = re.search('(?<=: )\w+', line)
				digit = result.group(0)
				self.ui.vmin.setText(str(digit))

			if "vdelay:" in line:
				result = re.search('(?<=: )\w+', line)
				self.ui.vdelay.setValue(int(result.group(0)))

			if "vwlan:" in line:
				result = re.search('(?<=: )\w+', line)
				if "True" in result.group(0):
					self.ui.vwlan.setChecked(True)

			if "voffline:" in line:
				result = re.search('(?<=: )\w+', line)
				if "True" in result.group(0):
					self.ui.voffline.setChecked(True)

			if "v2g:" in line:
				result = re.search('(?<=: )\w+', line)
				if "True" in result.group(0):
					self.ui.vgsm.setChecked(True)

			if "vblue:" in line:
				result = re.search('(?<=: )\w+', line)
				if "True" in result.group(0):
					self.ui.vblue.setChecked(True)

	def doLock(self):
		lock = (self.ui.vlock.isChecked())
		if str(lock) == "True":
			self.ui.vmin.setGeometry(0, 0, 0, 0)
			self.ui.vmax.setGeometry(0, 0, 0, 0)
			self.ui.vlockf.setGeometry(460, 65, 120, 60)
			self.ui.vlockv.setGeometry(460, 135, 120, 60)
			self.ui.vlockd.setGeometry(660, 135, 120, 60)
			self.ui.label_5.setText("MHz:")
			self.ui.label_4.setText("Volt:")
			self.ui.labeldsp.setText("Dsp:")
			self.ui.label_3.setText("Lock frequency:")

		else:
			self.ui.vmin.setGeometry(460, 65, 120, 60)
			self.ui.vmax.setGeometry(460, 135, 120, 60)
			self.ui.vlockf.setGeometry(0, 0, 0, 0)
			self.ui.vlockv.setGeometry(0, 0, 0, 0)
			self.ui.vlockd.setGeometry(0, 0, 0, 0)
			self.ui.label_5.setText("Min:")
			self.ui.label_4.setText("Max:")
			self.ui.labeldsp.setText("")
			self.ui.label_3.setText("Frequencies:")



	def doRestore(self):
		self.ui.vlock.setChecked(False)
		self.ui.vlockf.setText(str("250"))
		self.ui.vlockv.setText(str("25"))
		self.ui.vlockd.setText(str("180"))
		self.ui.vmax.setText(str("250"))
		self.ui.vmin.setText(str("250"))
		self.ui.vdelay.setValue(int(2))
		self.ui.vwlan.setChecked(True)
		self.ui.vblue.setChecked(True)
		self.ui.voffline.setChecked(False)
		self.ui.vgsm.setChecked(True)
		self.ui.label_3.setText("Frequencies:")

		bus = dbus.SystemBus()
		iface = dbus.Interface(bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications'), 'org.freedesktop.Notifications')
		iface.SystemNoteInfoprint("orginal settings restored")


	def doSave(self):
		f = open('/home/user/.config/savepress', 'w')
		vlock = (self.ui.vlock.isChecked())
		vlockf = (self.ui.vlockf.text())
		vlockv = (self.ui.vlockv.text())
		vlockd = (self.ui.vlockd.text())
		vmax = (self.ui.vmax.text())
		vmin = (self.ui.vmin.text())
		vdelay = (self.ui.vdelay.text())
		vblue = (self.ui.vblue.isChecked())
		vwlan = (self.ui.vwlan.isChecked())
		voffline = (self.ui.voffline.isChecked())
		vtwog = (self.ui.vgsm.isChecked())
		print >>f, '''# This is the config-file for savepress. Please dont
# change anything except you know what your doing.


# This will let you lock a frequency, otherwise the
# limits will be used
# Standard: False
vlock:''', vlock, '''

# The frequency to lock (MHz)
# Standard: 250
vmhz:''', vlockf, '''

# The voltage to lock
# Standard: 25
vvolt:''', vlockv, '''

# The dsp to lock
# Standard: 180
vdsp:''', vlockd, '''

# This is the max frequency when using limits, when
# vlock is False
# Standard: 250
vmax:''', vmax, ''' 

# This is the min frequency when using limits, when
# vlock is False
# Standard: 250
vmin:''', vmin, '''

# This value is used to make a small delay
# which would make you hold down the "button" for X
# seconds to activate the script
# Should be a number, 0 is the same as no delay
# Standard: 2
vdelay:''', vdelay, ''' 

# This value will enable/disable wifi-disconnection
# Should be True or False
# Standard: True
vwlan:''', vwlan, ''' 

# This value will disable/enable cellular radio
# Should be True or False
# Standard: False
voffline:''', voffline, ''' 

# This value will enable/disable 2g-only-mode
# Will be refused if above value is true
# Should be True or False
# Standard: True
v2g:''', vtwog, '''

# This value will disable bluetooth
# Should be True or False
# Standard: True
vblue:''', vblue, ''' 

# If you have any other whishes/ideas of how to save
# battery, please email me at: wellef@meegosweden.com'''


		bus = dbus.SystemBus()
		iface = dbus.Interface(bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications'), 'org.freedesktop.Notifications')
		iface.SystemNoteInfoprint("savepress settings saved")


if __name__ == "__main__":
	app = QtGui.QApplication(sys.argv)
	myapp = MyForm()
	myapp.show()
	sys.exit(app.exec_())