#!/usr/bin/python2.5
import sys
import dbus
import re
from PyQt4 import QtGui,QtCore
from savepress_editor_ui import *

class MyForm(QtGui.QMainWindow):
	def __init__(self, parent=None):
		#build parent user interface
		QtGui.QWidget.__init__(self, parent)
		self.ui = Ui_MainWindow()
		self.ui.setupUi(self)

		#connect button
		QtCore.QObject.connect(self.ui.pushButton, QtCore.SIGNAL('clicked()'), self.doSave)
		QtCore.QObject.connect(self.ui.Button, QtCore.SIGNAL('clicked()'), self.doRestore)

		#load settings
		f = open("/home/user/MyDocs/.savepress")
		for line in f:
			if "vmax:" in line:
				result = re.search('(?<=: )\w+', line)
				digit = result.group(0)
				self.ui.vmax.setText(str(digit))

			if "vmin:" in line:
				result = re.search('(?<=: )\w+', line)
				digit = result.group(0)
				self.ui.vmin.setText(str(digit))

			if "vdelay:" in line:
				result = re.search('(?<=: )\w+', line)
				self.ui.vdelay.setValue(int(result.group(0)))

			if "vwlan:" in line:
				result = re.search('(?<=: )\w+', line)
				if "True" in result.group(0):
					self.ui.vwlan.setChecked(True)

			if "voffline:" in line:
				result = re.search('(?<=: )\w+', line)
				if "True" in result.group(0):
					self.ui.voffline.setChecked(True)

			if "v2g:" in line:
				result = re.search('(?<=: )\w+', line)
				if "True" in result.group(0):
					self.ui.vgsm.setChecked(True)

			if "vblue:" in line:
				result = re.search('(?<=: )\w+', line)
				if "True" in result.group(0):
					self.ui.vblue.setChecked(True)


	def doRestore(self):
		self.ui.vmax.setText(str("250"))
		self.ui.vmin.setText(str("250"))
		self.ui.vdelay.setValue(int(2))
		self.ui.vwlan.setChecked(True)
		self.ui.vblue.setChecked(True)
		self.ui.voffline.setChecked(False)
		self.ui.vgsm.setChecked(True)

		bus = dbus.SystemBus()
		iface = dbus.Interface(bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications'), 'org.freedesktop.Notifications')
		iface.SystemNoteInfoprint("orginal settings restore")


	def doSave(self):
		f = open('/home/user/MyDocs/.savepress', 'w')
		vmax = (self.ui.vmax.text())
		vmin = (self.ui.vmin.text())
		vdelay = (self.ui.vdelay.text())
		vblue = (self.ui.vblue.isChecked())
		vwlan = (self.ui.vwlan.isChecked())
		voffline = (self.ui.voffline.isChecked())
		vtwog = (self.ui.vgsm.isChecked())
		print >>f, '''# This is the config-file for savepress. Please dont
# change anything except you know what your doing.


# This is the max frequency which will be used
# Standard: 250
vmax:''', vmax,'''

# This is the min frequency which will be used
# Standard: 250
vmin:''', vmin, '''

# This value is used to make a small delay
# which would make you hold down the "button" for X
# seconds to activate the script
# Should be a number, 0 is the same as no delay
# Standard: 2
vdelay:''', vdelay, '''

# This value will enable/disable wifi-disconnection
# Should be True or False
# Standard: True
vwlan:''', vwlan, '''

# This value will disable/enable cellular radio
# Should be True or False
# Standard: False
voffline:''', voffline, '''

# This value will enable/disable 2g-only-mode
# Will be refused if above value is true
# Should be True or False
# Standard: True
v2g:''', vtwog, '''

# This value will disable bluetooth
# Should be True or False
# Standard: True
vblue:''', vblue, '''

# If you have any other whishes/ideas of how to save
# battery, please email me at: wellef@meegosweden.com'''

		bus = dbus.SystemBus()
		iface = dbus.Interface(bus.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications'), 'org.freedesktop.Notifications')
		iface.SystemNoteInfoprint("savepress settings saved")


if __name__ == "__main__":
	app = QtGui.QApplication(sys.argv)
	myapp = MyForm()
	myapp.show()
	sys.exit(app.exec_())