#!/bin/sh
# savecpu
# versione 1.8 by m750 at maemomeego.net
# lettura conf da file

if [ `id -u` != 0 ] ; then
    exec root <<EOF
    exec /opt/savecpu/savecpu.sh start &
EOF
    exit $?
fi


rosso=/sys/class/leds/lp5523:r
verde=/sys/class/leds/lp5523:g
blu=/sys/class/leds/lp5523:b

sleep 1

#led=/sys/class/leds/lp5523:

start=$(cat /opt/savecpu/savecpu.conf | grep 'startup' | tr '\n' ' ' | awk '{print $2}')


#coloreled=$(cat /opt/savecpu/savecpu.conf | grep 'color' | tr '\n' ' ' | awk '{print $2}')
led_r=$(cat /opt/savecpu/savecpu.conf | grep 'led_r' | tr '\n' ' ' | awk '{print $2}')
led_g=$(cat /opt/savecpu/savecpu.conf | grep 'led_g' | tr '\n' ' ' | awk '{print $2}')
led_b=$(cat /opt/savecpu/savecpu.conf | grep 'led_b' | tr '\n' ' ' | awk '{print $2}')

temperatura_max=$(cat /opt/savecpu/savecpu.conf | grep 'temp' | tr '\n' ' ' | awk '{print $2}')
intervallo=$(cat /opt/savecpu/savecpu.conf | grep 'delay' | tr '\n' ' ' | awk '{print $2}')

temperatura_ok=`expr $temperatura_max - 5`

#echo $coloreled
#echo $temperatura_max
#echo $temperatura_ok
#echo $intervallo


minima=$(/usr/sbin/kernel-config show | grep 'min.' | tr '\n' ' ' | awk '{print $3}') 
massima=$(/usr/sbin/kernel-config show | grep 'max.' | tr '\n' ' ' | awk '{print $3}') 


riduci=0
accendi_led=0
#temperatura_max=25
#temperatura_ok=20

# imposta il valore, espresso in secondi, tra una verifica e l'altra
#intervallo=10

# imposta intensit LED, sconsiglio di superare il valore 20
ledi=18

#imposta colore LED: $verde o $rosso o $blu
ledc=$led$coloreled

if [ $start == 1 ] 
then
   dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"savecpu: is running"
fi

while [ $start == 1 ]
do
  #echo "riduci : " $riduci
  #echo "led : " $accendi_led
  #echo $minima
  #echo $massima
  temperatura=`cat /sys/class/power_supply/bq27200-0/temp`
  #echo "temp: " $temperatura


  # supera limite
  if [ $temperatura_max -le $temperatura ] 
  then
     echo "soglia superata"
     if [ $riduci == 0 ]
     then
       riduci=1
       accendi_led=1
       #echo "accendi_led:" $accendi_led

       minima=$(/usr/sbin/kernel-config show | grep 'min.' | tr '\n' ' ' | awk '{print $3}') 
       massima=$(/usr/sbin/kernel-config show | grep 'max.' | tr '\n' ' ' | awk '{print $3}') 
       if [ 650 -le $massima ]
       then
         /usr/sbin/kernel-config limits 250 600
         dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog string:"savecpu: temp. >= "$temperatura_max" degrees centigrade - downgrade overclock" uint32:0 string:"OK"
         echo "RIDUCO"
       fi
       if [ $massima -le 600 ]
       then 
         dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog string:"savecpu: temp. >= "$temperatura_max" degrees centigrade, but no overclock detected" uint32:0 string:"OK"
         riduci=0
       fi
     fi
  fi

  if [ $accendi_led == 1 ] 
   then
   #echo "accendi_led: " $accendi_led
	if [ $led_r == 1 ]
		then
		   echo `expr $ledi + 2` > $rosso/led_current ; echo $ledi > $rosso/brightness
	fi
	if [ $led_g == 1 ]
		then
		   echo `expr $ledi + 2` > $verde/led_current ; echo $ledi > $verde/brightness
	fi
	if [ $led_b == 1 ]
		then
		   echo `expr $ledi + 2` > $blu/led_current ; echo $ledi > $blu/brightness
	fi

   fi



# torna ok

  if [ $temperatura -le $temperatura_ok ] 
  then
      if [ $riduci == 1 ]
      then
          echo "RIPRISTINO"
          /usr/sbin/kernel-config limits $minima $massima
          #echo "riduci : " $riduci
          riduci=0
          #echo "SPENGO LED"
          accendi_led=0
          #echo 2 > $ledc/led_current ; echo 0 > $ledc/brightness
          if [ $led_r == 1 ]
		then
		   echo 2 > $rosso/led_current ; echo 0 > $rosso/brightness
          fi
          if [ $led_g == 1 ]
		then
		   echo 2 > $verde/led_current ; echo 0  > $verde/brightness
          fi
          if [ $led_b == 1 ]
		then
		   echo 2 > $blu/led_current ; echo 0 > $blu/brightness
          fi


          dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"savecpu: temp. OK"
    
      fi
  fi

  if [ $riduci == 1 ]
  then
  	sleep 120
  fi

  if [ $riduci == 0 ]
  then
  	sleep $intervallo
  fi


  #date
done


exit 0


