/*
 * Sandora, a Falling Sand Game for the Pandora
 * Copyright (C) 2011  WaveHack <email@wavehack.net>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef COMMON_H
#define COMMON_H

#include <SDL/SDL.h>

#ifdef _PANDORA
#define SCREEN_WIDTH        800
#define SCREEN_HEIGHT       480
#define SDL_INIT_FLAGS      SDL_INIT_VIDEO|SDL_INIT_JOYSTICK
#define SDL_VIDEOMODE_FLAGS SDL_SWSURFACE|SDL_FULLSCREEN
#else
#define SCREEN_WIDTH        800
#define SCREEN_HEIGHT       600
#define SDL_INIT_FLAGS      SDL_INIT_VIDEO
#define SDL_VIDEOMODE_FLAGS SDL_HWSURFACE

#endif // _PANDORA

typedef enum {
	false = 0,
	true
} bool;

extern SDL_Surface *screen;

#endif // COMMON_H
