/*
 * Sandora, a Falling Sand Game for the Pandora
 * Copyright (C) 2011  WaveHack <email@wavehack.net>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef PARTICLE_H
#define PARTICLE_H

#ifdef _PANDORA
#define PARTICLE_ZOOM 2
#else
#define PARTICLE_ZOOM 2
#endif // _PANDORA

// If adding new particle types, be sure to fix the bounds in particle.c!!
typedef enum {
	PT_NONE = 0,

	// Stillborn
	PT_WALL,
	PT_IRONWALL,
	PT_TORCH,
	PT_STOVE,
	PT_ICE,
	PT_RUST,
	PT_EMBER,
	PT_PLANT,
	PT_VOID,

	// Spouts (stillborn)
	PT_WATERSPOUT,
	PT_SANDSPOUT,
	PT_SALTSPOUT,
	PT_OILSPOUT,

	// All particles below are movable (non-stillborne) and have two types (
	// regular and moved). Make sure all 'regular' types are even and all
	// 'moved' types are odd. Messy, but this is how SDL Sand works and I'm too
	// lazy to fix it for this release. Comment out or uncomment PT_UNUSED
	// depending if the last type above it is respectively odd or even.
	//PT_UNUSED,

	// Floating
	PT_STEAM,     PT_MOVEDSTEAM,
	PT_FIRE,      PT_MOVEDFIRE,

	// Fluids
	PT_WATER,     PT_MOVEDWATER,
	PT_DIRT,      PT_MOVEDDIRT,
	PT_SALT,      PT_MOVEDSALT,
	PT_OIL,       PT_MOVEDOIL,
	PT_SAND,      PT_MOVEDSAND,

	// Combined
	PT_SALTWATER, PT_MOVEDSALTWATER,
	PT_MUD,       PT_MOVEDMUD,
	PT_ACID,      PT_MOVEDACID,

	// Special
	PT_ELECTRIC,  PT_MOVEDELECTRIC,

	MAX_PARTICLE_TYPES
} particleType_t;

extern particleType_t currentParticleType;

// Prototypes
void initParticles(void);
void deinitParticles(void);
void updateParticles(void);
void drawParticles(void);
void addParticles(int x, int y, int radius);
void clearParticleScreen(void);

#endif // PARTICLE_H
