#!/usr/bin/env python

#Librarys
###########################################################################################
import sys
import gtk
import os
import hildon
import re
import urllib2
import socket
import commands
import gobject
from BeautifulSoup import BeautifulSoup

#Classes
###########################################################################################
class Main:
	def __init__(self):
		self.Translator = Translator(self)
		self.Settings = Settings(self)
		self.About = About(self)
		self.connectToInternet()
		self.drawMainWindow()

	def drawMainWindow(self):
		#Create window
		self.win = hildon.StackableWindow()
		self.win.connect("delete_event", self.quit)
		gtk.set_application_name("Sanakirja.org")

		#Create menu
		menu = hildon.AppMenu()
		self.menuButtons = []
		self.menuButtons.append(hildon.GtkButton(gtk.HILDON_SIZE_AUTO))
		self.menuButtons.append(hildon.GtkButton(gtk.HILDON_SIZE_AUTO))
		self.menuButtons[0].set_label("Settings")
		self.menuButtons[1].set_label("About")
		self.menuButtons[0].connect("clicked", self.Settings.open)
		self.menuButtons[1].connect("clicked", self.About.open)
		menu.append(self.menuButtons[0])
		menu.append(self.menuButtons[1])
	 	menu.show_all()
		self.win.set_app_menu(menu)

		#Main content
		vbox = gtk.VBox(False, 0)
		hbox = gtk.HBox(False, 0)
		#Text entry
		self.input = hildon.Entry(gtk.HILDON_SIZE_AUTO)
		#Buttons
		self.translateButtons = []
		self.translateButtons.append(hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL))
		self.translateButtons.append(hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL))
		self.translateButtons[0].set_image(gtk.image_new_from_file("flags/"+self.Settings.config[0]+".png"))
		self.translateButtons[1].set_image(gtk.image_new_from_file("flags/"+self.Settings.config[1]+".png"))
		self.translateButtons[0].set_text(self.Settings.config[0], "from "+self.Settings.config[1])
		self.translateButtons[1].set_text(self.Settings.config[1], "from "+self.Settings.config[0])
		self.translateButtons[0].connect("clicked", self.translate, "1")
		self.translateButtons[1].connect("clicked", self.translate, "2")
		hbox.pack_start(self.input, True, True, 0)
		hbox.pack_start(self.translateButtons[0], False, False, 0)
		hbox.pack_start(self.translateButtons[1], False, False, 0)
		panArea = hildon.PannableArea()
		#Output area
		self.output = []
		self.output.append(gtk.Label())
		self.output.append(gtk.Label())
		self.output[0].set_markup("<b>Search for word..</b>");
  		self.output[0].set_alignment(0,0)
  		self.output[1].set_alignment(0,0)
		panArea.add_with_viewport(self.output[1])
		vbox.pack_start(hbox, False, False, 0)
		vbox.pack_start(self.output[0], False, False, 0)
		vbox.pack_start(panArea, True, True, 0)
		self.win.add(vbox)

		#Draw window
		self.win.show_all()
		gtk.main()

	#Ask for internet connection, if we don't have one
	def connectToInternet(self):
		try:
			s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
			s.connect(("sanakirja.org",80))
		except:
			commands.getoutput("dbus-send --system --type=method_call --dest=com.nokia.icd_ui /com/nokia/icd_ui com.nokia.icd_ui.show_conn_dlg boolean:false")

	#Translate word with translator-class
	def translate(self, event, to):
		text = self.input.get_text().rstrip().lstrip()
		self.input.set_text(text)
		if to == "1":
			self.Translator.translate(self.Settings.config[1], self.Settings.config[0], text)
		elif to == "2":
			self.Translator.translate(self.Settings.config[0], self.Settings.config[1], text)

	#Shut down application
	def quit(self, ignore1, ignore2):
		self.Settings.saveSettings()
		gtk.main_quit()

#About dialog
class About:
	def __init__(self, parent):
		self.Parent = parent

	#Open it
	def open(self, ignore):
		dialog = gtk.AboutDialog()
		dialog.set_name("Sanakirja.org")
		dialog.set_logo_icon_name("sanakirja.org")
		dialog.set_authors(("Olli Laasonen [admin@laasonen.net]",""))
		dialog.set_documenters(("Olli Laasonen [admin@laasonen.net]",""))
		dialog.set_artists(("Eugen Buzuk [eugen.buzuk@gmail.com]","Salvador Lopez [simiographics@yahoo.com]", "Olli Laasonen [admin@laasonen.net]"))
		dialog.set_comments("A Sanakirja.org dictionary client.")
		dialog.set_version("0.4.1")
		dialog.set_license("This program is free software; you can redistribute it and/or\nmodify it under the terms of the GNU General Public License\nas published by the Free Software Foundation; either version 2\nof the License, or (at your option) any later version.")
		dialog.set_copyright("(c) Olli Laasonen")
		dialog.set_website("http://laasonen.net/")
		dialog.show()

#Translator class
class Translator:
	def __init__(self, parent):
		self.Parent = parent

	#Translator itself
	def translate(self, lang1, lang2, word):
		#Do we have anything to translate
		if len(word)>0:
			#Try to translate
			try:
				self.Parent.output[0].set_label("")
				self.Parent.output[1].set_label("")
				req=urllib2.Request(url="http://www.sanakirja.org/search.php?q="+word+"&l="+str(self.Parent.Settings.languages[lang1])+"&l2="+str(self.Parent.Settings.languages[lang2]), headers={'User-Agent':'Mozilla/5.0(Windows; U; Windows NT 5.1; en-US; rv:1.6) Gecko/20040113'})
				response = urllib2.urlopen(req)
				soup = BeautifulSoup(response.read())
				words = []
				for table in soup.findAll('table', attrs={'class':'translations'}):
					if table:
						soup2 = BeautifulSoup(str(table))
						for link in soup2.findAll('a'):
							p = re.compile(r'<.*?>')
							link = p.sub('', str(link))
							if link != "":
								words.append(link)
				#Succeeded to translate
				if len(words)>0:
					output = ""
					id=0
					for word2 in words:
						id += 1;
						if id == 1:
							output += "<b>"+str(id)+":</b> "+word2
						else:
							output += "\n<b>"+str(id)+":</b> "+word2
					self.Parent.output[0].set_markup("<b>Translated '"+word+"' from "+lang1+" to "+lang2+":</b>")
					self.Parent.output[1].set_markup(output)
				#Failed to translate: bad word?
				else:
					self.Parent.output[0].set_label("<b>Couldn't translate word: "+word+". Did you spell it right?</b>")
			#Failed to translate: bad connection?
			except:
				self.Parent.output[0].set_label("<b>Couldn't translate word: "+word+". Check your connection.</b>")
				self.Parent.connectToInternet()
		#Nothing to translate
		else:
			self.Parent.output[0].set_label("<b>You have to write something first.</b>")
			self.Parent.output[1].set_label("")

#Setting class
class Settings:
	def __init__(self, parent):
		self.Parent = parent
		self.loadSettings()
		self.selectors = False
		#Supported languages
		self.languages = {
			"Bulgarian":1,
			"Czech":19,
			"Danish":18,
			"Dutch":23,
			"English":3,
			"Esperanto":5,
			"Estonian":2,
			"Finnish":17,
			"French":14,
			"German":16,
			"Greek":7,
			"Hungarian":21,
			"Italian":6,
			"Japanese":24,
			"Latin":8,
			"Latvian":9,
			"Lithuanian":10,
			"Norwegian":11,
			"Polish":13,
			"Portuguese":12,
			"Russian":22,
			"Spanish":4,
			"Swedish":15,
			"Turkish":20
		}
		#self.languages = sorted(self.languages.iterkeys())

	#Load settings from settings-file
	def loadSettings(self):
		if os.path.exists("/home/user/.sanakirja.org") == False:
			os.mkdir("/home/user/.sanakirja.org")
		if os.path.exists("/home/user/.sanakirja.org/default-languages") == False:
			db = open("/home/user/.sanakirja.org/default-languages", "w")
			db.write("Finnish|English")
			db.close()
		db = open("/home/user/.sanakirja.org/default-languages", "r")
		languages = db.readline().replace("\n", "").split("|")
		db.close()
		self.config = [languages[0], languages[1]]

	#Save settings to settings-file
	def saveSettings(self):
		if os.path.exists("/home/user/.sanakirja.org") == False:
			os.mkdir("/home/user/.sanakirja.org")
		db = open("/home/user/.sanakirja.org/default-languages", "w")
		db.write(self.config[0]+"|"+self.config[1])
		db.close()

	#Open settings dialog
	def open(self, ignore):
		self.selectors = False
		window = gtk.Dialog("Settings", self.Parent.win)
		window.set_geometry_hints(min_height=80)
		#save_button = window.add_button(gtk.STOCK_SAVE, gtk.RESPONSE_OK)
		hbox = gtk.HBox(False, 2)
		self.selectors = [self.createLanguageSelector("Language 1", 0), self.createLanguageSelector("Language 2", 1)]
		hbox.pack_start(self.selectors[0], expand=True)
		hbox.pack_start(self.selectors[1], expand=True)
		panArea = hildon.PannableArea()
		panArea.add_with_viewport(hbox)
		window.vbox.add(panArea)
		window.show_all()

	#Create language picker
	def createLanguageSelector(self, title, id):
		selector = hildon.TouchSelector()
		lstore = gtk.ListStore(gtk.gdk.Pixbuf, gobject.TYPE_STRING)

		index = 0
		selected = 0
		for language in sorted(self.languages.iterkeys()):
			if str(self.config[id]) == language:
				selected = index
			index += 1
			liter = lstore.append()
			lstore.set(liter, 1, language, 0, self.setPix("flags/"+language+".png"))

		renderer = gtk.CellRendererPixbuf()
		column = selector.append_column(lstore, renderer)
		column.add_attribute(renderer, "pixbuf", 0)

		renderer = gtk.CellRendererText()
		column.pack_start(renderer, True)
		column.add_attribute(renderer, "text", 1)
		column.set_property("text-column", 1)
		selector.connect("changed", self.selectionChanged, id)

		picker = hildon.PickerButton(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		picker.set_selector(selector)
		picker.set_text(title, self.config[id])
		picker.set_image(gtk.image_new_from_file("flags/"+self.config[id]+".png"))
		#picker.set_text(titles[setting], subtitles[setting] % self.config[setting])
		picker.set_name('HildonButton-finger')
		picker.set_alignment(0,0,1,1)
		selector.set_active(0, selected)
		return picker

	#Help function
	def setPix(self, filename):
		#print filename
		pixbuf = gtk.gdk.pixbuf_new_from_file(filename)
		#print pixbuf
		return pixbuf

	#Change settings
	def selectionChanged(self, selector, button, id):
		if self.selectors:
			self.config[id] = selector.get_current_text();
			if id == 0:
				self.selectors[0].set_image(gtk.image_new_from_file("flags/"+selector.get_current_text()+".png"))
				self.Parent.translateButtons[0].set_title(selector.get_current_text())
				self.Parent.translateButtons[0].set_image(gtk.image_new_from_file("flags/"+selector.get_current_text()+".png"))
				self.Parent.translateButtons[1].set_text(self.config[1], "from "+selector.get_current_text())
			elif id == 1:
				self.selectors[1].set_image(gtk.image_new_from_file("flags/"+selector.get_current_text()+".png"))
				self.Parent.translateButtons[1].set_title(selector.get_current_text())
				self.Parent.translateButtons[1].set_image(gtk.image_new_from_file("flags/"+selector.get_current_text()+".png"))
				self.Parent.translateButtons[0].set_text(self.config[0], "from "+selector.get_current_text())

#Run
###########################################################################################
if __name__ == "__main__":
	os.chdir("/opt/sanakirja.org/")
	Main()
