#!/usr/bin/env python

#Librarys
###########################################################################################
import sys
import gtk
import os
import hildon
import re
import urllib2
from BeautifulSoup import BeautifulSoup

#Classes
###########################################################################################
class Main:
	def __init__(self):
		self.Translator = Translator(self)
		self.Settings = Settings(self)
		self.About = About(self)
		self.drawMainWindow()

	def drawMainWindow(self):
		#Create window
		self.win = hildon.StackableWindow()
		self.win.connect("delete_event", gtk.main_quit)
		gtk.set_application_name("Sanakirja.org")
		#Create menu
		menu = hildon.AppMenu()
		self.menuButtons = []
		self.menuButtons.append(hildon.GtkButton(gtk.HILDON_SIZE_AUTO))
		self.menuButtons.append(hildon.GtkButton(gtk.HILDON_SIZE_AUTO))
		self.menuButtons[0].set_label("Settings")
		self.menuButtons[1].set_label("About")
		self.menuButtons[0].connect("clicked", self.Settings.open)
		self.menuButtons[1].connect("clicked", self.About.open)
		menu.append(self.menuButtons[0])
		menu.append(self.menuButtons[1])
	 	menu.show_all()
		self.win.set_app_menu(menu)
		#Main content
		vbox = gtk.VBox(False, 0)
		hbox = gtk.HBox(False, 0)
		self.input = hildon.Entry(gtk.HILDON_SIZE_AUTO)
		self.translateButtons = []
		self.translateButtons.append(hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL))
		self.translateButtons.append(hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL))
		self.translateButtons[0].set_title(self.Settings.languages[self.Settings.config["language1"]][1])
		self.translateButtons[1].set_title(self.Settings.languages[self.Settings.config["language2"]][1])
		self.translateButtons[0].connect("clicked", self.translate, "1")
		self.translateButtons[1].connect("clicked", self.translate, "2")
		hbox.pack_start(self.input, True, True, 0)
		hbox.pack_start(self.translateButtons[0], False, False, 0)
		hbox.pack_start(self.translateButtons[1], False, False, 0)
		self.output = []
		self.output.append(gtk.Label())
		self.output.append(gtk.Label())
		self.output[0].set_markup("<b>Search for word..</b>");
  		self.output[0].set_alignment(0,0)
  		self.output[1].set_alignment(0,0)
		vbox.pack_start(hbox, False, False, 0)
		vbox.pack_start(self.output[0], False, False, 0)
		vbox.pack_start(self.output[1], True, True, 0)
		self.win.add(vbox)
		#Draw window
		self.win.show_all()
		gtk.main()

	def translate(self, event, to):
		if to == "1":
			self.Translator.translate(self.Settings.config["language2"], self.Settings.config["language1"], self.input.get_text())
		elif to == "2":
			self.Translator.translate(self.Settings.config["language1"], self.Settings.config["language2"], self.input.get_text())
		

class About:
	def __init__(self, parent):
		self.Parent = parent

	def open(self, ignore):
		dialog = gtk.AboutDialog()
		dialog.set_name("Sanakirja.org")
		dialog.set_logo_icon_name("sanakirja.org")
		dialog.set_authors(("Olli Laasonen [admin@laasonen.net]",""))
		dialog.set_comments("Sanakirja.org translator.")
		dialog.set_version("0.2.0")
		dialog.set_license("This program is free software; you can redistribute it and/or\nmodify it under the terms of the GNU General Public License\nas published by the Free Software Foundation; either version 2\nof the License, or (at your option) any later version.")
		dialog.set_copyright("(c) Olli Laasonen")
		dialog.set_website("http://laasonen.net/")
		dialog.show()

class Translator:
	def __init__(self, parent):
		self.Parent = parent

	def translate(self, lang1, lang2, word):
		self.Parent.output[0].set_label("")
		self.Parent.output[1].set_label("")
		req=urllib2.Request(url="http://www.sanakirja.org/search.php?q="+word+"&l="+str(self.Parent.Settings.languages[lang1][0])+"&l2="+str(self.Parent.Settings.languages[lang2][0]), headers={'User-Agent':'Mozilla/5.0(Windows; U; Windows NT 5.1; en-US; rv:1.6) Gecko/20040113'})
		response = urllib2.urlopen(req)
		soup = BeautifulSoup(response.read())
		words = []
		for table in soup.findAll('table', attrs={'class':'translations'}):
			if table:
				soup2 = BeautifulSoup(str(table))
				for link in soup2.findAll('a'):
					p = re.compile(r'<.*?>')
					link = p.sub('', str(link))
					if link != "":
						words.append(link)
		if len(words)>0:
			output = ""
			id=0
			for word2 in words:
				id += 1;
				if id == 1:
					output += "<b>"+str(id)+":</b> "+word2
				else:
					output += "\n<b>"+str(id)+":</b> "+word2
			self.Parent.output[0].set_markup("<b>Translated '"+word+"' in to "+lang2+":</b>")
			self.Parent.output[1].set_markup(output)
		else:
			self.Parent.output[0].set_label("<b>Couldn't translate word '"+word+"' in to "+lang2+". Did you spell it right?</b>")

class Settings:
	def __init__(self, parent):
		self.Parent = parent
		self.config = {"language1":"Finnish", "language2":"English"}
		self.languages = {
			"Bulgarian":[1,"BGR"],
			"Czech":[19,"CZE"],
			"Danish":[18,"DAN"],
			"Dutch":[23,"NLD"],
			"English":[3,"ENG"],
			"Esperanto":[5,"EPO"],
			"Estonian":[2,"EST"],
			"Finnish":[17,"FIN"],
			"French":[14,"FRA"],
			"German":[16,"DEU"],
			"Greek":[7,"GRC"],
			"Hungarian":[21,"HUN"],
			"Italian":[6,"ITA"],
			"Japanese":[24,"JPN"],
			"Latin":[8,"LAT"],
			"Latvian":[9,"LAV"],
			"Lithuanian":[10,"LIT"],
			"Norwegian":[11,"NOR"],
			"Polish":[13,"POL"],
			"Portuguese":[12,"PRT"],
			"Russian":[22,"RUS"],
			"Spanish":[4,"ESP"],
			"Swedish":[15,"SWE"],
			"Turkish":[20,"TUR"]
		}

	def open(self, ignore):
		window = gtk.Dialog("Settings", self.Parent.win)
		window.set_geometry_hints(min_height=150)
		#save_button = window.add_button(gtk.STOCK_SAVE, gtk.RESPONSE_OK)
		self.vbox = gtk.VBox(False, 2)
		self.picker("Language 1", self.languages, "language1")
		self.picker("Language 2", self.languages, "language2")
		panArea = hildon.PannableArea()
		panArea.add_with_viewport(self.vbox)
		window.vbox.add(panArea)
		window.show_all()

	def selector(self, choices, setting):
		selector = hildon.TouchSelector(text=True)
		index = 0
		for item in choices:
			iter = selector.append_text(str(item))
			if str(self.config[setting]) == str(item): 
				selector.set_active(0, index)
			index += 1
		selector.connect("changed", self.selection_changed, setting)
		return selector

	def picker(self, title, array, setting):
		array2 = []
		for key, item in array.iteritems():
			array2.append(key)
		array = array2
		picker = hildon.PickerButton(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		selector = self.selector(array, setting)
		picker.set_selector(selector)
		picker.set_title(title)
		#picker.set_text(titles[setting], subtitles[setting] % self.config[setting])
		picker.set_name('HildonButton-finger')
		picker.set_alignment(0,0,1,1)
		self.vbox.pack_start(picker, expand=False)

	def selection_changed(self, selector, button, setting):
		self.config[setting] = selector.get_current_text();
		if setting == "language1":
			self.Parent.translateButtons[0].set_title(self.languages[selector.get_current_text()][1])
		elif setting == "language2":
			self.Parent.translateButtons[1].set_title(self.languages[selector.get_current_text()][1])

#Run
###########################################################################################
if __name__ == "__main__":
	os.chdir("/opt/sanakirja.org/")
	Main()
