#!/usr/bin/env python

import sys
import re
import urllib2
from threading import Thread
from BeautifulSoup import BeautifulSoup
try:  
	import pygtk  
	pygtk.require("2.0")  
except:  
	pass  
try:  
	import gtk  
	import gtk.glade  
except:  
	print("NO GTK/GLADE")
	sys.exit(1)
		
class Main:
	def __init__(self):
		self.Translator = Translator(self)
		self.Translator.start()
		self.wTree = gtk.glade.XML("sanakirja.org.glade")
		dic = {
			"on_buttonFin_clicked":self.translateToFinnish,
			"on_buttonEng_clicked":self.translateToEnglish,
			"on_windowMain_destroy":self.quit
		}
		self.wTree.signal_autoconnect(dic)
		gtk.main()

	def translateToFinnish(self, event):
		self.Translator.translate("eng", "fin", self.wTree.get_widget("input").get_text())

	def translateToEnglish(self, event):
		self.Translator.translate("fin", "eng", self.wTree.get_widget("input").get_text())

	def quit(self, widget):
		sys.exit(0)

class Translator(Thread):
	def __init__(self, parent):
		Thread.__init__(self)
		self.Parent = parent
		self.languages = {
			"eng":["English", 3],
			"fin":["Finnish", 17],
		}

	def translate(self, lang1, lang2, word):
		self.Parent.wTree.get_widget("input").set_sensitive(False)
		self.Parent.wTree.get_widget("fin").set_sensitive(False)
		self.Parent.wTree.get_widget("eng").set_sensitive(False)
		self.Parent.wTree.get_widget("output1").set_label("<b>Translating '"+word+"' in to "+str(self.languages[lang2][0])+"..</b>")
		self.Parent.wTree.get_widget("output2").set_label("")
		#f = urllib.urlopen("http://www.sanakirja.org/search.php?q="+word+"&l="+str(self.languages[lang1][1])+"&l2="+str(self.languages[lang2][1]))
		#soup = BeautifulSoup(f.read())
		req=urllib2.Request(url="http://www.sanakirja.org/search.php?q="+word+"&l="+str(self.languages[lang1][1])+"&l2="+str(self.languages[lang2][1]), headers={'User-Agent':'Mozilla/5.0(Windows; U; Windows NT 5.1; en-US; rv:1.6) Gecko/20040113'})
		response = urllib2.urlopen(req)
		soup = BeautifulSoup(response.read())
		words = []
		for table in soup.findAll('table', attrs={'class':'translations'}):
			if table:
				soup2 = BeautifulSoup(str(table))
				for link in soup2.findAll('a'):
					p = re.compile(r'<.*?>')
					link = p.sub('', str(link))
					if link != "":
						words.append(link)
		if len(words)>0:
			output = ""
			id=0
			for word2 in words:
				id += 1;
				if id == 1:
					output += "<b>"+str(id)+":</b> "+word2
				else:
					output += "\n<b>"+str(id)+":</b> "+word2
			self.Parent.wTree.get_widget("output1").set_label("<b>Translated '"+word+"' in to "+str(self.languages[lang2][0])+":</b>")
			self.Parent.wTree.get_widget("output2").set_label(output)
		else:
			self.Parent.wTree.get_widget("output1").set_label("<b>Couldn't translate word '"+word+"' in to "+str(self.languages[lang2][0])+". Did you spell it right?</b>")
		self.Parent.wTree.get_widget("input").set_sensitive(True)
		self.Parent.wTree.get_widget("fin").set_sensitive(True)
		self.Parent.wTree.get_widget("eng").set_sensitive(True)
		
		
Main()
