#include "settings.h"
#include <QDebug>

Settings::Settings()
{
    QSettings m_settings("MaemoSab.ini", QSettings::IniFormat);

    m_settings.beginGroup("connection");
    qDebug() << "Settings()";
}

QString Settings::getAPIkey()
{
    qDebug() << "getAPIkey";
    return m_settings.value("apikey","").toString();
}

bool Settings::setAPIkey(QString apikey)
{
    qDebug() << "setAPIkey: "+apikey;
    m_settings.setValue("apikey",apikey);
    return true;
}

int Settings::getPort()
{
    qDebug() << "getPort";
    if(m_settings.contains("port"))
        return m_settings.value("port").toInt();
    return 8080;
}

bool Settings::setPort(QString port)
{
    qDebug() << "setPort: "+port;
    bool gelukt = false;
    int portnumber = port.toInt(&gelukt);
    if(gelukt)
    {
        m_settings.setValue("port",portnumber);
        return true;
    }
    return false;
}

QString Settings::getAdress()
{
    qDebug() << "getAdress";
    return m_settings.value("address","localhost").toString();
}

QString Settings::getUsername()
{
    qDebug() << "getUsername";
    return m_settings.value("username","").toString();
}

bool Settings::setUsername(QString username)
{
    m_settings.setValue("username",username);
    return true;
}

QString Settings::getPassword()
{
    qDebug() << "getPassword";
    return m_settings.value("password","").toString();
}

bool Settings::setPassword(QString password)
{
    m_settings.setValue("password",password);
    return true;
}


bool Settings::setAddress(QString adress)
{
    qDebug() << "setAddress: "+adress;
    m_settings.setValue("address",adress);
    return true;
}

Settings::~Settings()
{
  m_settings.endGroup();
}
