#include "historydetails.h"
#include "ui_historydetails.h"
#include <QLabel>
#include <QDebug>
#include <QDateTime>

HistoryDetails::HistoryDetails(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::HistoryDetails)
{
    ui->setupUi(this);
    //ui->verticalLayout->so
    //ui->scrollArea->setw
}

HistoryDetails::~HistoryDetails()
{
    delete ui;
}

void HistoryDetails::setHistoryInfo(QMap<QString,QString> info)
{
    qDebug() << "setHistoryInfo";
    this->info = info;
    /*int teller = 1;

    QMapIterator <QString,QString> i(info);
    while (i.hasNext()) {
        i.next();

        qDebug() << "setHistoryInfo: "+i.key() + " - " + i.value();

        QLabel * la = new QLabel(i.key().toAscii());
        ui->gridLayout->addWidget(la,teller,1);
        QLabel * lb = new QLabel(i.value());
        ui->gridLayout->addWidget(lb,teller,2);
        teller++;
    }*/
    ui->lblName->setText(info["name"]);
    ui->lblPath->setText(info["path"]);
    ui->lblSize->setText(info["size"]);
    ui->lblStatus->setText(info["status"]);

    QDateTime timestamp;
    timestamp.setTime_t(info["completed"].toUInt());
    ui->lblCompleted->setText(timestamp.toString(Qt::SystemLocaleLongDate));

    ui->lblDownloadtime->setText(secondsToString(info["download_time"].toInt()));
    ui->lblPostprocess->setText(secondsToString(info["postproc_time"].toInt()));

    if(info.contains("fail_message") && info["fail_message"].length()>0)
        ui->lblFailmessage->setText(info["fail_message"]);
    else {
        ui->lblFailmessage->hide();
        ui->lblFailmessageTitle->hide();
    }

    qDebug() << "setHistoryInfo end";
}

QString HistoryDetails::secondsToString(int seconds)
{
    QString retval;
    QDate nullDate(2000, 1, 1);
    QDateTime nullTime = QDateTime::QDateTime(nullDate);
    QDateTime timestamp = nullTime.addSecs(seconds);
    int days = nullTime.daysTo(timestamp);
    if(days==1)
        retval.append("1 day, ");
    else if (days>1)
        retval.append(QString::number(days)).append(" days, ");

    QTime timeTime = timestamp.time();

    int hours = timeTime.hour();
    if(days>0 && hours==0)
        retval.append("0 hours, ");
    else if(days>0 || hours==1)
        retval.append("1 hour, ");
    else if(days>0 || hours>1)
        retval.append(QString::number(hours)).append(" hours, ");

    int minutes = timeTime.minute();
    if((days>0 || hours>0) && minutes==0)
            retval.append("0 minutes and ");
    else if((days>0 || hours>0) && minutes==1)
        retval.append("1 minute and ");
    else if(days>0 || hours>0 || minutes>1)
        retval.append(QString::number(minutes)).append(" minutes and ");

    int secs = timeTime.second();
    if((days>0 || hours>0 || minutes>0) && secs==0)
        retval.append("0 seconds");
    else if((days>0 || hours>0 || minutes>0) && secs==1)
        retval.append("1 second");
    else if((days>0 || hours>0 || minutes>0) && secs>1)
        retval.append(QString::number(secs)).append(" seconds");

    return retval;
}
