#ifndef CONFIG_H
#define CONFIG_H

/*
  RulerJinni - A simple virtual ruler
  Copyright (C) 2009  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Dlg/ActionDialog.h>

#include <Lum/Model/Action.h>
#include <Lum/Model/Number.h>
#include <Lum/Model/String.h>
#include <Lum/Model/Table.h>

class Settings : public Lum::Dlg::ActionDialog
{
private:
  Lum::Model::ActionRef      okAction;
  Lum::Model::ULongRef       choice;
  Lum::Model::StringTableRef choices;
  Lum::Model::ULongRef       setting;
  Lum::Model::ULongRef       preset;
  Lum::Model::StringTableRef presets;
  Lum::Model::StringRef      factor;
  Lum::Model::StringRef      unit;

  bool                       success;

public:
  Settings();

  Lum::Object* GetContent();
  void GetActions(std::vector<Lum::Dlg::ActionInfo>& actions);

  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);

  bool HasSuccess() const;

  static bool GetSettings(Lum::OS::Window* parent);
};

extern Lum::Model::DoubleRef factor;
extern Lum::Model::StringRef unit;

extern bool LoadConfig();
extern bool SaveConfig();

#endif
