/*
  RulerJinni - A simple virtual ruler
  Copyright (C) 2009  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Base/L10N.h>
#include <Lum/Base/String.h>

#include <Lum/AppInfo.h>
#include <Lum/Button.h>
#include <Lum/Dialog.h>
#include <Lum/Panel.h>
#include <Lum/Space.h>

#include <Lum/Dlg/About.h>
#include <Lum/Dlg/Msg.h>

#include <Lum/Model/Action.h>

#include <Lum/OS/Main.h>

#include "Configuration.h"
#include "GameArea.h"

#include "config.h"

#include <iostream>

static Lum::AppInfo info;

class MainDialog : public Lum::Dialog
{
private:
  Lum::Model::ActionRef settingsAction;
  Lum::Model::ActionRef aboutAction;

  GameArea              *gameArea;

public:
  MainDialog()
  : settingsAction(new Lum::Model::Action),
    aboutAction(new Lum::Model::Action)
  {
    Observe(settingsAction);
    Observe(aboutAction);
    Observe(GetOpenedAction());
    Observe(GetClosedAction());
  }

  void PreInit()
  {
    gameArea=new GameArea();
    gameArea->SetFlex(true,true);
    //gameArea->SetModel(gameArea);
    SetMain(gameArea);

    Lum::MenuDesc *menu=new Lum::MenuDesc();

    menu
      ->AddMenuItemSub(_ld(menuProject))
        ->AddMenuItemAction(_ld(menuProjectQuit),Lum::OS::qualifierControl,L"q",GetClosedAction());
    menu
      ->AddMenuItemSub(_ld(menuEdit))
        ->AddMenuItemAction(_ld(menuEditSettings),settingsAction);
    menu
      ->AddMenuItemSub(_ld(menuHelp))
        ->AddMenuItemAction(_ld(menuHelpAbout),aboutAction);

    SetMenu(menu);

    Dialog::PreInit();
  }

  void Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==GetOpenedAction() && GetOpenedAction()->IsFinished()) {
      if (!LoadConfig()) {
        Lum::Dlg::Msg::ShowOk(GetWindow(),
                              L"Please initially define screen size!",
                              L"For correct functioning the application initially\n"
                              L"requires you to enter the correct screen width\n"
                              L"together with the choosen unit in the following\n"
                              L"dialog.\n"
                              L"You can later on change the settings again, using\n"
                              L"the \"Settings\" menu item!");

        if (Settings::GetSettings(GetWindow())) {
          SaveConfig();
        }
      }
    }
    else if (model==GetClosedAction() && GetClosedAction()->IsFinished()) {
    }
    else if (model==settingsAction && settingsAction->IsFinished()) {
      if (Settings::GetSettings(GetWindow())) {
        SaveConfig();
      }
    }
    else if (model==aboutAction && aboutAction->IsFinished()) {
      Lum::Dlg::About::Show(this,info);
    }

    Dialog::Resync(model,msg);
  }
};

class Main : public Lum::OS::MainDialog<MainDialog>
{
public:
  Main()
  {
    info.SetProgram(Lum::Base::StringToWString(PACKAGE_NAME));
    info.SetVersion(Lum::Base::StringToWString(PACKAGE_VERSION));
    info.SetDescription(L"Measure the world...");
    info.SetAuthor(L"Tim Teulings");
    info.SetContact(L"Tim Teulings <tim@teulings.org>");
    info.SetCopyright(L"(c) 2009, Tim Teulings");
    info.SetLicense(L"GNU Public License");
  }

  bool Prepare()
  {
    return Lum::OS::MainDialog<MainDialog>::Prepare();
  }

  void Cleanup()
  {
    Lum::OS::MainDialog<MainDialog>::Cleanup();
  }
};

LUM_MAIN(Main,Lum::Base::StringToWString(PACKAGE_NAME))

