#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4.QtGui import *
from PyQt4.QtCore import *
import math
import station

_RAYON = station._RAYON
_TEMPS_ANIM = 1000
_TEMPS_CLICK = 750

#FOND = View

class Fond(QGraphicsView):

    def __init__(self, parent=None):
        super(Fond, self).__init__(parent)

        self.Scale = 1.0
        self.myFirstPoint = QPoint(0,0)
        self.myCurrentPoint = QPoint(0,0)
        self.myFirstScale  = 1.0
        self.myOrig = QPointF(400, 200)
        self.moved = False
        self.dblClicked = False

        self.animSeq = QSequentialAnimationGroup()
        self.animSeq.finished.connect(self.animSeq.clear)
        
        self.animPar = QParallelAnimationGroup()
        self.animPar.finished.connect(self.animPar.clear)


###Events

    def resizeEvent ( self, event ):
        self.emit(SIGNAL("resized()"))

    def mousePressEvent(self,event):
        self.emit(SIGNAL("pressed()"))
        QGraphicsView.mousePressEvent (self, event)
        
    def mouseDoubleClickEvent(self, event):
        self.dblClicked = True
        self.myFirstPoint = event.pos()
        self.myCurrentPoint = event.pos()
        QObject.connect(self, SIGNAL("position(QPointF)"), self.zoom)
        QGraphicsView.mouseDoubleClickEvent (self, event)


    def mouseReleaseEvent(self,event):
        self.emit(SIGNAL("released()"))
        QObject.disconnect(self, SIGNAL("position(QPointF)"), self.zoom)
        if QRect( self.myFirstPoint-QPoint(5,5) , self.myFirstPoint+QPoint(5,5)).contains(self.myCurrentPoint)  and self.dblClicked:
            self.dblClicked = False
            self.scene().doubleClick(self.mapToScene(event.pos()))
        else:
            self.dblClicked = False
            self.moved = False
        QGraphicsView.mouseReleaseEvent (self, event)
            

    def mouseMoveEvent(self,event):
        self.moved = True
        self.emit(SIGNAL("position(QPointF)"),event.posF())
        self.myCurrentPoint = event.pos()
        QGraphicsView.mouseMoveEvent (self, event)

###Actions

    def decalage(self,i):
        self.translate(i*2000,200)
        self.update() 

    def dist(self,A,B):
        return math.sqrt((A.x() - B.x())**2 + (A.y() - B.y())**2)
        
        
    def zoom(self,point):
        centre = QPointF(0,0)
        scale = self.dist(point,centre) / self.dist(self.myFirstPoint,centre) 
        self.multScale(scale)

    def multScale(self,scale):
        self.Scale = max(min(self.Scale * scale**.5, 5.),.21)
        if self.Scale != 5. and self.Scale != .21:
            self.scale( scale**.5, scale**.5)
#            self.emit(SIGNAL("zoom(float)"),scale**.5)
            self.update()
            
    def getScale(self):
        return self.Scale

    scaling = pyqtProperty(float, fget=getScale, fset=multScale)
        
    def setCenter(self,point):
        self.centerOn(point)
       
    def getCenter(self):
        return self.mapToScene(self.rect().center())

    center = pyqtProperty(QPointF, fget=getCenter, fset=setCenter)
    
    def goTo(self,point,scale,sign=1):

        self.animPar.stop()
        self.animPar.clear()
    
        anim = QPropertyAnimation (self, "center")
        anim.setDuration(_TEMPS_ANIM*2)
        anim.setEasingCurve(QEasingCurve.OutQuad)
        anim.setKeyValueAt(0, self.getCenter())
        anim.setKeyValueAt(1, point)
        self.animPar.addAnimation(anim)
        
        val = (2./scale)**(sign*.05)
        anim2 = QPropertyAnimation (self, "scaling")
        anim2.setDuration(_TEMPS_ANIM*2)
        anim2.setEasingCurve(QEasingCurve.Linear)
        anim2.setKeyValueAt(0, val)
        anim2.setKeyValueAt(1, val)
        self.animPar.addAnimation(anim2)
        

        

#CARTE  = Scene   

class Carte(QGraphicsScene):
    fond = QGraphicsRectItem ()
    fond.setBrush(QBrush(QColor(0,0,0,153)))

    def doubleClick  ( self, p ):
        self.emit(SIGNAL("dblclicked(QPointF)"),p)
        
    def blur(self):
        self.fond.setRect(self.sceneRect())
        self.addItem(self.fond)

    def unblur(self):
        self.removeItem(self.fond)


      
      
#Panneau Station  

class PanStation(QLabel):   
    def __init__(self, parent=None):
        super(PanStation, self).__init__(parent)

        self.state = False
        self.setFont(QFont ( "Nokia Sans",_RAYON*2  ))
        self.setAlignment(Qt.AlignCenter)
        self.setStyleSheet("background-color: qlineargradient(x1:-0.5, y1:-0.5, x2:1, y2:1, stop:0 white,  stop:1 palette(highlight)) ; color: palette(highlighted-text) ;border:3px solid gray; border-top-style: none; border-right-style: none")

        self.animX = QPropertyAnimation (self, "pos")
        self.animX.setDuration(_TEMPS_ANIM/5)
        self.animX.setEasingCurve(QEasingCurve.OutBack)

        self.animY = QPropertyAnimation (self, "pos")
        self.animY.setDuration(_TEMPS_ANIM/5)
        self.animY.setEasingCurve(QEasingCurve.OutBack)


    def playX(self,w,text=''):
        y = self.y()
        if not self.state and text != '':
            size = self.fontMetrics().size(Qt.TextSingleLine,text)
            
            self.resize(size.width()+_RAYON*2,70)
            self.setText(text)
            self.animX.setKeyValueAt(0, QPoint(900,y))
            self.animX.setKeyValueAt(1, QPoint(w-min(290,self.width()),y) )
            self.emit(SIGNAL("showing(int)"),-1)
            self.state = True
            self.animX.start()

        elif self.text() != '':
            self.setText(text)
            self.animX.setKeyValueAt(0, QPoint(w-min(290,self.width()),y))
            self.animX.setKeyValueAt(1, QPoint(900,y))
            self.emit(SIGNAL("showing(int)"),1)
            self.state = False
            self.animX.start()


    def mouseReleaseEvent(self,event):
        self.emit(SIGNAL("released(QString)"),self.text())
        QLabel.mouseReleaseEvent (self, event)


#Panneau  Action

class PanAction(QLabel):   
    def __init__(self, parent=None):
        super(PanAction, self).__init__(parent)
        
        self.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/statusarea_sharing_pending.png"))
        self.setScaledContents( True )
        self.setMargin(0)
        self.toggle = False
        self.text = ''
        self.state = False
        
        
        self.animX = QPropertyAnimation (self, "pos")
        self.animX.setDuration(_TEMPS_ANIM/5)
        self.animX.setEasingCurve(QEasingCurve.OutBack)

        self.animMargin = QPropertyAnimation (self, "margin")
        self.animMargin.setDuration(_TEMPS_ANIM)
        self.animMargin.setEasingCurve(QEasingCurve.OutBounce)
        self.animMargin.setKeyValueAt(0, 30)
        self.animMargin.setKeyValueAt(1, 6)


    def mousePressEvent(self,event):
        self.animMargin.setEasingCurve(QEasingCurve.OutElastic)
        self.animMargin.setKeyValueAt(0, 0)
        self.animMargin.start()
        if not self.toggle:
            self.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/statusarea_sharing.png"))
        QLabel.mousePressEvent (self, event)

        
    def toggling(self):
        self.toggle = True
        self.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/camera_playback.png"))
        self.animMargin.setEasingCurve(QEasingCurve.OutBounce)
        self.animMargin.setKeyValueAt(0, 20)
        self.animMargin.start()

    def mouseReleaseEvent(self,event):
        if not self.toggle:
            self.emit(SIGNAL("colorise"))
        else:
            self.emit(SIGNAL("play"))
        QLabel.mouseReleaseEvent (self, event)

    def playX(self,w,text=''):
        

        y = self.y()
        if not self.state and text != '':
            
            self.text = text
            self.animX.setKeyValueAt(0, QPoint(900,y))
            self.animX.setKeyValueAt(1, QPoint(w-100,y) )
            self.state = True
            self.animX.start()
            self.animMargin.start()

        elif self.text != '':
            self.text = text
            self.animX.setKeyValueAt(0, QPoint(w-100,y))
            self.animX.setKeyValueAt(1, QPoint(900,y))
            self.state = False
            self.toggle = False
            self.animX.start()
            self.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/statusarea_sharing_pending.png"))

#Boutton Du GPS

class GpsButton(QLabel):   
    def __init__(self, parent=None):
        super(GpsButton, self).__init__(parent)
        self.pixNo = QPixmap("/usr/share/icons/hicolor/48x48/hildon/location_applet_off.png")
        self.pixOn = QPixmap("/usr/share/icons/hicolor/48x48/hildon/location_applet_track_start.png")
        self.pixGood = QPixmap("/usr/share/icons/hicolor/48x48/hildon/location_applet_track_stop_ani.png")
        self.pixOff = QPixmap("/usr/share/icons/hicolor/48x48/hildon/sketch_circle.png")
        
        self.setPixmap (  self.pixNo)
        self.state = False
        
        
        self.click = QTimer(self)
        self.click.setSingleShot (True )
        
    def center(self):
        #if self.state:
        self.emit(SIGNAL("gpsCenter"))
        self.click.stop()

    def mouseDoubleClickEvent(self, event):
        self.changeState()
        QLabel.mouseDoubleClickEvent (self, event)
        
    def mouseReleaseEvent(self,event):
        self.click.stop()
        QLabel.mouseReleaseEvent (self, event)
        

    def mousePressEvent(self,event):
        self.click.stop()
        self.click.start(_TEMPS_CLICK)
        QLabel.mousePressEvent (self, event)
        
    def setPix(self,t):
        if t == 'On':
            self.setPixmap (  self.pixOn)
        elif t == 'Good':
            self.setPixmap (  self.pixGood)
        elif t == 'Off':
            self.setPixmap (  self.pixOff)
        elif t == 'No':
            self.setPixmap (  self.pixNo)
        

    def changeState(self):
        self.click.stop()
        if self.state:
            
            self.emit(SIGNAL("gpsOff"))
            self.setPix('Off')
#            QObject.disconnect(self.click, SIGNAL("timeout()"), self.center)
            self.state = False

        else:
            self.emit(SIGNAL("gpsOn"))
            self.setPix('On')
            QObject.connect(self.click, SIGNAL("timeout()"), self.center)
            self.state = True



#Point du GPS        
        
class Gps(QGraphicsEllipseItem):
    def __init__(self, parent=None):
        super(Gps, self).__init__()
        
        self.setRect(0.,0., _RAYON*1, _RAYON*1)
        
        self.setBrush(Qt.green)

        gradient = QRadialGradient(0,0, _RAYON*1.5)
        gradient.setColorAt(1, Qt.black)
        gradient.setColorAt(0, Qt.red)
        self.setPen(QPen(gradient, _RAYON))
        self.state = False
        
    def width(self):
        return self.rect().width()

    def height(self):
        return self.rect().height()

    def selec(self):
        gradient = QRadialGradient(0,0, _RAYON*1.5)
        gradient.setColorAt(0, Qt.white)
        gradient.setColorAt(1, Qt.red)
        self.setPen(QPen( gradient, _RAYON))
        
   
    def deselec(self):
        gradient = QRadialGradient(0,0, _RAYON*1.5)
        gradient.setColorAt(1, Qt.black)
        gradient.setColorAt(0, Qt.red)
        self.setPen(QPen(gradient, _RAYON))
        
        

class diagAmbig(QWidget):   
    def __init__(self, liste, parent=None):
        super(diagSearch, self).__init__(parent)
        self.hide()
        self.setGeometry(0,0,parent.width(),400)
        self.Layout = QVBoxLayout(self)
        
        self.Line = QListWidget(self)

        self.Line.setStyleSheet("border-left:8px solid white; color: white;")
        self.Line.setGeometry(self.width()/2-150,40,300,48)


class diagLigne(QWidget):   
    def __init__(self, already, portrait, parent=None):
        super(diagLigne, self).__init__(parent)

        self.hide()
        QObject.connect(self.parent(), SIGNAL("pressed()"), self.close)

        self.Layout = QVBoxLayout(self)

        self.LayoutBouton = QHBoxLayout()
        self.Metro = QPushButton("M",self)
        self.Metro.setSizePolicy(QSizePolicy(QSizePolicy.Maximum, QSizePolicy.Maximum))
        self.Metro.setMaximumSize(72,72)
        self.Metro.setCheckable(True)
        self.Metro.setStyleSheet("QPushButton {font: bold 32px;border:8px solid white;color:white;border-radius: 35px;} QPushButton:checked {background-color: white;color:black;}")
        self.LayoutBouton.addWidget(self.Metro)
        
        self.Rer = QPushButton("R",self)
        self.Rer.setSizePolicy(QSizePolicy(QSizePolicy.Maximum, QSizePolicy.Maximum))
        self.Rer.setMaximumSize(72,72)
        self.Rer.setCheckable(True)
        self.Rer.setStyleSheet("QPushButton {font: bold 32px;border:8px solid white;color:white;border-radius: 35px;} QPushButton:checked {background-color: white;color:black;}")
        self.LayoutBouton.addWidget(self.Rer)
        
        self.Tout = QPushButton("Tout",self)
        self.Tout.setSizePolicy(QSizePolicy(QSizePolicy.Maximum, QSizePolicy.Maximum))
        self.Tout.setMaximumSize(96,72)
        self.Tout.setStyleSheet("QPushButton {font: bold 32px;border:8px solid white;color:black;border-radius: 35px;background-color: white;} QPushButton:pressed {background-color: blue;border-color:blue;}")
        self.LayoutBouton.addWidget(self.Tout)
        
        self.Aucun = QPushButton("Rien",self)
        self.Aucun.setSizePolicy(QSizePolicy(QSizePolicy.Maximum, QSizePolicy.Maximum))
        self.Aucun.setMaximumSize(96,72)
        self.Aucun.setStyleSheet("QPushButton {font: bold 32px;border:8px solid white;color:white;border-radius: 35px;} QPushButton:pressed {color:red;border-color:red;}")
        self.LayoutBouton.addWidget(self.Aucun)
        
        self.Tout.clicked.connect(self.selectAll)
        self.Aucun.clicked.connect(self.selectNone)
        self.Metro.toggled.connect(self.selectMetro)
        self.Rer.toggled.connect(self.selectRer)
        
        self.LayoutMetro = QGridLayout()
        self.Layout.addLayout(self.LayoutMetro)
        if portrait:
            self.buildMetro(4)
            self.setGeometry(10,44,460,600)
        else:
            self.buildMetro(8)
            self.setGeometry(100,00,600,440)

        self.LayoutRer = QHBoxLayout()
        self.Layout.addLayout(self.LayoutRer)
        i=0
        lettre = ["A","B","C","D","E"]
        for color in [station.RERA,station.RERB,station.RERC,station.RERD,station.RERE]:
            boutton = QPushButton(lettre[i],self)
            boutton.setSizePolicy(QSizePolicy(QSizePolicy.Maximum, QSizePolicy.Maximum))
            boutton.setMaximumSize(64,64)
            boutton.setCheckable(True)
            boutton.setStyleSheet("QPushButton {border-radius: 32px;font: bold 32px;border:8px solid "+color.name()+";color:"+color.name()+";} QPushButton:checked {background-color: "+color.name()+";color:white;}")
            self.LayoutRer.addWidget(boutton)
            i += 1

        i = 0
        self.LayoutTram = QHBoxLayout()
        self.Layout.addLayout(self.LayoutTram)
        lettre = ["T1","T2","T3","T4"]
        for color in [station.LigneT1,station.LigneT2,station.LigneT3,station.LigneT4]:
            boutton = QPushButton(lettre[i],self)
            boutton.setSizePolicy(QSizePolicy(QSizePolicy.Maximum, QSizePolicy.Maximum))
            boutton.setMaximumSize(64,64)
            boutton.setCheckable(True)
            boutton.setStyleSheet("QPushButton {border-radius: 32px;font: bold 32px;border:8px solid "+color.name()+";color:"+color.name()+";} QPushButton:checked {background-color: "+color.name()+";color:white;}")
            self.LayoutTram.addWidget(boutton)
            i += 1
        self.Layout.addLayout(self.LayoutBouton)

        i=0
        j=0
        for idx in already:
            if idx < 16:
                self.LayoutMetro.itemAt(idx).widget().setChecked(True)
                i += idx
            elif idx < 21:
                self.LayoutRer.itemAt(idx-16).widget().setChecked(True)
                j+=idx
            else:
                self.LayoutTram.itemAt(idx-21).widget().setChecked(True)
        if i == 120:
            self.Metro.setChecked(True)
        if j == 90:
            self.Rer.setChecked(True)
            
#######Construction
    def buildMetro(self,N):
        i = 0       
        for color in [station.Ligne1,station.Ligne2,station.Ligne3,station.Ligne4,station.Ligne5,station.Ligne6,station.Ligne7,station.Ligne8,station.Ligne9,station.Ligne10,station.Ligne11,station.Ligne12,station.Ligne13,station.Ligne14,station.Ligne3b,station.Ligne7b]:
            button = QPushButton(str(i+1),self)
            if i == 14:
                button.setText('3b')
            elif i == 15:
                button.setText('7b')
            button.setSizePolicy(QSizePolicy(QSizePolicy.Maximum, QSizePolicy.Maximum))
            button.setMaximumSize(64,64)
            button.setCheckable(True)
            button.setStyleSheet("QPushButton {font: bold 32px;border:8px solid "+color.name()+";color:"+color.name()+";border-radius: 32px;} QPushButton:checked {background-color: "+color.name()+";color:white;}")
            self.LayoutMetro.addWidget(button,i/N,i % N)
            i += 1
              
    def selectMetro(self,b):
        for j in range(16):
            self.LayoutMetro.itemAt(j).widget().setChecked(b)

    def selectRer(self,b):
        for j in range(5):
            self.LayoutRer.itemAt(j).widget().setChecked(b)


    def selectAll(self):
        self.Metro.setChecked(True)
        self.Rer.setChecked(True)
        for idx in range(25):
            if idx < 16:
                self.LayoutMetro.itemAt(idx).widget().setChecked(True)
            elif idx < 21:
                self.LayoutRer.itemAt(idx-16).widget().setChecked(True)
            else:
                self.LayoutTram.itemAt(idx-21).widget().setChecked(True)

    def selectNone(self):
        self.Metro.setChecked(False)
        self.Rer.setChecked(False)
        for idx in range(25):
            if idx < 16:
                self.LayoutMetro.itemAt(idx).widget().setChecked(False)
            elif idx < 21:
                self.LayoutRer.itemAt(idx-16).widget().setChecked(False)
            else:
                self.LayoutTram.itemAt(idx-21).widget().setChecked(False)
   
    def orientation(self):
        if self.LayoutMetro.columnCount() == 8:
            for idx in range(16):
                self.LayoutMetro.itemAt(idx).widget().deleteLater()
            self.buildMetro(4)
            self.setGeometry(10,44,460,600)
        else:
            for idx in range(16):
                self.LayoutMetro.itemAt(idx).widget().deleteLater()
            self.buildMetro(8)
            self.setGeometry(100,00,600,440)

    def closeEvent(self,event):
        selec = []
        for idx in range(25):
            if idx < 16:
                if self.LayoutMetro.itemAt(idx).widget().isChecked():
                    selec.append(idx)
            elif idx < 21:
                if self.LayoutRer.itemAt(idx-16).widget().isChecked():
                    selec.append(idx)
            else:
                if self.LayoutTram.itemAt(idx-21).widget().isChecked():
                    selec.append(idx)
        self.emit(SIGNAL("selection(PyQt_PyObject)"),selec)
        QObject.disconnect(self.parent(), SIGNAL("pressed()"), self.close)
        QWidget.closeEvent (self, event)

        

class diagAbout(QWidget):   
    def __init__(self, parent=None):
        super(diagAbout, self).__init__(parent)
#        self.setWindowTitle("Rtap : \xc0 Propos")
        self.setGeometry(100,60,600,300)

        self.Layout = QGridLayout(self)
        self.Titre = QLabel(' Rtap ',self)
        self.Titre.setFont(QFont('Nokia Sans',48))
        self.Titre.setSizePolicy(QSizePolicy(QSizePolicy.Maximum, QSizePolicy.Fixed))
        self.Logo = QLabel(self)
        self.Logo.setPixmap(QPixmap("/usr/share/pixmaps/Rtap_About.png"))
        self.Logo.setAlignment(Qt.AlignCenter)
        self.Text = QLabel(''', les transports \xe0 Paris sur le N900 avec les doigts!

(C) 2011 LGPL
Ahc\xe8ne 'Opax' Boubekki
opax.gm@gmail.com
Veuillez reporter les bugs \xe0 la m\xeame adresse, merci!''',self)
        self.Text.setFont(QFont('Nokia Sans',18))
        self.Text.setWordWrap(True)
        
        self.Layout.addWidget(self.Titre,0,0)
        self.Layout.addWidget(self.Logo,1,0)
        self.Layout.addWidget(self.Text,0,1,2,1)

        self.Fond = QGraphicsRectItem (parent.sceneRect())
        self.Fond.setBrush(QBrush(QColor(0,0,0,153)))
        
    def draw(self):
        QObject.connect(self.parent(), SIGNAL("pressed()"), self.close)
        self.parent().scene().blur()
        self.show()
        
    def close ( self ):
        QObject.disconnect(self.parent(), SIGNAL("pressed()"), self.close)
        self.parent().scene().unblur()
        self.hide()
