#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4.QtGui import *
from PyQt4.QtCore import *
import math
import station

_RAYON = station._RAYON
_TEMPS_ANIM = 1000
_TEMPS_CLICK = 750

#FOND = View

class Fond(QGraphicsView):

    def __init__(self, parent=None):
        super(Fond, self).__init__(parent)

        self.Scale = 1.0
        self.myFirstPoint = QPoint(0,0)
        self.myCurrentPoint = QPoint(0,0)
        self.myFirstScale  = 1.0
        self.myOrig = QPointF(400, 200)
        self.moved = False
        self.dblClicked = False

        self.animSeq = QSequentialAnimationGroup()
        self.animSeq.finished.connect(self.animSeq.clear)
        
        self.animPar = QParallelAnimationGroup()
        self.animPar.finished.connect(self.animPar.clear)


###Events

    def resizeEvent ( self, event ):
        self.emit(SIGNAL("resized()"))

        
    def mouseDoubleClickEvent(self, event):
        self.dblClicked = True
        self.myFirstPoint = event.pos()
        self.myCurrentPoint = event.pos()
        QObject.connect(self, SIGNAL("position(QPointF)"), self.zoom)
        QGraphicsView.mouseDoubleClickEvent (self, event)


    def mouseReleaseEvent(self,event):
        self.emit(SIGNAL("released()"))
        QObject.disconnect(self, SIGNAL("position(QPointF)"), self.zoom)
        if QRect( self.myFirstPoint-QPoint(5,5) , self.myFirstPoint+QPoint(5,5)).contains(self.myCurrentPoint)  and self.dblClicked:
            self.dblClicked = False
            self.scene().doubleClick(self.mapToScene(event.pos()))
        else:
            self.dblClicked = False
            self.moved = False
        QGraphicsView.mouseReleaseEvent (self, event)
            

    def mouseMoveEvent(self,event):
        self.moved = True
        self.emit(SIGNAL("position(QPointF)"),event.posF())
        self.myCurrentPoint = event.pos()
        QGraphicsView.mouseMoveEvent (self, event)

###Actions

    def decalage(self,i):
        self.translate(i*2000,200)
        self.update() 

    def dist(self,A,B):
        return math.sqrt((A.x() - B.x())**2 + (A.y() - B.y())**2)
        
        
    def zoom(self,point):
        centre = QPointF(0,0)
        scale = self.dist(point,centre) / self.dist(self.myFirstPoint,centre) 
        self.multScale(scale)

    def multScale(self,scale):
        self.Scale = max(min(self.Scale * scale**.5, 5.),.21)
        if self.Scale != 5. and self.Scale != .21:
            self.scale( scale**.5, scale**.5)
#            self.emit(SIGNAL("zoom(float)"),scale**.5)
            self.update()
            
    def getScale(self):
        return self.Scale

    scaling = pyqtProperty(float, fget=getScale, fset=multScale)
        
    def setCenter(self,point):
        self.centerOn(point)
       
    def getCenter(self):
        return self.mapToScene(self.rect().center())

    center = pyqtProperty(QPointF, fget=getCenter, fset=setCenter)
    
    def goTo(self,point,scale,sign=1):

        self.animPar.stop()
        self.animPar.clear()
    
        anim = QPropertyAnimation (self, "center")
        anim.setDuration(_TEMPS_ANIM*2)
        anim.setEasingCurve(QEasingCurve.OutQuad)
        anim.setKeyValueAt(0, self.getCenter())
        anim.setKeyValueAt(1, point)
        self.animPar.addAnimation(anim)
        
        val = (2./scale)**(sign*.05)
        anim2 = QPropertyAnimation (self, "scaling")
        anim2.setDuration(_TEMPS_ANIM*2)
        anim2.setEasingCurve(QEasingCurve.Linear)
        anim2.setKeyValueAt(0, val)
        anim2.setKeyValueAt(1, val)
        self.animPar.addAnimation(anim2)
        

        

#CARTE  = Scene   

class Carte(QGraphicsScene):

    def doubleClick  ( self, p ):
        self.emit(SIGNAL("dblclicked(QPointF)"),p)


      
      
#Panneau Station  

class PanStation(QLabel):   
    def __init__(self, parent=None):
        super(PanStation, self).__init__(parent)

        self.state = False
        self.setFont(QFont ( "Nokia Sans",_RAYON*2  ))
        self.setAlignment(Qt.AlignCenter)
        self.setStyleSheet("background-color: qlineargradient(x1:-0.5, y1:-0.5, x2:1, y2:1, stop:0 white,  stop:1 palette(highlight)) ; color: palette(highlighted-text) ;border:3px solid gray; border-top-style: none; border-right-style: none")

        self.animX = QPropertyAnimation (self, "pos")
        self.animX.setDuration(_TEMPS_ANIM/5)
        self.animX.setEasingCurve(QEasingCurve.OutBack)

        self.animY = QPropertyAnimation (self, "pos")
        self.animY.setDuration(_TEMPS_ANIM/5)
        self.animY.setEasingCurve(QEasingCurve.OutBack)


    def playX(self,w,text=''):
        y = self.y()
        if not self.state and text != '':
            size = self.fontMetrics().size(Qt.TextSingleLine,text)
            
            self.resize(size.width()+_RAYON*2,70)
            self.setText(text)
            self.animX.setKeyValueAt(0, QPoint(900,y))
            self.animX.setKeyValueAt(1, QPoint(w-min(290,self.width()),y) )
            self.emit(SIGNAL("showing(int)"),-1)
            self.state = True
            self.animX.start()

        elif self.text() != '':
            self.setText(text)
            self.animX.setKeyValueAt(0, QPoint(w-min(290,self.width()),y))
            self.animX.setKeyValueAt(1, QPoint(900,y))
            self.emit(SIGNAL("showing(int)"),1)
            self.state = False
            self.animX.start()


    def mouseReleaseEvent(self,event):
        self.emit(SIGNAL("released(QString)"),self.text())
        QLabel.mouseReleaseEvent (self, event)


#Panneau  Action

class PanAction(QLabel):   
    def __init__(self, parent=None):
        super(PanAction, self).__init__(parent)
        
        self.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/statusarea_sharing_pending.png"))
        self.setScaledContents( True )
        self.setMargin(0)
        self.toggle = False
        self.text = ''
        self.state = False
        
        
        self.animX = QPropertyAnimation (self, "pos")
        self.animX.setDuration(_TEMPS_ANIM/5)
        self.animX.setEasingCurve(QEasingCurve.OutBack)

        self.animMargin = QPropertyAnimation (self, "margin")
        self.animMargin.setDuration(_TEMPS_ANIM)
        self.animMargin.setEasingCurve(QEasingCurve.OutBounce)
        self.animMargin.setKeyValueAt(0, 30)
        self.animMargin.setKeyValueAt(1, 6)


    def mousePressEvent(self,event):
        self.animMargin.setEasingCurve(QEasingCurve.OutElastic)
        self.animMargin.setKeyValueAt(0, 0)
        self.animMargin.start()
        if not self.toggle:
            self.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/statusarea_sharing.png"))
        QLabel.mousePressEvent (self, event)

        
    def toggling(self):
        self.toggle = True
        self.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/camera_playback.png"))
        self.animMargin.setEasingCurve(QEasingCurve.OutBounce)
        self.animMargin.setKeyValueAt(0, 20)
        self.animMargin.start()

    def mouseReleaseEvent(self,event):
        if not self.toggle:
            self.emit(SIGNAL("colorise"))
        else:
            self.emit(SIGNAL("play"))
        QLabel.mouseReleaseEvent (self, event)

    def playX(self,w,text=''):
        

        y = self.y()
        if not self.state and text != '':
            
            self.text = text
            self.animX.setKeyValueAt(0, QPoint(900,y))
            self.animX.setKeyValueAt(1, QPoint(w-100,y) )
            self.state = True
            self.animX.start()
            self.animMargin.start()

        elif self.text != '':
            self.text = text
            self.animX.setKeyValueAt(0, QPoint(w-100,y))
            self.animX.setKeyValueAt(1, QPoint(900,y))
            self.state = False
            self.toggle = False
            self.animX.start()
            self.setPixmap(QPixmap("/usr/share/icons/hicolor/48x48/hildon/statusarea_sharing_pending.png"))

#Boutton Du GPS

class GpsButton(QLabel):   
    def __init__(self, parent=None):
        super(GpsButton, self).__init__(parent)
        self.pixNo = QPixmap("/usr/share/icons/hicolor/48x48/hildon/location_applet_off.png")
        self.pixOn = QPixmap("/usr/share/icons/hicolor/48x48/hildon/location_applet_track_start.png")
        self.pixGood = QPixmap("/usr/share/icons/hicolor/48x48/hildon/location_applet_track_stop_ani.png")
        self.pixOff = QPixmap("/usr/share/icons/hicolor/48x48/hildon/sketch_circle.png")
        
        self.setPixmap (  self.pixNo)
        self.state = False
        
        
        self.click = QTimer(self)
        self.click.setSingleShot (True )
        
    def center(self):
        #if self.state:
        self.emit(SIGNAL("gpsCenter"))
        self.click.stop()

    def mouseDoubleClickEvent(self, event):
        self.changeState()
        QLabel.mouseDoubleClickEvent (self, event)
        
    def mouseReleaseEvent(self,event):
        self.click.stop()
        QLabel.mouseReleaseEvent (self, event)
        

    def mousePressEvent(self,event):
        self.click.stop()
        self.click.start(_TEMPS_CLICK)
        QLabel.mousePressEvent (self, event)
        
    def setPix(self,t):
        if t == 'On':
            self.setPixmap (  self.pixOn)
        elif t == 'Good':
            self.setPixmap (  self.pixGood)
        elif t == 'Off':
            self.setPixmap (  self.pixOff)
        elif t == 'No':
            self.setPixmap (  self.pixNo)
        

    def changeState(self):
        self.click.stop()
        if self.state:
            
            self.emit(SIGNAL("gpsOff"))
            self.setPix('Off')
#            QObject.disconnect(self.click, SIGNAL("timeout()"), self.center)
            self.state = False

        else:
            self.emit(SIGNAL("gpsOn"))
            self.setPix('On')
            QObject.connect(self.click, SIGNAL("timeout()"), self.center)
            self.state = True



#Point du GPS        
        
class Gps(QGraphicsEllipseItem):
    def __init__(self, parent=None):
        super(Gps, self).__init__()
        
        self.setRect(0.,0., _RAYON*1, _RAYON*1)
        
        self.setBrush(Qt.green)

        gradient = QRadialGradient(0,0, _RAYON*1.5)
        gradient.setColorAt(1, Qt.black)
        gradient.setColorAt(0, Qt.red)
        self.setPen(QPen(gradient, _RAYON))
        self.state = False
        
    def width(self):
        return self.rect().width()

    def height(self):
        return self.rect().height()

    def selec(self):
        gradient = QRadialGradient(0,0, _RAYON*1.5)
        gradient.setColorAt(0, Qt.white)
        gradient.setColorAt(1, Qt.red)
        self.setPen(QPen( gradient, _RAYON))
        
   
    def deselec(self):
        gradient = QRadialGradient(0,0, _RAYON*1.5)
        gradient.setColorAt(1, Qt.black)
        gradient.setColorAt(0, Qt.red)
        self.setPen(QPen(gradient, _RAYON))

class diagLigne(QDialog):   
    def __init__(self, already, parent=None):
        super(diagLigne, self).__init__(parent)


        self.setWindowTitle("Rtap : Lignes")
        self.resize(800,400)
        self.Layout = QGridLayout(self)
        
        self.List = QListWidget(self)
        self.List.setSelectionMode(QAbstractItemView.MultiSelection)
        
#        for line in ['Metro 1','Metro 2', 'Metro 3', 'Metro 4', 'Metro 5', 'Metro 6', 'Metro 7', 'Metro 8', 'Metro 9', 'Metro 10', 'Metro 11', 'Metro 12', 'Metro 13', 'Metro 14', 'Metro 3b', 'Metro 7b', 'Rer A', 'Rer B', 'Rer D', 'Rer E']:
        for line in ["Metro","RER"]:
            self.List.addItem(line)

#        for row in already:
#            self.List.item(row).setSelected ( True)


#        find = self.diagList.findItems ( self.Type.text(), QtCore.Qt.MatchContains ) 
#        if find != []:
#            self.diagList.setCurrentItem', '(find[0])
#        else:
#            self.diagList.addItem(self.Type.text())
#            self.diagList.setCurrentRow(self.diagList.count() - 1)
       
        self.Ok = QPushButton("Ok",self)
        self.Tout = QPushButton("Tout",self)
        self.Aucun = QPushButton("Aucun",self)
        
        self.Layout.addWidget(self.List,0,0,1,3)
        self.Layout.addWidget(self.Ok,1,2,1,1)
        self.Layout.addWidget(self.Aucun,1,1,1,1)
        self.Layout.addWidget(self.Tout,1,0,1,1)

        self.Ok.clicked.connect(self.close)
        self.Tout.clicked.connect(self.List.selectAll)
        self.Aucun.clicked.connect(self.List.clearSelection)

    def closeEvent(self,event):
        selec = []
        for it in self.List.selectedItems():
            selec.append(self.List.row(it))
        print selec
        self.emit(SIGNAL("selection(PyQt_PyObject)"),selec)
#        print 'closing'
        QDialog.closeEvent (self, event)
