#ifndef MARQUEELABEL_H
#define MARQUEELABEL_H

#include <QLabel>
#include <QTimer>

class MarqueeLabel : public QLabel
{
    Q_OBJECT

public:
    MarqueeLabel(QWidget *parent);
    void show();

protected: //Member Functions
        void paintEvent(QPaintEvent *evt);
        void updateCoordinates();

private: //Data Members
        int px;
        int py;
        QTimer timer;
        int speed;
        int textLength;
        int firstLength;

public slots: //Private Member Slots
        void refreshLabel();
        void setLength(int len);
        void startTime();

signals:
        void addLabel();
        void delLabel();

};

#endif // MARQUEELABEL_H







