#include "marqueelabel.h"
#include <QPainter>

MarqueeLabel::MarqueeLabel(QWidget *parent) : QLabel(parent)
{
        px = width();
        py = 20;
        speed = 1;        
        connect(&timer, SIGNAL(timeout()), this, SLOT(refreshLabel()));
        connect(this, SIGNAL(addLabel()), parent, SLOT(AddLabel()));
        connect(this, SIGNAL(delLabel()), parent, SLOT(DelLabel()));
}

void MarqueeLabel::refreshLabel()
{
        repaint();
}

void MarqueeLabel::show()
{
        QLabel::show();
}

void MarqueeLabel::startTime()
{
    firstLength = text().length();

    timer.start(20);
}

void MarqueeLabel::paintEvent(QPaintEvent *evt)
{
    if (timer.isActive())
    {
        QPainter p(this);

        textLength = p.fontMetrics().width(text(),-1);
        px -= speed;
        if (px < width()-textLength)
        {
            emit addLabel();
        }
        if (px <= -p.fontMetrics().width(text(),firstLength))
        {
            emit delLabel();
            px=0;
        }
        p.drawText(px, py, text());
        p.translate(px,0);
    }
}

void MarqueeLabel::setLength(int len)
{
        firstLength = len;
}
