import sqlite3
import os
import location

VERSION=1

def create_database():
    pass
    
    
class radar_db:

    def __init__(self):
        self.database = os.path.expanduser('~/.radars.db')
        
        if (not self.check_db()):
            self.create_db()  
        else:
            self.db_conn = sqlite3.connect(self.database)
            self.db_cursor = self.db_conn.cursor()
            
            
    def check_db(self):
        """
        Check if database exists
        """
        if os.path.isfile(self.database):
            return 1
        else:
            return 0
            
    def create_db(self):
        """
        Create the database
        """
        self.db_conn = sqlite3.connect(self.database)
        self.db_cursor = self.db_conn.cursor()
    
        # Create tables
        self.db_cursor.execute('''CREATE TABLE radars 
            (id INTEGER PRIMARY KEY, 
             latitude REAL,
             longitude REAL,              
             data TEXT)''')
            
        self.db_cursor.execute('''CREATE TABLE config 
            (id INTEGER PRIMARY KEY, 
             config_name TEXT ,
             config_value TEXT)''')
             
        # Create index
        self.db_cursor.execute('''CREATE INDEX idx_radars 
            ON radars
            (latitude, longitude)''')
            
        self.db_cursor.execute("INSERT INTO config (config_name, config_value )\
                        VALUES (\"version\", '%s')"% VERSION)
        
    
    def clear_radars(self):
        """Delete all stored data"""
        print "Clear database"
        query = "DELETE FROM radars"
        self.db_cursor.execute(query)        
        self.db_conn.commit()
        
        
    def insert_radar(self, latitude, longitude,  data):
        """Insert a record"""
        
        self.db_cursor.execute("INSERT INTO radars (latitude, longitude, data ) \
                        VALUES (%s, %s, '%s')" % (latitude, longitude, data));
        self.db_conn.commit()
        
 
    def get_nearest_radar(self,  cur_latitude,  cur_longitude):
        """Return the nearest speed camera """
        
        nearest_radar_distance = 0.5
        nearest_radar_id = -1
        nearest_radar_name = ""
        nearest_radar_latitude = 0
        nearest_radar_longitude = 0
                    
        query = "SELECT id, latitude, longitude, data \
                           FROM radars \
                           WHERE \
                           latitude > %05f AND \
                           latitude < %05f AND \
                           longitude > %05f AND \
                           longitude < %05f"\
                           % (cur_latitude - 0.2, cur_latitude + 0.2,  cur_longitude - 0.2, cur_longitude + 0.2)
        self.db_cursor.execute(query)
        rows = self.db_cursor.fetchall()
        print "Radars count : %s" % len(rows)
        if len(rows)>0:
            for row in rows:
                rid = row[0]
                rlatitude = row[1]
                rlongitude = row[2]
                rname = row[3]
                cur_distance = location.distance_between(rlatitude, rlongitude, cur_latitude, cur_longitude)
                #print "name, distance : %s, %s" % (rname,  cur_distance)
                if nearest_radar_distance > cur_distance:
                    nearest_radar_id = rid
                    nearest_radar_latitude = rlatitude
                    nearest_radar_longitude = rlongitude
                    nearest_radar_name = rname
                    nearest_radar_distance = cur_distance
            print ("Nearest radar : %s, %s, %s, %s, %s" %  (nearest_radar_id,  
                                                            nearest_radar_latitude,  
                                                            nearest_radar_longitude,  
                                                            nearest_radar_name,  
                                                            nearest_radar_distance))
        else:
            print "No radar detected"
        
        return (nearest_radar_id, nearest_radar_name, nearest_radar_distance)
