/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef RINGTONED_IS_COMPILING_APP
#error "Don't include this file directly, use ringtoned/plugin.h instead"
#endif


#ifndef __RINGTONED_FAKE_TP_OBSERVER_H__
#define __RINGTONED_FAKE_TP_OBSERVER_H__

#include <glib-object.h>


G_BEGIN_DECLS

#define RINGTONED_TYPE_FAKE_TP_OBSERVER            (ringtoned_fake_tp_observer_get_type ())
#define RINGTONED_FAKE_TP_OBSERVER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), RINGTONED_TYPE_FAKE_TP_OBSERVER, RingtonedFakeTpObserver))
#define RINGTONED_FAKE_TP_OBSERVER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), RINGTONED_TYPE_FAKE_TP_OBSERVER, RingtonedFakeTpObserverClass))
#define RINGTONED_IS_FAKE_TP_OBSERVER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RINGTONED_TYPE_FAKE_TP_OBSERVER))
#define RINGTONED_IS_FAKE_TP_OBSERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RINGTONED_TYPE_FAKE_TP_OBSERVER))
#define RINGTONED_FAKE_TP_OBSERVER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), RINGTONED_TYPE_FAKE_TP_OBSERVER, RingtonedFakeTpObserverClass))

typedef struct _RingtonedFakeTpObserver        RingtonedFakeTpObserver;
typedef struct _RingtonedFakeTpObserverClass   RingtonedFakeTpObserverClass;
typedef struct _RingtonedFakeTpObserverPrivate RingtonedFakeTpObserverPrivate;

struct _RingtonedFakeTpObserver
{
    GObject parent;

    /*< private >*/
    RingtonedFakeTpObserverPrivate *priv;
};

struct _RingtonedFakeTpObserverClass
{
    GObjectClass parent_class;
};

GType                       ringtoned_fake_tp_observer_get_type (void) G_GNUC_CONST;

RingtonedFakeTpObserver *   ringtoned_fake_tp_observer_new      (void);

G_END_DECLS

#endif /* __RINGTONED_FAKE_TP_OBSERVER_H__ */
