/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "config.h"

#include "settings-dialog.h"

static GList *widget_hooks = NULL;

static gboolean settings_dialog_constructed_replaced = FALSE;
static void (*old_settings_dialog_constructed) (GObject *object) = NULL;

static GtkContainer *
ensure_pannable_area (OssoABookSettingsDialog *dialog)
{
    GtkWidget *content_area;
    GList *children;
    GtkWidget *pannable = NULL;
    GtkWidget *box = NULL;
    GtkWidget *viewport;
    GtkWidget *child;
    GList *l;

    content_area = gtk_dialog_get_content_area (GTK_DIALOG (dialog));
    children = gtk_container_get_children (GTK_CONTAINER (content_area));
    if (children && HILDON_IS_PANNABLE_AREA (children->data))
        pannable = children->data;
    if (pannable)
    {
        viewport = gtk_bin_get_child (GTK_BIN (pannable));
        if (viewport && GTK_IS_VIEWPORT (viewport))
        {
            box = gtk_bin_get_child (GTK_BIN (viewport));
            if (!box || !GTK_IS_VBOX (box))
                box = NULL;
        }
        if (!box)
            pannable = NULL;
    }

    if (!box)
    {
        pannable = hildon_pannable_area_new ();
        hildon_pannable_area_set_size_request_policy (
                HILDON_PANNABLE_AREA (pannable), HILDON_SIZE_REQUEST_CHILDREN);
        gtk_widget_show (pannable);

        box = gtk_vbox_new (FALSE, 0);
        gtk_widget_show (box);
        hildon_pannable_area_add_with_viewport (
                HILDON_PANNABLE_AREA (pannable), box);

        for (l = children; l; l = l->next)
        {
            child = l->data;

            g_object_ref (child);
            gtk_container_remove (GTK_CONTAINER (content_area), child);
            gtk_container_add (GTK_CONTAINER (box), child);
            g_object_unref (child);
        }

        gtk_container_add (GTK_CONTAINER (content_area), pannable);
    }

    g_list_free (children);

    return GTK_CONTAINER (box);
}

static void
add_extension_widgets (OssoABookSettingsDialog *dialog)
{
    GtkContainer *box;
    GList *l;
    PCRSettingsDialogWidgetHook hook;

    box = ensure_pannable_area (dialog);
    for (l = widget_hooks; l; l = l->next)
    {
        hook = l->data;
        hook (dialog, box);
    }
}

static void
new_settings_dialog_contructed (GObject *object)
{
    OssoABookSettingsDialog *dialog = OSSO_ABOOK_SETTINGS_DIALOG (object);

    if (old_settings_dialog_constructed)
        old_settings_dialog_constructed (object);

    add_extension_widgets (dialog);
}

void
pcr_settings_dialog_add_widget_hook (PCRSettingsDialogWidgetHook hook)
{
    GObjectClass *cls;

    widget_hooks = g_list_append (widget_hooks, hook);

    if (!settings_dialog_constructed_replaced)
    {
        cls= g_type_class_ref (osso_abook_settings_dialog_get_type ());
        old_settings_dialog_constructed = cls->constructed;
        cls->constructed = new_settings_dialog_contructed;

        settings_dialog_constructed_replaced = TRUE;
    }
}
