/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __PCR_RINGTONE_CHOOSER_H__
#define __PCR_RINGTONE_CHOOSER_H__

#include <gtk/gtk.h>


G_BEGIN_DECLS

#define PCR_TYPE_RINGTONE_CHOOSER            (pcr_ringtone_chooser_get_type ())
#define PCR_RINGTONE_CHOOSER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), PCR_TYPE_RINGTONE_CHOOSER, PCRRingtoneChooser))
#define PCR_RINGTONE_CHOOSER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), PCR_TYPE_RINGTONE_CHOOSER, PCRRingtoneChooserClass))
#define PCR_IS_RINGTONE_CHOOSER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PCR_TYPE_RINGTONE_CHOOSER))
#define PCR_IS_RINGTONE_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PCR_TYPE_RINGTONE_CHOOSER))
#define PCR_RINGTONE_CHOOSER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), PCR_TYPE_RINGTONE_CHOOSER, PCRRingtoneChooserClass))

typedef struct _PCRRingtoneChooser        PCRRingtoneChooser;
typedef struct _PCRRingtoneChooserClass   PCRRingtoneChooserClass;
typedef struct _PCRRingtoneChooserPrivate PCRRingtoneChooserPrivate;

struct _PCRRingtoneChooserClass
{
    GtkDialogClass parent_class;
};

struct _PCRRingtoneChooser
{
    GtkDialog parent;

    /*< private >*/
    PCRRingtoneChooserPrivate *priv;
};

GType           pcr_ringtone_chooser_get_type  (void) G_GNUC_CONST;

GtkWidget *     pcr_ringtone_chooser_new       (GtkWindow       *parent,
                                                const gchar     *ringtone);

G_END_DECLS

#endif
