/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __RINGTONED_PLUGIN_H__
#define __RINGTONED_PLUGIN_H__

#ifndef RINGTONED_IS_COMPILING_APP
#define RINGTONED_IS_COMPILING_APP
#define MUST_UNDEF_RINGTONED_IS_COMPILING_APP
#endif

#include <gmodule.h>
#include <libringtoned/ringtoned.h>
#include <ringtoned/call.h>
#include <ringtoned/dispatcher.h>
#include <ringtoned/ringtoned-enums.h>


G_BEGIN_DECLS

#define DEFINE_RINGTONED_PLUGIN(name, init_func) \
    static gchar ringtoned_plugin_name[50] = "<unknown>"; \
    static void init_func (RingtonedDispatcher *d); \
    G_MODULE_EXPORT void ringtoned_plugin_init (RingtonedDispatcher *d); \
    G_MODULE_EXPORT const gchar * g_module_check_init (GModule *m); \
    \
    G_MODULE_EXPORT void \
    ringtoned_plugin_init (RingtonedDispatcher *dispatcher) \
    { \
        RINGTONED_DEBUG ("Initializing plugin %s for dispatcher %p", \
                ringtoned_plugin_name, dispatcher); \
        init_func (dispatcher); \
    } \
    \
    G_MODULE_EXPORT const gchar * \
    g_module_check_init (GModule *module) \
    { \
        g_strlcpy (ringtoned_plugin_name, (name), \
                G_N_ELEMENTS (ringtoned_plugin_name)); \
        RINGTONED_DEBUG ("Loaded plugin %s", ringtoned_plugin_name); \
        g_module_make_resident (module); \
        return NULL; \
    }

#define ringtoned_dispatcher_add_filter(self, \
                                        priority, \
                                        cb, \
                                        user_data, \
                                        destroy_notify_cb) \
    ringtoned_dispatcher_add_filter_real ((self), (priority), \
            ringtoned_plugin_name, #cb, (cb), (user_data), \
            (destroy_notify_cb))

#ifdef MUST_UNDEF_RINGTONED_IS_COMPILING_APP
#undef RINGTONED_IS_COMPILING_APP
#undef MUST_UNDEF_RINGTONED_IS_COMPILING_APP
#endif

G_END_DECLS

#endif /* __RINGTONED_PLUGIN_H__ */
