/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "config.h"

#include "debug.h"
#include <string.h>


void
ringtoned_debug_real (const gchar   *format,
                      ...)
{
    va_list args;
    gchar *msg;

    if (!ringtoned_debug_is_enabled ())
        return;

    va_start (args, format);
    msg = g_strdup_vprintf (format, args);
    va_end (args);

    g_print (msg);

    g_free (msg);
}

gboolean
ringtoned_debug_is_enabled (void)
{
    static gboolean initialized = FALSE;
    static gboolean enabled;
    const gchar *tmp;
    gchar *s;

    if (initialized)
        return enabled;

    initialized = TRUE;

    tmp = g_getenv ("RINGTONED_DEBUG");
    if (!tmp)
        tmp = "";
    s = g_ascii_strdown (tmp, -1);

    if (s[0] == '\0' ||
        strcmp (s, "false") == 0 ||
        strcmp (s, "no") == 0 ||
        strcmp (s, "0") == 0) {
        enabled = FALSE;
    } else {
        enabled = TRUE;
    }

    g_free (s);

    return enabled;
}
