/*************************************************************************}
{ phononsound.h - single audio file for PhononPlayer                      }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 25 May 2012                                              }
{*************************************************************************/

#ifndef PHONONSOUND_H
#define PHONONSOUND_H

#include "includes.h"
#include "equalizer.h"

class PhononPlayer;

typedef enum {
    pp_state_Idle,
    pp_state_Playing,
    pp_state_Paused,
    pp_state_Error
} PhononSoundState;

typedef enum {
    pp_stype_None,
    pp_stype_File,
    pp_stype_Memory,
    pp_stype_Remote
} PhononSoundSourceType;

class PhononSound : public QObject
{
    Q_OBJECT
public:
    explicit PhononSound(PhononPlayer *parent, bool enableEq = false);
    ~PhononSound();

    bool open(const QString& filename);
    bool play();
    void pause();
    void unpause();
    void stop();

    inline PhononSoundState getState() const {return state;}
    inline PhononSoundSourceType getSourceType() const {return sourceType;}
    inline const QString& getCurrentFilename() const {return currentFilename;}
    inline const QString& getTitle() const {return title;}
    bool setEqualizerEnabled(bool doEnable);
    inline Equalizer* getEqualizer() const {return equalizer;}

    void prepareToDie(bool doClose = true);
    void close(bool emitStop = true);
    void startTitleTimer();
    void killTitleTimer();

protected:
    void createMediaObject(bool enableEq = false);

    void timerEvent(QTimerEvent *event);

    PhononPlayer* player;
    Equalizer* equalizer;
    bool equalizerEnabled;

    QFile devFile;
    QBuffer devMem;
    QIODevice* dev;

    PhononSoundState state;
    PhononSoundSourceType sourceType;

    Phonon::MediaObject *mediaObject;
    Phonon::AudioOutput *audioOutput;
    Phonon::Path mediaPath;
    QString currentFilename;
    QString tmpFilename;
    QString title;

    int titleTimer;
    bool sentPlayEnd;
    
signals:
    void onPlayEnd();
    void onError();
    void onStateChanged();
    void onTitleChange();
    
protected slots:
    void stateChanged(Phonon::State newstate, Phonon::State oldstate);
    void onCustomPlayEnd();
    void onMetaDataChanged();
    void doCloseOnPrepareToDie();
    void prefinishMarkReached(qint32 msecs);
};

#endif // PHONONSOUND_H
