/*************************************************************************}
{ coreapp.h - QCoreApplication wrapper                                    }
{                                                                         }
{ (c) Alexey Parfenov, 2011                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This library is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This library is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 16 Nov 2012                                              }
{*************************************************************************/

#ifndef COREAPP_H
#define COREAPP_H

#include <QtCore>

#include "alkatraz.h"

#ifdef QT_GUI_LIB
#include <QtGui>
typedef QApplication CoreAppParentClass;
#else
typedef QCoreApplication CoreAppParentClass;
#endif

#ifndef Q_OS_WIN
#include "signal.h"
#else
#include "windows.h"
#endif

#ifdef QT_NETWORK_LIB
#include <QtNetwork>
#endif

enum {
#ifdef QT_NETWORK_LIB
    app_err_CreateLocalServer,
    app_err_FreeLocalServer,
    app_err_ReadFromLocalSock,
    app_err_WriteToLocalSock,
    app_err_SendToLocalServer,
    app_err_LocalSocketDisconnect
#endif
};

class CoreApp : public CoreAppParentClass, public ErrorHandler
{
    Q_OBJECT

public:
    CoreApp(int& argc, char** argv);
    static QString errorCodeToString(int errorCode);
    inline bool isQuitting() const {return quitting;}
    virtual void interrupt(int sigNum);

protected:
    bool exitAfterMain;
    bool quitting;

#ifdef QT_NETWORK_LIB
    bool singleInstance;
    QLocalServer* localServer;
    QLocalSocket* localSock;
    QStringList localSockCommands;
    QByteArray localSockBuffer;
    QString localSockName;
    virtual bool startLocalServer();
    virtual void parseLocalSockCommands(){}
    virtual bool passCommandsToLocalServer(QLocalSocket& sock);
    virtual void closeLocalSocket();
    virtual void updateLocalSockName();
#endif
    virtual int main();
    virtual void onQuit(){}

private:
    void _main();

private slots:
    void _run();
    void _onQuit();

signals:
    void onError(const QObject* realSender, const char* sourceFile, int sourceLine, int errorCode, const void* data = NULL);

protected slots:
    virtual void onGetError(const QObject* realSender, const char* sourceFile, int sourceLine, int errorCode, const void* data)
        {Q_UNUSED(realSender); Q_UNUSED(sourceFile); Q_UNUSED(sourceLine); Q_UNUSED(errorCode); Q_UNUSED(data);}
#ifdef QT_NETWORK_LIB
    virtual void onNewLocalServerConnection();
    virtual void onLocalSocketClientData();
    virtual void onLocalSockDisconnect();
#endif
};

#endif // COREAPP_H
