/*************************************************************************}
{ typeswindow.cpp - dialog with a list of supported/enabled extensions    }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 19 May 2012                                              }
{*************************************************************************/

#include "typeswindow.h"

TypesWindow::TypesWindow(QWidget *parent) :
    ContainerDialog(parent)
{
    initGui();
    buildList();
}

TypesWindow::~TypesWindow()
{
    deinitGui();
}

QStringList TypesWindow::getSupportedTypes()
{
    QSettings* ini = MAINWINDOW->getIniSettings();
    QString line = ini->value("filters/active", "").toString();
    QStringList tmpList = line.split(";", QString::SkipEmptyParts);
    QStringList extActive;
    if(tmpList.isEmpty())
    {
        extActive = PLAYER->getSupportedExtensions();
    }
    else
    {
        foreach(QString ext, tmpList)
            extActive.append(ext.trimmed().toLower());
    }
    return extActive;
}

QStringList TypesWindow::showTypesDialog()
{
    TypesWindow* win = new TypesWindow(MAINWINDOW);
    win->setWindowModality(Qt::ApplicationModal);
    QStringList list = win->showModal();
    delete win;
    return list;
}

void TypesWindow::buildList()
{
    itemsContainer->deleteAllChildren();

    QSettings* ini = MAINWINDOW->getIniSettings();
    QString line;
    QStringList tmpList;

    line = ini->value("filters/all", "").toString();

    tmpList = line.split(";", QString::SkipEmptyParts);
    QStringList extAll;
    if(tmpList.isEmpty())
    {
        extAll = PLAYER->getKnownExtensions();
    }
    else
    {
        foreach(QString ext, tmpList)
            extAll.append(ext.trimmed().toLower());
    }

    line = ini->value("filters/active", "").toString();
    tmpList = line.split(";", QString::SkipEmptyParts);
    QStringList extActive = getSupportedTypes();

    KineticListItem* item;
    foreach(QString ext, extAll)
    {
        item = new KineticListItem(itemsContainer);
        item->setText("*."+ext);
        if(extActive.indexOf(ext) >= 0)
        {
            item->setBool(true);
            item->setIcon(MAINWINDOW->getSkin().icoCheck);
        }
        else
        {
            item->setBool(false);
            item->setIcon(MAINWINDOW->getSkin().icoUncheck);
        }
        item->setString(ext);
        item->resize(itemsContainer->width(), ITEM_HEIGHT);
    }

    reposition(size());
}

void TypesWindow::initGui()
{
    ContainerDialog::initGui();
    setWindowTitle(tr("Displayed file types"));
    btnRestore = new QPushButton(this);
    btnRestore->setText(tr("Select all supported"));
    btnRestore->move(0, 0);
    connect(btnRestore, SIGNAL(clicked()), SLOT(onBtnRestoreClick()));
}

void TypesWindow::deinitGui()
{
    delete btnRestore;
    ContainerDialog::deinitGui();
}

void TypesWindow::reposition(const QSize &sz, int rows)
{
    if(sz.width() < sz.height())
        rows = 2;
    else
        rows = 3;
    btnRestore->resize(sz.width(), CONTROLBUTTON_SIZE + CONTROLBUTTON_PADDING);
    itemsContainer->move(0, btnRestore->height());
    itemsContainer->resize(sz.width(), sz.height() - btnRestore->height());
    itemsContainer->repositionChildrenV(ITEM_HEIGHT, rows);
    //ContainerDialog::reposition(sz, rows);
}

QStringList TypesWindow::showModal()
{
    showDialog();
    QStringList list;
    KineticListItem* item;
    foreach(QObject* child, itemsContainer->children())
    {
        item = (KineticListItem*)child;
        item->resize(itemsContainer->width(), ITEM_HEIGHT);
        if(item->getBool())
            list.append(item->getString());
    }

    MAINWINDOW->getIniSettings()->setValue("filters/active", list.join(";"));

    return list;
}

void TypesWindow::onItemClick(QWidget *item)
{
    KineticListItem* i = qobject_cast<KineticListItem*>(item);
    if(!i)
        return;
    if(i->getBool())
    {
        i->setBool(false);
        i->setIcon(MAINWINDOW->getSkin().icoUncheck);
    }
    else
    {
        i->setBool(true);
        i->setIcon(MAINWINDOW->getSkin().icoCheck);
    }
}

void TypesWindow::onBtnRestoreClick()
{
    const QStringList& exts = PLAYER->getSupportedExtensions();
    KineticListItem* item;
    foreach(QObject* child, itemsContainer->children())
    {
        item = qobject_cast<KineticListItem*>(child);
        if(item)
        {
            if(exts.contains(item->text().remove(0, 2)))
            {
                item->setBool(true);
                item->setIcon(MAINWINDOW->getSkin().icoCheck);
            }
            else
            {
                item->setBool(false);
                item->setIcon(MAINWINDOW->getSkin().icoUncheck);
            }
        }
    }
}
