/*************************************************************************}
{ app.cpp - application wrapper                                           }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 15 Apr 2012                                              }
{*************************************************************************/

#include "app.h"

App::App(int &argc, char **argv) : QApplication(argc, argv)
{
    randomize();
    init();
    loadTranslators();
    createUi();
}

void App::init()
{
    setApplicationName(APP_NAME);
    setApplicationVersion(APP_VERSION);

    QDir::setCurrent(applicationDirPath());

#ifndef MAEMO5
    QDir::setCurrent(QDir::currentPath()+"/../"+applicationName());
#endif
}

void App::loadTranslators()
{
    QString localeName = QLocale::system().name();

    qtTranslator = new QTranslator();
    qtTranslator->load("qt_" + localeName, QLibraryInfo::location(QLibraryInfo::TranslationsPath));
    installTranslator(qtTranslator);

    myappTranslator = new QTranslator();
#ifdef MAEMO5
    QString translationFilename("../translations/" + applicationName() + "_" + localeName);
#else
    QString translationFilename("translations/" + applicationName() + "_" + localeName);
#endif
    myappTranslator->load(translationFilename);
    installTranslator(myappTranslator);
}

void App::createUi()
{
    mainWindow = new MainWindow();
    mainWindow->showExpanded();
    mainWindow->fullyActivate();

#ifndef MAEMO5
    mainWindow->resize(600, 800);
#endif
}

App::~App()
{
    delete mainWindow;
    delete qtTranslator;
    delete myappTranslator;
}
